/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.roller.RollerAxle;
import net.railsofwar.row.stock.core.roller.RollerFrame;

public class RollerFrame2A
extends RollerFrame {
    public final float shiftFront;
    public final float shiftRear;
    public final float shiftBase;
    public RollerAxle axleFront;
    public RollerAxle axleRear;
    public RotaVec axleFrontPos;
    public RotaVec axleRearPos;

    public RollerFrame2A(World world, float posX, float posY, float posZ, float azimuth, float zenith, float radius, float shiftFront, float shiftRear, float frame2stockOffset) {
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.azimuth = azimuth;
        this.zenith = zenith;
        this.posXPrev = posX;
        this.posYPrev = posY;
        this.posZPrev = posZ;
        this.azimuthPrev = azimuth;
        this.zenithPrev = zenith;
        this.shiftFront = shiftFront;
        this.shiftRear = shiftRear;
        this.shiftBase = shiftFront - shiftRear;
        this.axleFrontPos = new RotaVec(this, 0.0f, 0.0f, shiftFront);
        this.axleRearPos = new RotaVec(this, 0.0f, 0.0f, shiftRear);
        this.axleFront = new RollerAxle(world, this.axleFrontPos, radius, radius + 0.0625f, azimuth, zenith);
        this.axleRear = new RollerAxle(world, this.axleRearPos, radius, radius + 0.0625f, azimuth, zenith);
        this.jointPos = new RotaVec(this, 0.0f, frame2stockOffset, 0.0f);
    }

    public RollerFrame2A(World world, RotaVec pos, float azimuth, float zenith, float radius, float shiftFront, float shiftRear, float truck2frameOffset) {
        this(world, pos.getX(), pos.getY(), pos.getZ(), azimuth, zenith, radius, shiftFront, shiftRear, truck2frameOffset);
    }

    @Override
    public void onUpdate() {
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        this.posZPrev = this.posZ;
        this.azimuthPrev = this.azimuth;
        this.zenithPrev = this.zenith;
        this.axleFrontPos.onUpdate();
        this.axleRearPos.onUpdate();
        this.axleFront.setPosition(this.axleFrontPos, this.azimuth, this.zenith);
        this.axleRear.setPosition(this.axleRearPos, this.azimuth, this.zenith);
        this.axleFront.onUpdate();
        this.axleRear.onUpdate();
        double dx = this.axleFront.posX - this.axleRear.posX;
        double dy = this.axleFront.posY - this.axleRear.posY;
        double dz = this.axleFront.posZ - this.axleRear.posZ;
        double px = (double)this.axleRear.posX - dx * (double)this.shiftRear / (double)this.shiftBase;
        double py = (double)this.axleRear.posY - dy * (double)this.shiftRear / (double)this.shiftBase;
        double pz = (double)this.axleRear.posZ - dz * (double)this.shiftRear / (double)this.shiftBase;
        this.setPosition(px, py, pz);
        double h = Math.sqrt(dx * dx + dz * dz);
        this.azimuth = -((float)Math.toDegrees(Math.atan2(dx, dz)));
        this.zenith = -((float)Math.toDegrees(Math.atan2(dy, h)));
        this.jointPos.onUpdate();
    }

    @Override
    public void forceRotations(float azimuth, float zenith) {
        this.azimuth = this.azimuthPrev = azimuth;
        this.zenith = this.zenithPrev = zenith;
        this.axleRear.forceRotations(azimuth, zenith);
        this.axleFront.forceRotations(azimuth, zenith);
    }

    @Override
    public void forceRotations(Entity entity) {
        this.forceRotations(entity.field_70177_z, entity.field_70125_A);
    }

    @Override
    public float getFrontAzimuth() {
        return this.axleFront.azimuth;
    }

    @Override
    public float getRearAzimuth() {
        return this.axleRear.azimuth;
    }

    @Override
    public boolean isOnSlope() {
        return this.axleRear.isOnSlope() || this.axleFront.isOnSlope();
    }

    @Override
    public boolean isOnTrack() {
        return this.axleRear.isOnTrack() || this.axleFront.isOnTrack();
    }
}

