/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;

public class RollerFrame2T2A
extends RollerFrame {
    public final float shiftFront;
    public final float shiftRear;
    public final float shiftBase;
    public RollerFrame2A truckFront;
    public RollerFrame2A truckRear;
    public RotaVec jointFrontPos;
    public RotaVec jointRearPos;

    public RollerFrame2T2A(World world, float posX, float posY, float posZ, float azimuth, float zenith, float radius, float shiftFront, float shiftRear, float frame2stockOffset, float truckBase, float truck2frameOffset) {
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.azimuth = azimuth;
        this.zenith = zenith;
        this.posXPrev = posX;
        this.posYPrev = posY;
        this.posZPrev = posZ;
        this.azimuthPrev = azimuth;
        this.zenithPrev = zenith;
        this.shiftFront = shiftFront;
        this.shiftRear = shiftRear;
        this.shiftBase = shiftFront - shiftRear;
        this.jointFrontPos = new RotaVec(this, 0.0f, 0.0f, shiftFront);
        this.jointRearPos = new RotaVec(this, 0.0f, 0.0f, shiftRear);
        this.truckFront = new RollerFrame2A(world, this.jointFrontPos, azimuth, zenith, radius, truckBase / 2.0f, -truckBase / 2.0f, truck2frameOffset);
        this.truckRear = new RollerFrame2A(world, this.jointRearPos, azimuth, zenith, radius, truckBase / 2.0f, -truckBase / 2.0f, truck2frameOffset);
        this.jointPos = new RotaVec(this, 0.0f, frame2stockOffset, 0.0f);
    }

    @Override
    public void onUpdate() {
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        this.posZPrev = this.posZ;
        this.azimuthPrev = this.azimuth;
        this.zenithPrev = this.zenith;
        this.jointFrontPos.onUpdate();
        this.jointRearPos.onUpdate();
        this.truckFront.setExternally(this.jointFrontPos);
        this.truckRear.setExternally(this.jointRearPos);
        this.truckFront.onUpdate();
        this.truckRear.onUpdate();
        float dx = this.truckFront.jointPos.getX() - this.truckRear.jointPos.getX();
        float dy = this.truckFront.jointPos.getY() - this.truckRear.jointPos.getY();
        float dz = this.truckFront.jointPos.getZ() - this.truckRear.jointPos.getZ();
        float px = this.truckRear.jointPos.getX() - dx * this.shiftRear / this.shiftBase;
        float py = this.truckRear.jointPos.getY() - dy * this.shiftRear / this.shiftBase;
        float pz = this.truckRear.jointPos.getZ() - dz * this.shiftRear / this.shiftBase;
        this.setPosition(px, py, pz);
        float h = (float)Math.sqrt(dx * dx + dz * dz);
        this.azimuth = -((float)Math.toDegrees(Math.atan2(dx, dz)));
        this.zenith = -((float)Math.toDegrees(Math.atan2(dy, h)));
        this.jointPos.onUpdate();
    }

    @Override
    public void forceRotations(float azimuth, float zenith) {
        this.azimuth = this.azimuthPrev = azimuth;
        this.zenith = this.zenithPrev = zenith;
        this.truckFront.forceRotations(azimuth, zenith);
        this.truckRear.forceRotations(azimuth, zenith);
    }

    @Override
    public void forceRotations(Entity entity) {
        this.forceRotations(entity.field_70177_z, entity.field_70125_A);
    }

    @Override
    public float getFrontAzimuth() {
        return this.truckFront.azimuth;
    }

    @Override
    public float getRearAzimuth() {
        return this.truckRear.azimuth;
    }

    @Override
    public boolean isOnSlope() {
        return this.truckRear.isOnSlope() || this.truckFront.isOnSlope();
    }

    @Override
    public boolean isOnTrack() {
        return this.truckRear.isOnTrack() || this.truckFront.isOnTrack();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderVectors(RollingStock stock, float partial) {
        UtilModels.doAxes(0.0f, 0.0f, 0.0f, 1.5f, 15);
        UtilModels.doAxes(this, partial, (Entity)stock, -0.7f, 7);
        UtilModels.doAxes(this.jointFrontPos, partial, (Entity)stock, 1.0f, 10);
        UtilModels.doAxes(this.jointRearPos, partial, (Entity)stock, 1.0f, 10);
        UtilModels.doAxes(this.truckFront.jointPos, partial, (Entity)stock, -0.5f, 7);
        UtilModels.doAxes(this.truckFront, partial, (Entity)stock, 0.25f, 7);
        UtilModels.doAxes(this.truckFront.axleFrontPos, partial, (Entity)stock, 0.4f, 4);
        UtilModels.doAxes(this.truckFront.axleFront, (Entity)stock, -0.4f, 4);
        UtilModels.doAxes(this.truckFront.axleRearPos, partial, (Entity)stock, 0.4f, 4);
        UtilModels.doAxes(this.truckFront.axleRear, (Entity)stock, -0.4f, 4);
        UtilModels.doAxes(this.truckRear.jointPos, partial, (Entity)stock, -0.5f, 7);
        UtilModels.doAxes(this.truckRear, partial, (Entity)stock, 0.25f, 7);
        UtilModels.doAxes(this.truckRear.axleFrontPos, partial, (Entity)stock, 0.4f, 4);
        UtilModels.doAxes(this.truckRear.axleFront, (Entity)stock, -0.4f, 4);
        UtilModels.doAxes(this.truckRear.axleRearPos, partial, (Entity)stock, 0.4f, 4);
        UtilModels.doAxes(this.truckRear.axleRear, (Entity)stock, -0.4f, 4);
    }
}

