/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.roller;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.roller.RollerAxle;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;

public class RollerFrameM2A1T2A
extends RollerFrame {
    public final float shiftFront;
    public final float shiftRear;
    public final float shiftBase;
    public RollerFrame2A truck;
    public RollerAxle axleFront;
    public RollerAxle axleRear;
    public RotaVec truckPos;
    public RotaVec axleFrontPos;
    public RotaVec axleRearPos;

    public RollerFrameM2A1T2A(World world, float posX, float posY, float posZ, float azimuth, float zenith, float radius, float shiftFront, float shiftRear, float bodyOffset, float shiftTruck, float truckShiftFront, float truckShiftRear) {
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.azimuth = azimuth;
        this.zenith = zenith;
        this.shiftFront = shiftFront;
        this.shiftRear = shiftRear;
        this.shiftBase = shiftFront - shiftRear;
        this.truckPos = new RotaVec(this, 0.0f, 0.0f, shiftTruck);
        this.axleFrontPos = new RotaVec(this, 0.0f, 0.0f, shiftFront);
        this.axleRearPos = new RotaVec(this, 0.0f, 0.0f, shiftRear);
        this.truck = new RollerFrame2A(world, this.truckPos, azimuth, zenith, radius, truckShiftFront, truckShiftRear, 0.0625f);
        this.axleFront = new RollerAxle(world, this.axleFrontPos, radius, radius + 0.0625f, azimuth, zenith);
        this.axleRear = new RollerAxle(world, this.axleRearPos, radius, radius + 0.0625f, azimuth, zenith);
        this.jointPos = new RotaVec(this, 0.0f, bodyOffset, 0.0f);
    }

    @Override
    public boolean isOnSlope() {
        return this.axleRear.isOnSlope() || this.axleFront.isOnSlope();
    }

    @Override
    public boolean isOnTrack() {
        return this.axleRear.isOnTrack() || this.axleFront.isOnTrack();
    }

    public float getTruckAzimuth() {
        return this.truck.azimuth;
    }

    @Override
    public float getFrontAzimuth() {
        return this.axleFront.azimuth;
    }

    @Override
    public float getRearAzimuth() {
        return this.axleRear.azimuth;
    }

    @Override
    public void onUpdate() {
        this.truckPos.onUpdate();
        this.axleFrontPos.onUpdate();
        this.axleRearPos.onUpdate();
        this.truck.setPosition(this.truckPos);
        this.axleFront.setPosition(this.axleFrontPos, this.azimuth, this.zenith);
        this.axleRear.setPosition(this.axleRearPos, this.azimuth, this.zenith);
        this.truck.onUpdate();
        this.axleFront.onUpdate();
        this.axleRear.onUpdate();
        float dx = this.axleFront.posX - this.axleRear.posX;
        float dy = this.axleFront.posY - this.axleRear.posY;
        float dz = this.axleFront.posZ - this.axleRear.posZ;
        this.setPosition(this.axleRear.posX - dx * this.shiftRear / this.shiftBase, this.axleRear.posY - dy * this.shiftRear / this.shiftBase, this.axleRear.posZ - dz * this.shiftRear / this.shiftBase);
        float h = (float)Math.sqrt(dx * dx + dz * dz);
        this.azimuth = -((float)Math.toDegrees(Math.atan2(dx, dz)));
        this.zenith = -((float)Math.toDegrees(Math.atan2(dy, h)));
        this.jointPos.onUpdate();
    }

    @Override
    public void forceRotations(float azimuth, float zenith) {
        this.azimuth = this.azimuthPrev = azimuth;
        this.zenith = this.zenithPrev = zenith;
        this.truck.forceRotations(azimuth, zenith);
    }

    @Override
    public void forceRotations(Entity entity) {
        this.forceRotations(entity.field_70177_z, entity.field_70125_A);
        this.truck.forceRotations(this.azimuth, this.zenith);
    }
}

