/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.core.valvegear;

import net.railsofwar.row.stock.core.valvegear.Valvegear;

public class Walschaert
extends Valvegear {
    public final float rEccentric;
    public final float lEccentric;
    public final float rExpansion;
    public final float lExpansion;
    public final float lLift;
    public final float lRadius;
    public final float sLift;
    public final float lCombo;
    public final float sValve;
    public final float lUnion;
    public final float lSqSum1;
    public final float lConrodSq;
    public final float rUnion;
    public final float rRev;
    public final float lSqSum2;
    public final float lSqSum3;
    public final float hValve;
    public final double k1;
    public final double k2;
    public final double r1;
    public final double r2;
    public final double sumT1;
    public final double sumT1Sq;
    public final double sLiftInv;
    public final double C1;
    public final double C2;
    public final double C3;
    public final double C4;

    public Walschaert(float rCrank, float lConrod, float iCylinder, float rEccentric, float lEccentric, float rExpansion, float lExpansion, float lLift, float lRadius, float sLift, float lCombo, float sValve, float lUnion, float rUnion, float rRev, float hValve) {
        super(rCrank, lConrod, iCylinder);
        this.rEccentric = rEccentric;
        this.lEccentric = lEccentric;
        this.rExpansion = rExpansion;
        this.lExpansion = lExpansion;
        this.lLift = lLift;
        this.lRadius = lRadius;
        this.sLift = sLift;
        this.lCombo = lCombo;
        this.sValve = sValve;
        this.lUnion = lUnion;
        this.rUnion = rUnion;
        this.rRev = rRev;
        this.hValve = hValve;
        this.lConrodSq = lConrod * lConrod;
        this.lSqSum1 = lEccentric * lEccentric - rExpansion * rExpansion;
        this.lSqSum2 = sLift * sLift - lExpansion * lExpansion;
        this.lSqSum3 = lCombo * lCombo - lUnion * lUnion;
        this.k1 = 4.0f * lExpansion * lExpansion;
        this.k2 = lExpansion * lExpansion - sLift * sLift;
        this.r1 = lRadius / sLift;
        this.r2 = sValve / lCombo;
        this.sumT1 = sLift + lExpansion;
        this.sumT1Sq = this.sumT1 * this.sumT1;
        this.sLiftInv = lRadius - sLift;
        this.C1 = sLift * sLift - lExpansion * lExpansion;
        this.C2 = 4.0f * sLift * sLift;
        this.C3 = lCombo * lCombo - lUnion * lUnion;
        this.C4 = 4.0f * lCombo;
    }
}

