/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.car;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2T2A;

public class CarSpinecar
extends RollingStock
implements IBrakeScrew {
    public RollerFrame2T2A frame;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    private float brakeScrewPercentile;
    private float brakeScrewPercentilePrev;

    public CarSpinecar(World world) {
        super(world);
        this.rearCouplerShift = 4.0625f;
        this.frontCouplerShift = 4.0625f;
        this.wheelRadii = new float[]{0.3125f, 0.3125f};
        this.driverPos = new RotaVec(this, -0.09375f, -0.5625f, -2.8125f);
        this.dismountPos = new RotaVec(this, -2.5f, -0.5625f, -2.8125f);
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.frame = new RollerFrame2T2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, 0.3125f, 1.9375f, -1.9375f, 0.25f, 1.375f, 0.34375f);
    }

    @Override
    public void updateWheels() {
        this.wheelAngle[0] = this.wheelAngle[0] + (float)Math.toDegrees(this.bogieRearSpeed / this.wheelRadii[0]);
        this.wheelAngle[1] = this.wheelAngle[1] + (float)Math.toDegrees(this.bogieFrontSpeed / this.wheelRadii[1]);
    }

    @Override
    public float getYawOffset() {
        return -180.0f;
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    public boolean shouldRiderSit() {
        return true;
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public float getBrakeScrewPercentile() {
        return this.brakeScrewPercentile;
    }

    @Override
    public void setBrakeScrewPercentile(float f) {
        this.brakeScrewPercentile = f;
    }

    @Override
    public float getBrakeScrewPercentilePrev() {
        return this.brakeScrewPercentilePrev;
    }

    @Override
    public void setBrakeScrewPercentilePrev(float f) {
        this.brakeScrewPercentilePrev = f;
    }

    @Override
    public float getBrakeScrewIncrement() {
        return 0.005f;
    }

    @Override
    public float getBrakeScrewFreeStroke() {
        return 0.0f;
    }

    @Override
    public float getBrakeScrewRevolutions() {
        return 20.0f;
    }

    @Override
    public float getBrakeScrewStroke() {
        return 0.11875f;
    }
}

