/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.loco;

import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector2f;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.sound.SoundFirebox;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.auxiliary.AuxSmoker;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;
import net.railsofwar.row.stock.core.valvegear.StephensonRadial;

public class LocoFowler
extends RollingStock
implements IRegulatorA,
IReverseA,
AuxTractor.I,
AuxSmoker.I {
    @SideOnly(value=Side.CLIENT)
    private SoundFirebox soundFirebox;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    private RollerFrame2A frame;
    public final StephensonRadial valvegear;
    private AuxTractor tractor;
    @SideOnly(value=Side.CLIENT)
    private AuxSmoker smoker;
    private int regulator;
    private boolean isRegulatorZeroed;
    private int reverse;
    private boolean isReverseZeroed;

    public LocoFowler(World world) {
        super(world);
        this.rearCouplerShift = 3.0f;
        this.frontCouplerShift = 2.375f;
        this.massBare = 16.0f;
        this.speedCap = 0.5f;
        this.wheelRadii = new float[]{0.25f, 0.25f};
        this.wheelAngle = new float[]{0.0f, 0.0f};
        this.wheelShift = new float[]{-0.53125f, 0.53125f};
        this.valvegear = new StephensonRadial(0.125f, 1.0625f, 5.0f, 7.4875f, 0.046875f, 0.89375f, 0.21875f, 0.40625f, 0.9965875f, 0.8125f, 0.375f, new Vector2f(0.375f, 0.78125f));
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.driverPos = new RotaVec(this, -0.5f, 0.1875f, -1.875f);
        this.dismountPos = new RotaVec(this, -2.5f, 0.1875f, -1.875f);
        this.frame = new RollerFrame2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, this.wheelRadii[0], 0.53125f, -0.53125f, this.frame2stockOffset);
        this.tractor = new AuxTractor<LocoFowler>(this, 1.68f, 0.01f, 15.0f, s -> s.getReverseMult() > 0.0f, (s, e) -> e * this.getReverseMultAbs() * this.getRegulatorMult());
        if (this.field_70170_p.field_72995_K) {
            this.smoker = new AuxSmoker(this, new RotaVec(this.frame, 0.0f, 2.875f, 1.21875f), this.axes.up, 10, 0.375f, 0.65f, 0.05f, 0.1f, 0.01f, 0.15f, 0.25f, 0.3f, 1.0f, f -> 80 - (int)(Math.random() * 30.0), f -> 2.0f + 8.0f * f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        super.addLoopingSounds();
        if (this.field_70170_p.field_72995_K) {
            if (this.soundFirebox == null) {
                this.soundFirebox = new SoundFirebox(this);
            }
            RoW.proxy.playSound(this.soundFirebox);
        }
    }

    @Override
    public void updateUnits() {
        super.updateUnits();
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    public AuxTractor get() {
        return this.tractor;
    }

    @Override
    public List<AuxSmoker> getSmokerList() {
        return Collections.singletonList(this.smoker);
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public int getRegulatorMax() {
        return 180;
    }

    @Override
    public int getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(int r) {
        this.regulator = r;
    }

    @Override
    public boolean getIsRegulatorZeroed() {
        return this.isRegulatorZeroed;
    }

    @Override
    public void setIsRegulatorZeroed(boolean b) {
        this.isRegulatorZeroed = b;
    }

    @Override
    public int getReverseMax() {
        return 150;
    }

    @Override
    public int getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(int r) {
        this.reverse = r;
    }

    @Override
    public boolean getIsReverseZeroed() {
        return this.isReverseZeroed;
    }

    @Override
    public void setIsReverseZeroed(boolean b) {
        this.isReverseZeroed = b;
    }
}

