/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.loco;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.sound.SoundDieselMotor;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.auxiliary.AuxSmoker;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;

public class LocoKof
extends RollingStock
implements IReverseD3,
IRegulatorD5,
AuxTractor.I,
AuxSmoker.I {
    @SideOnly(value=Side.CLIENT)
    private SoundDieselMotor soundMotor;
    private IReverseD3.EnumReserveP3 reverse = IReverseD3.EnumReserveP3.NEUTRAL;
    private IRegulatorD5.EnumRegulatorP5 regulator = IRegulatorD5.EnumRegulatorP5.STOP;
    public RotaVec frontPlate;
    public RotaVec footRight;
    public RotaVec footLeft;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    public byte nextPass;
    private RollerFrame2A frame;
    private AuxTractor tractor;
    @SideOnly(value=Side.CLIENT)
    private AuxSmoker smoker;

    public LocoKof(World world) {
        super(world);
        this.rearCouplerShift = 2.8125f;
        this.frontCouplerShift = 2.625f;
        this.massBare = 11.0f;
        this.speedCap = 0.5f;
        this.frontPlate = new RotaVec(this, -1.0f, 0.3125f, 1.25f);
        this.footRight = new RotaVec(this, -1.25f, 0.3125f, -1.75f);
        this.footLeft = new RotaVec(this, 1.25f, 0.3125f, -1.75f);
        this.driverPos = new RotaVec(this, -0.625f, -0.0f, -1.5f);
        this.dismountPos = new RotaVec(this, -2.5f, -0.0f, -1.5f);
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.frame = new RollerFrame2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, this.wheelRadii[0], 1.125f, -1.125f, this.frame2stockOffset);
        this.tractor = new AuxTractor<LocoKof>(this, 2.7f, 0.15f, 2.0f, s -> s.getReverseMult() > 0.0f, (s, e) -> e * this.getReverseMultAbs() * this.getRegulatorMult());
        if (this.field_70170_p.field_72995_K) {
            this.smoker = new AuxSmoker(this, new RotaVec(this.frame, 0.25f, 2.5f, 0.25f), this.axes.up, 5, 0.375f, 0.45f, 0.02f, 0.1f, 0.09f, 0.15f, 0.25f, 0.3f, 0.5f, f -> 60 - (int)(Math.random() * 30.0), f -> 2.0f + 8.0f * f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        super.addLoopingSounds();
        if (this.field_70170_p.field_72995_K) {
            if (this.soundMotor == null) {
                this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_0);
            }
            RoW.proxy.playSound(this.soundMotor);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void restartMotor() {
        if (this.field_70170_p.field_72995_K) {
            RoW.proxy.stopSound(this.soundMotor);
            switch (this.getRegulator()) {
                case GO_I: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_1);
                    break;
                }
                case GO_II: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_2);
                    break;
                }
                case GO_III: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_3);
                    break;
                }
                case GO_IV: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_4);
                    break;
                }
                case GO_V: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_5);
                    break;
                }
                default: {
                    this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_0);
                }
            }
            RoW.proxy.playSound(this.soundMotor);
        }
    }

    @Override
    public AuxTractor get() {
        return this.tractor;
    }

    @Override
    public List<AuxSmoker> getSmokerList() {
        return Collections.singletonList(this.smoker);
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        if (passenger.func_184187_bx() == this && this.func_184196_w(passenger) && this.passengers.get(0) == passenger) {
            return this.driverPos;
        }
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public IReverseD3.EnumReserveP3 getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(IReverseD3.EnumReserveP3 state) {
        this.reverse = state;
    }

    @Override
    public IRegulatorD5.EnumRegulatorP5 getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(IRegulatorD5.EnumRegulatorP5 state) {
        this.regulator = state;
    }

    @Override
    public boolean doSound() {
        return true;
    }
}

