/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.loco;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.sound.SoundMinelokMotor;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IRegulatorD2;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;

public class LocoMinelok
extends RollingStock
implements IReverseD3,
IRegulatorD2,
AuxTractor.I {
    @SideOnly(value=Side.CLIENT)
    private SoundMinelokMotor soundMotor;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    private RollerFrame2A frame;
    private AuxTractor tractor;
    private IReverseD3.EnumReserveP3 reverse = IReverseD3.EnumReserveP3.NEUTRAL;
    private IRegulatorD2.EnumRegulatorP2 regulator = IRegulatorD2.EnumRegulatorP2.STOP;

    public LocoMinelok(World world) {
        super(world);
        this.func_70105_a(1.625f, 1.75f);
        this.rearCouplerShift = 1.9375f;
        this.frontCouplerShift = 1.625f;
        this.massBare = 3.0f;
        this.speedCap = 0.3f;
        this.frame2stockOffset = 0.0f;
        this.wheelRadii = new float[]{0.1875f, 0.1875f};
        this.wheelAngle = new float[]{0.0f, 0.0f};
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.frame = new RollerFrame2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, this.wheelRadii[0], 0.46875f, -0.46875f, this.frame2stockOffset);
        this.tractor = new AuxTractor<LocoMinelok>(this, 1.5f, 0.01f, 15.0f, s -> s.getReverseMult() > 0.0f, (s, e) -> e * this.getReverseMultAbs() * this.getRegulatorMult());
        this.driverPos = new RotaVec(this, 0.0f, 0.125f, -1.375f);
        this.dismountPos = new RotaVec(this, -2.5f, 0.125f, -1.375f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        super.addLoopingSounds();
        if (this.field_70170_p.field_72995_K) {
            if (this.soundMotor == null) {
                this.soundMotor = new SoundMinelokMotor(this);
            }
            RoW.proxy.playSound(this.soundMotor);
        }
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        if (passenger.func_184187_bx() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        this.passengers.put(0, passenger);
    }

    @Override
    public AuxTractor get() {
        return this.tractor;
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.LinkNPinMining750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.LinkNPinMining750;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public IReverseD3.EnumReserveP3 getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(IReverseD3.EnumReserveP3 state) {
        this.reverse = state;
    }

    @Override
    public IRegulatorD2.EnumRegulatorP2 getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(IRegulatorD2.EnumRegulatorP2 state) {
        this.regulator = state;
    }

    @Override
    public boolean doSound() {
        return true;
    }
}

