/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.loco;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.sound.HandlerStockSounds;
import net.railsofwar.row.stock.client.sound.SoundFirebox;
import net.railsofwar.row.stock.client.sound.SoundShayEngine;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.auxiliary.AuxSmoker;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2T2A;
import org.apache.commons.lang3.tuple.Pair;

public class LocoShay
extends RollingStock
implements IReverseA,
IRegulatorA,
AuxTractor.I,
AuxSmoker.I {
    @SideOnly(value=Side.CLIENT)
    private SoundFirebox soundFirebox;
    public final float gearRatio = 3.0f;
    public RotaVec shaftEngineDirFrontAx;
    public RotaVec shaftEngineDirFrontRef1;
    public RotaVec shaftEngineDirFrontRef2;
    public RotaVec shaftEnginePivotFront;
    public RotaVec shaftTruckDirFrontAx;
    public RotaVec shaftTruckDirFrontRef1;
    public RotaVec shaftTruckDirFrontRef2;
    public RotaVec shaftTruckPivotFront;
    public RotaVec shaftEngineDirRearAx;
    public RotaVec shaftEngineDirRearRef1;
    public RotaVec shaftEngineDirRearRef2;
    public RotaVec shaftEnginePivotRear;
    public RotaVec shaftTruckDirRearAx;
    public RotaVec shaftTruckDirRearRef1;
    public RotaVec shaftTruckDirRearRef2;
    public RotaVec shaftTruckPivotRear;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    public RollerFrame2T2A frame;
    private AuxTractor tractor;
    @SideOnly(value=Side.CLIENT)
    private AuxSmoker smoker;
    @SideOnly(value=Side.CLIENT)
    private List<Pair<Pair<Integer, Integer>, SoundShayEngine>> loops;
    @SideOnly(value=Side.CLIENT)
    private List<Pair<Pair<Integer, Integer>, SoundShayEngine>> loops_b;
    private int reverse;
    private boolean isReverseZeroed;
    private int regulator;
    private boolean isRegulatorZeroed;

    public LocoShay(World world) {
        super(world);
        this.rearCouplerShift = 4.875f;
        this.frontCouplerShift = 4.875f;
        this.massBare = 16.609f;
        this.wheelRadii = new float[]{0.3125f, 0.3125f};
        this.wheelAngle = new float[]{45.0f, 45.0f};
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.frame = new RollerFrame2T2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, this.wheelRadii[0], 2.6875f, -2.6875f, 0.25f, 1.125f, 0.5f);
        this.frame.forceRotations(this);
        this.shaftEngineDirFrontAx = new RotaVec(this.frame, 0.0f, 0.0f, -1.0f).disableOrigin();
        this.shaftEngineDirFrontRef1 = new RotaVec(this.frame, 0.0f, 1.0f, 0.0f).disableOrigin();
        this.shaftEngineDirFrontRef2 = new RotaVec(this.frame, 1.0f, 0.0f, 0.0f).disableOrigin();
        this.shaftEnginePivotFront = new RotaVec(this.frame, -0.75f, -0.4375f, 0.75f);
        this.shaftTruckDirFrontAx = new RotaVec(this.frame.truckFront, 0.0f, 0.0f, 1.0f).disableOrigin();
        this.shaftTruckDirFrontRef1 = new RotaVec(this.frame.truckFront, 0.0f, 1.0f, 0.0f).disableOrigin();
        this.shaftTruckDirFrontRef2 = new RotaVec(this.frame.truckFront, 1.0f, 0.0f, 0.0f).disableOrigin();
        this.shaftTruckPivotFront = new RotaVec(this.frame.truckFront, -0.625f, 0.0f, -1.25f);
        this.shaftEngineDirRearAx = new RotaVec(this.frame, 0.0f, 0.0f, 1.0f).disableOrigin();
        this.shaftEngineDirRearRef1 = new RotaVec(this.frame, 0.0f, 1.0f, 0.0f).disableOrigin();
        this.shaftEngineDirRearRef2 = new RotaVec(this.frame, 1.0f, 0.0f, 0.0f).disableOrigin();
        this.shaftEnginePivotRear = new RotaVec(this.frame, -0.75f, -0.4375f, -0.75f);
        this.shaftTruckDirRearAx = new RotaVec(this.frame.truckRear, 0.0f, 0.0f, -1.0f).disableOrigin();
        this.shaftTruckDirRearRef1 = new RotaVec(this.frame.truckRear, 0.0f, 1.0f, 0.0f).disableOrigin();
        this.shaftTruckDirRearRef2 = new RotaVec(this.frame.truckRear, 1.0f, 0.0f, 0.0f).disableOrigin();
        this.shaftTruckPivotRear = new RotaVec(this.frame.truckRear, -0.625f, 0.0f, 1.25f);
        this.tractor = new AuxTractor<LocoShay>(this, 3.71f, 0.03f, 15.0f, s -> s.getReverseMult() > 0.0f, (s, e) -> e * this.getReverseMultAbs() * this.getRegulatorMult());
        if (this.field_70170_p.field_72995_K) {
            this.smoker = new AuxSmoker(this, new RotaVec(this.frame, 0.0f, 2.625f, 3.53125f), this.axes.up, 3, 0.375f, 0.65f, 0.01f, 0.04f, 0.06f, 0.15f, 0.15f, 0.3f, 2.0f, f -> 160 - (int)(Math.random() * 30.0), f -> 3.0f + 16.0f * f);
        }
        this.driverPos = new RotaVec(this, -0.625f, 0.1875f, -1.8125f);
        this.dismountPos = new RotaVec(this, -3.0f, -0.0625f, -1.8125f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        super.addLoopingSounds();
        if (this.field_70170_p.field_72995_K) {
            if (this.soundFirebox == null) {
                this.soundFirebox = new SoundFirebox(this);
            }
            RoW.proxy.playSound(this.soundFirebox);
            this.loops = new ArrayList<Pair<Pair<Integer, Integer>, SoundShayEngine>>();
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)30, (Object)35), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_030))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)35, (Object)40), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_035))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)40, (Object)50), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_040))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)50, (Object)60), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_050))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)60, (Object)75), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_060))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)75, (Object)90), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_075))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)90, (Object)105), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_090))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)105, (Object)125), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_105))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)125, (Object)150), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_125))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)150, (Object)175), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_150))));
            this.loops.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)175, (Object)300), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_175))));
            this.loops_b = new ArrayList<Pair<Pair<Integer, Integer>, SoundShayEngine>>();
            this.loops_b.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)105, (Object)125), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_105b))));
            this.loops_b.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)125, (Object)150), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_125b))));
            this.loops_b.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)150, (Object)175), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_150b))));
            this.loops_b.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)175, (Object)300), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_175b))));
            this.loops_b.add((Pair<Pair<Integer, Integer>, SoundShayEngine>)Pair.of((Object)Pair.of((Object)300, (Object)500), (Object)((Object)new SoundShayEngine(this, SoundShayEngine.shay_loop_300b))));
            for (Pair<Pair<Integer, Integer>, SoundShayEngine> p : this.loops) {
                ((SoundShayEngine)((Object)p.getRight())).silence();
                RoW.proxy.playSound((MovingSound)p.getRight());
            }
            for (Pair<Pair<Integer, Integer>, SoundShayEngine> p : this.loops_b) {
                ((SoundShayEngine)((Object)p.getRight())).silence();
                RoW.proxy.playSound((MovingSound)p.getRight());
            }
        }
    }

    private void silenceLoops(boolean l, boolean lb) {
        if (l) {
            for (Pair<Pair<Integer, Integer>, SoundShayEngine> p : this.loops) {
                ((SoundShayEngine)((Object)p.getRight())).silence();
            }
        }
        if (lb) {
            for (Pair<Pair<Integer, Integer>, SoundShayEngine> p : this.loops_b) {
                ((SoundShayEngine)((Object)p.getRight())).silence();
            }
        }
    }

    @Override
    public void updateUnits() {
        super.updateUnits();
        if (this.shaftEngineDirFrontAx != null) {
            this.shaftEngineDirFrontAx.onUpdate();
        }
        if (this.shaftEngineDirFrontRef1 != null) {
            this.shaftEngineDirFrontRef1.onUpdate();
        }
        if (this.shaftEngineDirFrontRef2 != null) {
            this.shaftEngineDirFrontRef2.onUpdate();
        }
        if (this.shaftEnginePivotFront != null) {
            this.shaftEnginePivotFront.onUpdate();
        }
        if (this.shaftTruckDirFrontAx != null) {
            this.shaftTruckDirFrontAx.onUpdate();
        }
        if (this.shaftTruckDirFrontRef1 != null) {
            this.shaftTruckDirFrontRef1.onUpdate();
        }
        if (this.shaftTruckDirFrontRef2 != null) {
            this.shaftTruckDirFrontRef2.onUpdate();
        }
        if (this.shaftTruckPivotFront != null) {
            this.shaftTruckPivotFront.onUpdate();
        }
        if (this.shaftEngineDirRearAx != null) {
            this.shaftEngineDirRearAx.onUpdate();
        }
        if (this.shaftEngineDirRearRef1 != null) {
            this.shaftEngineDirRearRef1.onUpdate();
        }
        if (this.shaftEngineDirRearRef2 != null) {
            this.shaftEngineDirRearRef2.onUpdate();
        }
        if (this.shaftEnginePivotRear != null) {
            this.shaftEnginePivotRear.onUpdate();
        }
        if (this.shaftTruckDirRearAx != null) {
            this.shaftTruckDirRearAx.onUpdate();
        }
        if (this.shaftTruckDirRearRef1 != null) {
            this.shaftTruckDirRearRef1.onUpdate();
        }
        if (this.shaftTruckDirRearRef2 != null) {
            this.shaftTruckDirRearRef2.onUpdate();
        }
        if (this.shaftTruckPivotRear != null) {
            this.shaftTruckPivotRear.onUpdate();
        }
        if (this.driverPos != null) {
            this.driverPos.onUpdate();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void adaptSounds(float rpm) {
        float p;
        float v;
        float r1;
        float r0;
        float a = 105.0f;
        float b = 175.0f;
        for (Pair<Pair<Integer, Integer>, SoundShayEngine> pair : this.loops) {
            r0 = ((Integer)((Pair)pair.getLeft()).getLeft()).intValue();
            r1 = ((Integer)((Pair)pair.getLeft()).getRight()).intValue();
            float f = rpm <= a ? 1.0f : (v = rpm >= b ? 0.0f : (b - rpm) / (b - a));
            if (rpm > r0 && rpm <= r1) {
                p = 1.0f + 0.5f * ((rpm - r0) / r0);
                ((SoundShayEngine)((Object)pair.getRight())).set(v, p);
                continue;
            }
            ((SoundShayEngine)((Object)pair.getRight())).silenceTarget();
        }
        for (Pair<Pair<Integer, Integer>, SoundShayEngine> pair : this.loops_b) {
            r0 = ((Integer)((Pair)pair.getLeft()).getLeft()).intValue();
            r1 = ((Integer)((Pair)pair.getLeft()).getRight()).intValue();
            float f = rpm <= a ? 0.0f : (v = rpm >= b ? 1.0f : (rpm - a) / (b - a));
            if (rpm > r0 && rpm <= r1) {
                p = 1.0f + 0.5f * ((rpm - r0) / r0);
                ((SoundShayEngine)((Object)pair.getRight())).set(v, p);
                continue;
            }
            ((SoundShayEngine)((Object)pair.getRight())).silenceTarget();
        }
    }

    @Override
    public void updateWheels() {
        this.crankRPM = UtilMath.toRevolutions(Float.valueOf(this.speed / this.wheelRadii[0])) * 3.0f * 60.0f / 0.05f;
        this.crankAngle -= UtilMath.toDegrees(Float.valueOf(this.speed / this.wheelRadii[0])) * 3.0f;
        this.crankAngle %= 1080.0f;
        float a = MathHelper.func_76142_g((float)this.crankAngle);
        float r = Math.abs(this.crankRPM);
        float threshold = 30.0f;
        boolean flag = true;
        if (this.field_70170_p.field_72995_K) {
            if (r > threshold && flag) {
                this.adaptSounds(r);
            } else {
                this.silenceLoops(true, true);
            }
        }
        if (!this.field_70170_p.field_72995_K && flag && r < threshold) {
            int crankQuad = a < -90.0f ? 0 : (a > -90.0f && a < 0.0f ? 1 : (a > 0.0f && a < 90.0f ? 2 : 3));
            if (crankQuad != this.crankQuadPrev) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HandlerStockSounds.shay_piston, SoundCategory.NEUTRAL, 1.0f, 1.0f + 0.2f * this.getReverseMultAbs());
            }
            this.crankQuadPrev = crankQuad;
        }
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public AuxTractor get() {
        return this.tractor;
    }

    @Override
    public List<AuxSmoker> getSmokerList() {
        return Collections.singletonList(this.smoker);
    }

    @Override
    public int getReverseMax() {
        return 150;
    }

    @Override
    public int getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(int r) {
        this.reverse = r;
    }

    @Override
    public boolean getIsReverseZeroed() {
        return this.isReverseZeroed;
    }

    @Override
    public void setIsReverseZeroed(boolean b) {
        this.isReverseZeroed = b;
    }

    @Override
    public int getRegulatorMax() {
        return 180;
    }

    @Override
    public int getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(int r) {
        this.regulator = r;
    }

    @Override
    public boolean getIsRegulatorZeroed() {
        return this.isRegulatorZeroed;
    }

    @Override
    public void setIsRegulatorZeroed(boolean b) {
        this.isRegulatorZeroed = b;
    }
}

