/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.fleet.loco;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.math.rota.RotaVec;
import net.railsofwar.row.stock.client.sound.SoundDieselMotor;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.auxiliary.AuxSmoker;
import net.railsofwar.row.stock.core.auxiliary.AuxTractor;
import net.railsofwar.row.stock.core.enumeration.EnumCoupler;
import net.railsofwar.row.stock.core.plugin.IBrakeScrew;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.core.roller.RollerFrame;
import net.railsofwar.row.stock.core.roller.RollerFrame2A;

public class LocoUpnor
extends RollingStock
implements IReverseD3,
IRegulatorD5,
AuxTractor.I,
AuxSmoker.I,
IBrakeScrew {
    @SideOnly(value=Side.CLIENT)
    private SoundDieselMotor soundMotor;
    private IReverseD3.EnumReserveP3 reverse = IReverseD3.EnumReserveP3.NEUTRAL;
    private IRegulatorD5.EnumRegulatorP5 regulator = IRegulatorD5.EnumRegulatorP5.STOP;
    public RotaVec driverPos;
    public RotaVec dismountPos;
    private RollerFrame2A frame;
    private AuxTractor tractor;
    @SideOnly(value=Side.CLIENT)
    private AuxSmoker smoker;
    private float brakeScrewPercentile;
    private float brakeScrewPercentilePrev;

    public LocoUpnor(World world) {
        super(world);
        this.rearCouplerShift = 3.09375f;
        this.frontCouplerShift = 2.90625f;
        this.massBare = 13.0f;
        this.speedCap = 0.7f;
        this.driverPos = new RotaVec(this, -0.5f, 0.125f, -1.5f);
        this.dismountPos = new RotaVec(this, -2.5f, 0.125f, -1.5f);
        this.wheelRadii = new float[]{0.3125f, 0.3125f};
        this.init();
    }

    @Override
    public void init() {
        super.init();
        this.frame = new RollerFrame2A(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, this.field_70177_z, this.field_70125_A, this.wheelRadii[0], 1.125f, -1.125f, this.frame2stockOffset);
        this.tractor = new AuxTractor<LocoUpnor>(this, 2.9f, 0.05f, 5.0f, s -> s.getReverseMult() > 0.0f, (s, e) -> e * this.getReverseMultAbs() * this.getRegulatorMult());
        if (this.field_70170_p.field_72995_K) {
            this.smoker = new AuxSmoker(this, new RotaVec(this.frame, -0.0625f, 2.625f, 1.4375f), this.axes.up, 5, 0.375f, 0.45f, 0.02f, 0.1f, 0.09f, 0.15f, 0.25f, 0.3f, 0.5f, f -> 60 - (int)(Math.random() * 30.0), f -> 2.0f + 8.0f * f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addLoopingSounds() {
        super.addLoopingSounds();
        if (this.field_70170_p.field_72995_K) {
            if (this.soundMotor == null) {
                this.soundMotor = new SoundDieselMotor(this, SoundDieselMotor.KOF_MOTOR_0);
            }
            RoW.proxy.playSound(this.soundMotor);
        }
    }

    @Override
    public AuxTractor get() {
        return this.tractor;
    }

    @Override
    public List<AuxSmoker> getSmokerList() {
        return Collections.singletonList(this.smoker);
    }

    @Override
    public RotaVec getPositionForPassenger(Entity passenger) {
        if (passenger.func_184187_bx() == this && this.func_184196_w(passenger) && this.passengers.get(0) == passenger) {
            return this.driverPos;
        }
        return this.driverPos;
    }

    @Override
    public RotaVec getDismountPosition(Entity passenger) {
        return this.dismountPos;
    }

    @Override
    public RollerFrame getFrame() {
        return this.frame;
    }

    @Override
    public EnumCoupler getCouplerFront() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public EnumCoupler getCouplerRear() {
        return EnumCoupler.BufferNChains750;
    }

    @Override
    public IReverseD3.EnumReserveP3 getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(IReverseD3.EnumReserveP3 state) {
        this.reverse = state;
    }

    @Override
    public IRegulatorD5.EnumRegulatorP5 getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(IRegulatorD5.EnumRegulatorP5 state) {
        this.regulator = state;
    }

    @Override
    public boolean doSound() {
        return true;
    }

    @Override
    public float getBrakeScrewPercentile() {
        return this.brakeScrewPercentile;
    }

    @Override
    public void setBrakeScrewPercentile(float f) {
        this.brakeScrewPercentile = f;
    }

    @Override
    public float getBrakeScrewPercentilePrev() {
        return this.brakeScrewPercentilePrev;
    }

    @Override
    public void setBrakeScrewPercentilePrev(float f) {
        this.brakeScrewPercentilePrev = f;
    }

    @Override
    public float getBrakeScrewIncrement() {
        return 0.005f;
    }

    @Override
    public float getBrakeScrewFreeStroke() {
        return 0.0f;
    }

    @Override
    public float getBrakeScrewRevolutions() {
        return 20.0f;
    }

    @Override
    public float getBrakeScrewStroke() {
        return 0.11875f;
    }
}

