/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.railsofwar.row.common.math.UtilMath;

public class PacketPosition
implements IMessage {
    private int id;
    private double x;
    private double y;
    private double z;
    private double mx;
    private double my;
    private double mz;
    private boolean force;

    public PacketPosition() {
    }

    public PacketPosition(int id, double x, double y, double z, double mx, double my, double mz, boolean force) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
        this.force = force;
    }

    public PacketPosition(Entity entity, boolean force) {
        this.id = entity.func_145782_y();
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
        this.mx = entity.field_70159_w;
        this.my = entity.field_70181_x;
        this.mz = entity.field_70179_y;
        this.force = force;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.mx);
        buf.writeDouble(this.my);
        buf.writeDouble(this.mz);
        buf.writeBoolean(this.force);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.mx = buf.readDouble();
        this.my = buf.readDouble();
        this.mz = buf.readDouble();
        this.force = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketPosition, IMessage> {
        public IMessage onMessage(PacketPosition message, MessageContext ctx) {
            Entity entity;
            if (ctx.side.isClient() && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id)) != null) {
                if (message.force) {
                    Handler.force(entity, message);
                } else {
                    double M = UtilMath.hyp(message.mx, message.my, message.mz);
                    if (M < 0.001) {
                        Handler.force(entity, message);
                    } else {
                        double dP = UtilMath.hyp(message.x - entity.field_70165_t, message.y - entity.field_70163_u, message.z - entity.field_70161_v);
                        if (dP > 5.0) {
                            Handler.force(entity, message);
                        } else if (dP > 1.0) {
                            Handler.addMotion(entity, message, 0.3f, 0.25f);
                        } else {
                            Handler.addMotion(entity, message, 0.15f, 0.1f);
                        }
                    }
                }
            }
            return null;
        }

        private static void force(Entity entity, PacketPosition message) {
            entity.field_70165_t = entity.field_70169_q = message.x;
            entity.field_70163_u = entity.field_70167_r = message.y;
            entity.field_70161_v = entity.field_70166_s = message.z;
            entity.field_70159_w = message.mx;
            entity.field_70181_x = message.my;
            entity.field_70179_y = message.mz;
        }

        private static void addMotion(Entity entity, PacketPosition message, float k_motion, float k_position) {
            entity.field_70159_w += (double)k_motion * (message.mx - entity.field_70159_w) + (double)k_position * (message.x - entity.field_70165_t);
            entity.field_70181_x += (double)k_motion * (message.my - entity.field_70181_x) + (double)k_position * (message.y - entity.field_70163_u);
            entity.field_70179_y += (double)k_motion * (message.mz - entity.field_70179_y) + (double)k_position * (message.z - entity.field_70161_v);
        }
    }
}

