/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.client.sound.HandlerStockSounds;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.plugin.IRegulatorA;
import net.railsofwar.row.stock.core.plugin.IRegulatorD2;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseD3;
import net.railsofwar.row.stock.fleet.loco.LocoKof;

public class PacketRegulator
implements IMessage {
    private int id;
    private byte regulatorCode;

    public PacketRegulator() {
    }

    public PacketRegulator(int id, byte regulatorCode) {
        this.id = id;
        this.regulatorCode = regulatorCode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.regulatorCode);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.regulatorCode = buf.readByte();
    }

    public static void doSound(RollingStock loco, SoundEvent sound, boolean flag) {
        if (!loco.field_70170_p.field_72995_K) {
            if (loco instanceof IRegulatorD5 && ((IRegulatorD5)((Object)loco)).doSound() || loco instanceof IRegulatorD2 && ((IRegulatorD2)((Object)loco)).doSound()) {
                loco.field_70170_p.func_184148_a(null, loco.field_70165_t, loco.field_70163_u, loco.field_70161_v, sound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        } else if (loco instanceof LocoKof && flag) {
            if (!Minecraft.func_71410_x().func_152345_ab()) {
                Minecraft.func_71410_x().func_152344_a(((LocoKof)loco)::restartMotor);
            } else {
                ((LocoKof)loco).restartMotor();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketRegulator, IMessage> {
        public IMessage onMessage(PacketRegulator message, MessageContext ctx) {
            Entity entity = ctx.side.isServer() ? ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id) : Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            if (entity != null) {
                Object regulator;
                RollingStock stock = (RollingStock)entity;
                if (stock instanceof IRegulatorD5) {
                    IRegulatorD5 lcrP5 = (IRegulatorD5)((Object)stock);
                    if (!(stock instanceof IReverseD3) || ((IReverseD3)((Object)stock)).getReverse() != IReverseD3.EnumReserveP3.NEUTRAL) {
                        if (message.regulatorCode == 1) {
                            if (lcrP5.getRegulator().canGoUp()) {
                                lcrP5.setRegulator(lcrP5.getRegulator().goUp());
                                PacketRegulator.doSound(stock, HandlerStockSounds.REGULATOR_POSITIONAL_CLICK, true);
                            }
                        } else if (message.regulatorCode == -1 && lcrP5.getRegulator().canGoDown()) {
                            lcrP5.setRegulator(lcrP5.getRegulator().goDown());
                            PacketRegulator.doSound(stock, HandlerStockSounds.REGULATOR_POSITIONAL_CLICK, true);
                        }
                    } else {
                        PacketRegulator.doSound(stock, HandlerStockSounds.LOCKED_CONTROL, false);
                    }
                }
                if (stock instanceof IRegulatorD2) {
                    regulator = (IRegulatorD2)((Object)stock);
                    if (!(stock instanceof IReverseD3) || ((IReverseD3)((Object)stock)).getReverse() != IReverseD3.EnumReserveP3.NEUTRAL) {
                        if (message.regulatorCode == 1) {
                            if (regulator.getRegulator().canGoUp()) {
                                regulator.setRegulator(regulator.getRegulator().goUp());
                                PacketRegulator.doSound(stock, HandlerStockSounds.REGULATOR_POSITIONAL_CLICK, true);
                            }
                        } else if (message.regulatorCode == -1 && regulator.getRegulator().canGoDown()) {
                            regulator.setRegulator(regulator.getRegulator().goDown());
                            PacketRegulator.doSound(stock, HandlerStockSounds.REGULATOR_POSITIONAL_CLICK, true);
                        }
                    } else {
                        PacketRegulator.doSound(stock, HandlerStockSounds.LOCKED_CONTROL, false);
                    }
                }
                if (stock instanceof IRegulatorA) {
                    regulator = (IRegulatorA)((Object)stock);
                    if (message.regulatorCode == 1) {
                        regulator.regulatorGoUp(1);
                    } else if (message.regulatorCode == -1) {
                        regulator.regulatorGoDown(1);
                    } else if (message.regulatorCode == 0) {
                        regulator.setIsRegulatorZeroed(true);
                    }
                }
            }
            if (ctx.side.isServer()) {
                RoWStock.network.sendToAll((IMessage)message);
            }
            return null;
        }
    }
}

