/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.client.sound.HandlerStockSounds;
import net.railsofwar.row.stock.core.RollingStock;
import net.railsofwar.row.stock.core.plugin.IRegulatorD2;
import net.railsofwar.row.stock.core.plugin.IRegulatorD5;
import net.railsofwar.row.stock.core.plugin.IReverseA;
import net.railsofwar.row.stock.core.plugin.IReverseD3;

public class PacketReverse
implements IMessage {
    private int id;
    private byte reverseCode;

    public PacketReverse() {
    }

    public PacketReverse(int id, byte reverseCode) {
        this.id = id;
        this.reverseCode = reverseCode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.reverseCode);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.reverseCode = buf.readByte();
    }

    public static void doSound(RollingStock loco, SoundEvent sound, boolean flag) {
        if (!loco.field_70170_p.field_72995_K && ((IReverseD3)((Object)loco)).doSound()) {
            loco.field_70170_p.func_184148_a(null, loco.field_70165_t, loco.field_70163_u, loco.field_70161_v, sound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketReverse, IMessage> {
        public IMessage onMessage(PacketReverse message, MessageContext ctx) {
            Entity entity = ctx.side.isServer() ? ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id) : Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            if (entity != null) {
                Object reverse;
                RollingStock stock = (RollingStock)entity;
                if (stock instanceof IReverseD3) {
                    reverse = (IReverseD3)((Object)stock);
                    if (!(stock instanceof IRegulatorD5 && ((IRegulatorD5)((Object)stock)).getRegulator() != IRegulatorD5.EnumRegulatorP5.STOP || stock instanceof IRegulatorD2 && ((IRegulatorD2)((Object)stock)).getRegulator() != IRegulatorD2.EnumRegulatorP2.STOP)) {
                        if (message.reverseCode == 1) {
                            if (reverse.getReverse().canGoUp()) {
                                PacketReverse.doSound(stock, HandlerStockSounds.REVERSER_POSITIONAL_CLICK, false);
                            } else {
                                PacketReverse.doSound(stock, HandlerStockSounds.LOCKED_CONTROL, false);
                            }
                            reverse.setReverse(reverse.getReverse().goUp());
                        } else if (message.reverseCode == -1) {
                            if (reverse.getReverse().canGoDown()) {
                                PacketReverse.doSound(stock, HandlerStockSounds.REVERSER_POSITIONAL_CLICK, false);
                            } else {
                                PacketReverse.doSound(stock, HandlerStockSounds.LOCKED_CONTROL, false);
                            }
                            reverse.setReverse(reverse.getReverse().goDown());
                        }
                    }
                }
                if (stock instanceof IReverseA) {
                    reverse = (IReverseA)((Object)stock);
                    if (message.reverseCode == 0) {
                        reverse.setIsReverseZeroed(true);
                    } else if (message.reverseCode == 1) {
                        reverse.reverseGoUp(1);
                        reverse.setIsReverseZeroed(false);
                    } else if (message.reverseCode == -1) {
                        reverse.reverseGoDown(1);
                        reverse.setIsReverseZeroed(false);
                    }
                }
            }
            if (ctx.side.isServer()) {
                RoWStock.network.sendToAll((IMessage)message);
            }
            return null;
        }
    }
}

