/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.stock.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.railsofwar.row.stock.RoWStock;
import net.railsofwar.row.stock.core.plugin.IWhistle;

public class PacketWhistle
implements IMessage {
    private int id;
    private boolean b1;
    private boolean b2;

    public PacketWhistle() {
    }

    public PacketWhistle(int id, boolean b1, boolean b2) {
        this.id = id;
        this.b1 = b1;
        this.b2 = b2;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.b1);
        buf.writeBoolean(this.b2);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.b1 = buf.readBoolean();
        this.b2 = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketWhistle, IMessage> {
        public IMessage onMessage(PacketWhistle message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            } else if (ctx.side.isServer()) {
                entity = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id);
            }
            if (entity instanceof IWhistle) {
                IWhistle whistle = (IWhistle)entity;
                if (message.b1 && !message.b2) {
                    whistle.setWhistlePercentile(Math.min(whistle.getWhistlePercentile() + whistle.getIncrement(), 1.0f));
                } else if (message.b2) {
                    whistle.setWhistlePercentile(1.0f);
                } else if (message.b1 || !message.b2) {
                    // empty if block
                }
                whistle.onRecalculateWhistle();
            }
            if (ctx.side.isServer()) {
                RoWStock.network.sendToAll((IMessage)message);
            }
            return null;
        }
    }
}

