/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.railsofwar.row.track.block.BlockPointer;
import net.railsofwar.row.track.block.BlockTrackGag;
import net.railsofwar.row.track.block.BlockTrackSWNE;
import net.railsofwar.row.track.block.BlockTurntable;
import net.railsofwar.row.track.core.TrackManager;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.item.ItemButtonKillTrack;
import net.railsofwar.row.track.item.ItemTrack;
import net.railsofwar.row.track.item.ItemTrackTool;
import net.railsofwar.row.track.tileentity.TilePointer;
import net.railsofwar.row.track.tileentity.TileTheodolite;
import net.railsofwar.row.track.tileentity.TileTrackGag;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.tileentity.TileTurntable;

public class RoWTracks {
    public static SimpleNetworkWrapper network;
    public static final BlockTrackSWNE blockTrackSWNE;
    public static final BlockTurntable blockTurntable;
    public static final BlockTrackGag blockTrackGag;
    public static final BlockPointer blockPointer;
    public static final Item itemPointer;
    public static final Item buttonKillTrack;
    public static final Item toolTrack;
    public static final Item toolTrackSwitchCircular;
    public static final Item toolTrackSwitchWye;
    public static final Item toolTrackDiamond;
    public static final Item itemTurntable;

    public static void init() {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("rowTrack");
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)blockTrackSWNE);
        registry.register((IForgeRegistryEntry)blockTrackGag);
        registry.register((IForgeRegistryEntry)blockPointer);
        registry.register((IForgeRegistryEntry)blockTurntable);
        GameRegistry.registerTileEntity(TileTrackSWNE.class, (ResourceLocation)new ResourceLocation("row:tileTrackSWNE"));
        GameRegistry.registerTileEntity(TileTrackGag.class, (ResourceLocation)new ResourceLocation("row:tileTrackGag"));
        GameRegistry.registerTileEntity(TileTheodolite.class, (ResourceLocation)new ResourceLocation("row:tileTheodolite"));
        GameRegistry.registerTileEntity(TilePointer.class, (ResourceLocation)new ResourceLocation("row:tilePointer"));
        GameRegistry.registerTileEntity(TileTurntable.class, (ResourceLocation)new ResourceLocation("row:tileTurntableMini"));
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)itemPointer);
        registry.register((IForgeRegistryEntry)itemTurntable);
        registry.register((IForgeRegistryEntry)toolTrack);
        registry.register((IForgeRegistryEntry)toolTrackSwitchCircular);
        registry.register((IForgeRegistryEntry)toolTrackSwitchWye);
        registry.register((IForgeRegistryEntry)toolTrackDiamond);
        registry.register((IForgeRegistryEntry)buttonKillTrack);
    }

    public static TrackManager getTrackManager(World world) {
        if (world == null) {
            return new TrackManager();
        }
        MapStorage storage = world.getPerWorldStorage();
        TrackManager mgr = (TrackManager)storage.func_75742_a(TrackManager.class, "row_tracks");
        if (mgr == null) {
            mgr = new TrackManager();
            storage.func_75745_a("row_tracks", (WorldSavedData)mgr);
        }
        return mgr;
    }

    static {
        blockTrackSWNE = new BlockTrackSWNE("blockTrackSWNE");
        blockTurntable = new BlockTurntable("blockTurntable");
        blockTrackGag = new BlockTrackGag("blockTrackGag");
        blockPointer = new BlockPointer();
        itemPointer = (Item)new ItemBlock((Block)blockPointer).setRegistryName("blockPointer");
        buttonKillTrack = new ItemButtonKillTrack();
        toolTrack = new ItemTrackTool("");
        toolTrackSwitchCircular = new ItemTrackTool("switchCircular");
        toolTrackSwitchWye = new ItemTrackTool("switchWye");
        toolTrackDiamond = new ItemTrackTool("diamond");
        itemTurntable = new ItemTrack(blockTurntable, EnumTrackShape.TURNTABLE, 3, 0, false, EnumRailway.RW750REGULAR);
    }
}

