/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.block.BlockTrackGag;
import net.railsofwar.row.track.block.BlockTrackSWNE;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.tileentity.TilePointer;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.util.UtilTrackGeometry;

public class BlockPointer
extends Block {
    public BlockPointer() {
        super(Material.field_151573_f);
        this.setRegistryName("blockPointer");
        this.func_149663_c("row.blockPointer");
        this.func_149647_a(RoW.TAB_ROW);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileTrackSWNE track;
        int[] d;
        BlockPos p;
        TilePointer tile;
        if (!world.field_72995_K && (tile = (TilePointer)world.func_175625_s(pos)) != null && tile.attached && world.func_180495_p(p = pos.func_177982_a((d = RotationHelper.rotateByDir((int)tile.offset, 2, tile.direction))[0], 0, d[1])).func_177230_c() instanceof BlockTrackSWNE && (track = (TileTrackSWNE)world.func_175625_s(p)) != null) {
            if (track.progress != 0 && track.progress != 20) {
                return true;
            }
            track.activated = !track.activated;
            world.func_184138_a(p, state, world.func_180495_p(p), 3);
            return true;
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TilePointer tile = (TilePointer)world.func_175625_s(pos);
        if (tile != null) {
            tile.direction = EnumDirectionSWNE.fromAngle(placer.field_70177_z);
            if (tile.direction == null) {
                tile.direction = EnumDirectionSWNE.SOUTH;
            }
            int[] d = RotationHelper.rotateByDir(0, 2, tile.direction);
            BlockPos p = new BlockPos(pos.func_177958_n() + d[0], pos.func_177956_o(), pos.func_177952_p() + d[1]);
            if (world.func_180495_p(p).func_177230_c() instanceof BlockTrackGag || world.func_180495_p(p).func_177230_c() instanceof BlockTrackBase) {
                TileTrackSWNE track;
                BlockPos master = RoWTracks.getTrackManager(world).getPieceOrigin(p);
                IBlockState blockState = world.func_180495_p(master);
                IBlockState tryState = RoWTracks.blockTrackSWNE.getExtendedState(blockState, (IBlockAccess)world, master);
                if (!(tryState instanceof IExtendedBlockState)) {
                    return;
                }
                IExtendedBlockState exState = (IExtendedBlockState)tryState;
                EnumRailway railway = (EnumRailway)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.railway));
                EnumTrackShape shape = (EnumTrackShape)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.shape));
                if (shape != EnumTrackShape.SWITCH_CIRCULAR && shape != EnumTrackShape.SWITCH_WYE) {
                    return;
                }
                int scalar = (Integer)exState.getValue((IUnlistedProperty)BlockTrackBase.scalarA);
                int height1 = UtilTrackGeometry.getSwitchPointerBlock(railway, (float)scalar + 0.5f, UtilTrackGeometry.ANGLE45);
                boolean flag1 = false;
                boolean flag2 = false;
                float height2 = UtilTrackGeometry.getSwitchPointerHeight(railway, (float)scalar + 0.5f, UtilTrackGeometry.ANGLE45);
                float offset = height2 - ((float)height1 + 0.5f);
                if (height1 > 0) {
                    int[] d2 = RotationHelper.rotateByDir(height1, 2, tile.direction);
                    int[] d3 = RotationHelper.rotateByDir(-height1, 2, tile.direction);
                    BlockPos p2 = new BlockPos(pos.func_177958_n() + d2[0], pos.func_177956_o(), pos.func_177952_p() + d2[1]);
                    BlockPos p3 = new BlockPos(pos.func_177958_n() + d3[0], pos.func_177956_o(), pos.func_177952_p() + d3[1]);
                    flag1 = master.equals((Object)p2) || master.equals((Object)p3);
                    flag2 = master.equals((Object)p2);
                } else if (world.func_180495_p(p).func_177230_c() instanceof BlockTrackSWNE && (track = (TileTrackSWNE)world.func_175625_s(p)) != null) {
                    int i = (tile.direction.getIndex() - track.direction.getIndex()) % 4;
                    int n = i < 0 ? 4 : 0;
                    flag1 = true;
                    boolean bl = flag2 = (i += n) == 3;
                }
                if (flag1) {
                    if (flag2) {
                        tile.attached = true;
                        tile.mirrored = offset < 0.0f;
                        tile.offset = height2;
                    } else {
                        tile.right = true;
                        tile.attached = true;
                        tile.mirrored = offset > 0.0f;
                        tile.offset = -height2;
                    }
                }
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePointer();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

