/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.track.block.property.PropertyTrackMirrored;
import net.railsofwar.row.track.block.property.PropertyTrackRailway;
import net.railsofwar.row.track.block.property.PropertyTrackScalarA;
import net.railsofwar.row.track.block.property.PropertyTrackScalarB;
import net.railsofwar.row.track.block.property.PropertyTrackSeed;
import net.railsofwar.row.track.block.property.PropertyTrackShape;
import net.railsofwar.row.track.block.property.PropertyTrackState;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.enumeration.EnumTrackState;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;

public abstract class BlockTrackBase
extends Block {
    private String name;
    public static final AxisAlignedBB selBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    public static final AxisAlignedBB hitBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    public static final PropertyTrackShape shape = new PropertyTrackShape();
    public static final PropertyTrackScalarA scalarA = new PropertyTrackScalarA();
    public static final PropertyTrackScalarB scalarB = new PropertyTrackScalarB();
    public static final PropertyTrackMirrored mirrored = new PropertyTrackMirrored();
    public static final PropertyTrackRailway railway = new PropertyTrackRailway();
    public static final PropertyTrackState trackState = new PropertyTrackState();
    public static final PropertyTrackSeed seed = new PropertyTrackSeed();

    public BlockTrackBase(String name) {
        super(Material.field_151573_f);
        this.name = name;
        this.setRegistryName(name);
        this.func_149663_c("row." + this.name);
        this.func_149711_c(2.5f);
        this.func_149752_b(5.0f);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, shape, scalarA, scalarB, mirrored, railway, trackState, seed};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!(state instanceof IExtendedBlockState) || world == null || pos == null) {
            return state;
        }
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        EnumTrackShape shape = EnumTrackShape.STRAIGHT;
        int scalarA = 8;
        int scalarB = 0;
        boolean mirrored = false;
        EnumRailway railway = EnumRailway.RW750REGULAR;
        EnumTrackState trackState = EnumTrackState.MARKUP;
        int seed = pos.func_177958_n() % 16 * 10000 + pos.func_177956_o() % 16 * 100 + pos.func_177952_p() % 16;
        TileTrackSWNE track = (TileTrackSWNE)world.func_175625_s(pos);
        if (track != null) {
            if (track.shape != null) {
                shape = track.shape;
            }
            scalarA = track.scalarA;
            scalarB = track.scalarB;
            mirrored = track.mirrored;
            if (track.railway != null) {
                railway = track.railway;
            }
            if (track.trackState != null) {
                trackState = track.trackState;
            }
        }
        return extendedState.withProperty((IUnlistedProperty)BlockTrackBase.shape, (Object)shape).withProperty((IUnlistedProperty)BlockTrackBase.scalarA, (Object)scalarA).withProperty((IUnlistedProperty)BlockTrackBase.scalarB, (Object)scalarB).withProperty((IUnlistedProperty)BlockTrackBase.mirrored, (Object)mirrored).withProperty((IUnlistedProperty)BlockTrackBase.railway, (Object)railway).withProperty((IUnlistedProperty)BlockTrackBase.trackState, (Object)trackState).withProperty((IUnlistedProperty)BlockTrackBase.seed, (Object)seed);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return null;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return hitBox;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return hitBox;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return selBox.func_186670_a(pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

