/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.block;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.stock.item.ItemPrybar;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.block.property.PropertyTrackDirectionSWNE;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.util.UtilTrackGeometry;

public class BlockTrackSWNE
extends BlockTrackBase {
    public static final PropertyTrackDirectionSWNE direction = new PropertyTrackDirectionSWNE();

    public BlockTrackSWNE(String name) {
        super(name);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, shape, mirrored, scalarA, scalarB, railway, trackState, seed, direction};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!(state instanceof IExtendedBlockState)) {
            return state;
        }
        EnumDirectionSWNE dir = EnumDirectionSWNE.SOUTH;
        TileTrackSWNE track = (TileTrackSWNE)world.func_175625_s(pos);
        if (track != null && track.direction != null) {
            dir = track.direction;
        }
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)direction, (Object)dir);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            RoWTracks.getTrackManager(world).removePiece(world, pos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileTrackSWNE tile;
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && heldItem.func_77973_b() instanceof ItemPrybar && (tile = (TileTrackSWNE)world.func_175625_s(pos)) != null) {
            tile.railway = EnumRailway.byIndex(tile.railway.getIndex() + 1);
            world.func_184138_a(pos, state, world.func_180495_p(pos), 3);
            return false;
        }
        if (heldItem.func_190926_b()) {
            player.func_146105_b((ITextComponent)new TextComponentString("-----"), false);
            if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString("client"), false);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("server"), false);
            }
            tile = (TileTrackSWNE)world.func_175625_s(pos);
            if (tile != null) {
                EnumTrackShape shape1 = (EnumTrackShape)((Object)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.shape));
                int scalarA = (Integer)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.scalarA);
                int scalarB = (Integer)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.scalarB);
                player.func_146105_b((ITextComponent)new TextComponentString("good tile"), false);
                player.func_146105_b((ITextComponent)new TextComponentString("index: " + tile.direction.getIndex()), false);
                player.func_146105_b((ITextComponent)new TextComponentString("direction: " + tile.direction.getName()), false);
                player.func_146105_b((ITextComponent)new TextComponentString("seed: " + ((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.seed)), false);
                player.func_146105_b((ITextComponent)new TextComponentString("shape: " + (Object)((Object)shape1)), false);
                player.func_146105_b((ITextComponent)new TextComponentString("state: " + ((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.trackState)), false);
                player.func_146105_b((ITextComponent)new TextComponentString("scalarA: " + scalarA), false);
                player.func_146105_b((ITextComponent)new TextComponentString("scalarB: " + scalarB), false);
                if (shape1 == EnumTrackShape.CIRCULAR || shape1 == EnumTrackShape.SWITCH_CIRCULAR) {
                    player.func_146105_b((ITextComponent)new TextComponentString("radius: " + UtilTrackGeometry.getCircularRadius(scalarA, EnumDiagonal.byOrdinal(scalarB).getRadian())), false);
                }
                if (shape1 == EnumTrackShape.CIRCULAR) {
                    player.func_146105_b((ITextComponent)new TextComponentString("length: " + UtilTrackGeometry.getCircularArc(scalarA, EnumDiagonal.byOrdinal(scalarB).getRadian())), false);
                }
                player.func_146105_b((ITextComponent)new TextComponentString("mirrored: " + ((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.mirrored)), false);
                player.func_146105_b((ITextComponent)new TextComponentString("railway: " + ((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)BlockTrackBase.railway)), false);
                player.func_146105_b((ITextComponent)new TextComponentString("activated: " + tile.activated), false);
                player.func_146105_b((ITextComponent)new TextComponentString("flag: " + (tile.activated ^ tile.mirrored)), false);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString("null tile"), false);
            }
        }
        return false;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileTrackSWNE();
    }
}

