/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.capability;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.capability.CapabilityToolTrack;
import net.railsofwar.row.track.capability.ToolTrackProvider;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.enumeration.EnumTrackState;
import net.railsofwar.row.track.item.ItemTrackTool;
import net.railsofwar.row.track.packets.PacketCapabilityTrackTool;
import net.railsofwar.row.track.util.TrackDescriptor;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber
public class HandlerCapabilityToolTrack {
    private static final ResourceLocation RLCapToolTrack = new ResourceLocation("row", "capToolTrack");
    private static boolean prevInvert = false;

    @SubscribeEvent
    public static void on(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(RLCapToolTrack, (ICapabilityProvider)new ToolTrackProvider());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent e) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, null)) {
            CapabilityToolTrack.IToolTrackCapability cap = (CapabilityToolTrack.IToolTrackCapability)player.getCapability(ToolTrackProvider.CAP_TOOL_TRACK, null);
            boolean current = FMLClientHandler.instance().getClient().field_71474_y.field_151444_V.func_151470_d();
            if (prevInvert != current) {
                RoWTracks.network.sendToServer((IMessage)new PacketCapabilityTrackTool(player.func_145782_y(), current, cap.scalarB()));
            }
            prevInvert = current;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(MouseEvent e) {
        CapabilityToolTrack.IToolTrackCapability cap;
        EntityPlayerSP player;
        if (e.getDwheel() != 0 && (player = FMLClientHandler.instance().getClientPlayerEntity()) != null && player.func_184614_ca() != null && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, null) && (player.func_184614_ca().func_77973_b() == RoWTracks.toolTrack || player.func_184614_ca().func_77973_b() == RoWTracks.toolTrackSwitchCircular) && (cap = (CapabilityToolTrack.IToolTrackCapability)player.getCapability(ToolTrackProvider.CAP_TOOL_TRACK, null)).doneFirst()) {
            int b = Math.max(cap.scalarB() + (int)Math.signum(e.getDwheel()), 1);
            RoWTracks.network.sendToServer((IMessage)new PacketCapabilityTrackTool(player.func_145782_y(), cap.invert(), b));
            e.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(PlayerInteractEvent.RightClickItem e) {
        if (e.getHand() == EnumHand.OFF_HAND || e.getItemStack() == null || !(e.getItemStack().func_77973_b() instanceof ItemTrackTool)) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        Minecraft m = FMLClientHandler.instance().getClient();
        if (player != null && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, null)) {
            if (m.field_71476_x != null && m.field_71476_x.field_72313_a != RayTraceResult.Type.MISS && m.field_71476_x.func_178782_a() != null) {
                return;
            }
            RoWTracks.network.sendToServer((IMessage)new PacketCapabilityTrackTool(player.func_145782_y()));
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.RightClickBlock e) {
        boolean skip;
        if (e.getHand() == EnumHand.OFF_HAND || e.getItemStack() == null || !(e.getItemStack().func_77973_b() instanceof ItemTrackTool)) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        boolean bl = skip = world.field_72995_K && FMLClientHandler.instance().getClient().func_71387_A();
        if (player != null && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, e.getFace())) {
            e.setCanceled(true);
            CapabilityToolTrack.IToolTrackCapability cap = (CapabilityToolTrack.IToolTrackCapability)player.getCapability(ToolTrackProvider.CAP_TOOL_TRACK, e.getFace());
            int scalarB = cap.scalarB();
            if (stack.func_77973_b() == RoWTracks.toolTrack || stack.func_77973_b() == RoWTracks.toolTrackSwitchCircular) {
                scalarB = Math.max(scalarB, 1);
            }
            if (!cap.doneFirst()) {
                if (!skip) {
                    cap.setDone(true);
                    if (world.func_180495_p(e.getPos()).func_177230_c().func_176200_f((IBlockAccess)world, e.getPos())) {
                        cap.setPos(e.getPos());
                    } else {
                        cap.setPos(e.getPos().func_177984_a());
                    }
                    if (stack.func_77973_b() != RoWTracks.toolTrackDiamond) {
                        cap.setScalarB(4);
                    }
                }
            } else if (cap.doneFirst()) {
                BlockPos p1 = cap.getOrigin();
                BlockPos p2 = e.getPos();
                if (!world.func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)world, p2)) {
                    p2 = p2.func_177984_a();
                }
                if (stack.func_77973_b() == RoWTracks.toolTrack) {
                    if (scalarB == 8) {
                        BlockPos vector = p2.func_177973_b((Vec3i)p1);
                        float yaw = (float)Math.toDegrees(Math.atan2(-vector.func_177958_n(), vector.func_177952_p()));
                        if (HandlerCapabilityToolTrack.getLength(vector) + 1 == 1) {
                            yaw = player.field_70177_z;
                        }
                        if ((yaw = Math.abs(yaw % 90.0f)) < 22.5f || yaw > 67.5f) {
                            if (!cap.invert()) {
                                HandlerCapabilityToolTrack.doTrackStraight(world, player, p1, p2);
                            } else {
                                HandlerCapabilityToolTrack.doTrackStraight(world, player, p2, p1);
                            }
                        } else {
                            HandlerCapabilityToolTrack.doTrackDiagonal(world, player, p1, p2);
                        }
                    } else if (scalarB > 8) {
                        HandlerCapabilityToolTrack.doTrackSlopeStraight(world, player, p1, p2, scalarB - 8);
                    } else {
                        BlockPos vector = p2.func_177973_b((Vec3i)p1);
                        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                        float i1 = p2.func_177958_n();
                        float j1 = p2.func_177956_o();
                        float k1 = p2.func_177952_p();
                        int w = HandlerCapabilityToolTrack.getWidth(vector);
                        float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
                        int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, radian) - 1;
                        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                            i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                        } else {
                            k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                        }
                        BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                        if (!cap.invert()) {
                            HandlerCapabilityToolTrack.doTrackCircular(world, player, p1, p2, scalarB, false);
                        } else {
                            HandlerCapabilityToolTrack.doTrackCircular(world, player, p3, p1, scalarB, false);
                        }
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackSwitchCircular) {
                    scalarB = 4;
                    BlockPos vector = p2.func_177973_b((Vec3i)p1);
                    EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                    float i1 = p2.func_177958_n();
                    float j1 = p2.func_177956_o();
                    float k1 = p2.func_177952_p();
                    int w = HandlerCapabilityToolTrack.getWidth(vector);
                    float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
                    int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, radian) - 1;
                    if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                        i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                    } else {
                        k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                    }
                    BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                    if (!cap.invert()) {
                        HandlerCapabilityToolTrack.doTrackCircular(world, player, p1, p2, scalarB, true);
                    } else {
                        HandlerCapabilityToolTrack.doTrackCircular(world, player, p3, p1, scalarB, true);
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackSwitchWye) {
                    BlockPos vector = p2.func_177973_b((Vec3i)p1);
                    EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                    float i1 = p2.func_177958_n();
                    float j1 = p2.func_177956_o();
                    float k1 = p2.func_177952_p();
                    int w = HandlerCapabilityToolTrack.getWidth(vector);
                    int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, UtilTrackGeometry.ANGLE45) - 1;
                    if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                        i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                    } else {
                        k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                    }
                    BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                    if (!cap.invert()) {
                        HandlerCapabilityToolTrack.doTrackWye(world, player, p1, p2);
                    } else {
                        HandlerCapabilityToolTrack.doTrackWye(world, player, p3, p1);
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackDiamond) {
                    HandlerCapabilityToolTrack.doTrackDiamond(world, player, p1, p2);
                }
                if (!skip) {
                    cap.setDone(false);
                    cap.setScalarB(0);
                    cap.setInvert(false);
                }
            }
        }
    }

    private static void doTrackDiamond(World world, EntityPlayer player, BlockPos p1, BlockPos p2) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        if (HandlerCapabilityToolTrack.getWidth(vector) == 0) {
            new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, EnumTrackShape.DIAMOND_STRAIGHT, 0, 0, false, EnumTrackState.WORKING, direction).place(world);
        } else if (HandlerCapabilityToolTrack.getWidth(vector) == HandlerCapabilityToolTrack.getLength(vector)) {
            direction = EnumDirectionSWNE.fromAngle(Math.toDegrees(Math.atan2(-vector.func_177958_n(), vector.func_177952_p())) - 45.0);
            new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, EnumTrackShape.DIAMOND_DIAGONAL, 0, 0, false, EnumTrackState.WORKING, direction).place(world);
        } else if (HandlerCapabilityToolTrack.getLength(vector) > 0 && HandlerCapabilityToolTrack.getWidth(vector) > 0) {
            new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, EnumTrackShape.DIAMOND_SHARP, 0, 0, vector.func_177958_n() * vector.func_177952_p() * (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST ? -1 : 1) > 1, EnumTrackState.WORKING, direction).place(world);
        }
    }

    private static void doTrackCircular(World world, EntityPlayer player, BlockPos p1, BlockPos p2, int base, boolean points) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        int width = HandlerCapabilityToolTrack.getWidth(vector);
        if (width > 0 && width < 16) {
            new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, points ? EnumTrackShape.SWITCH_CIRCULAR : EnumTrackShape.CIRCULAR, width, base, HandlerCapabilityToolTrack.getCircularMirrored(direction, vector), EnumTrackState.WORKING, direction).place(world);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString("Piece span: " + width + " out of 1-15 range!"), true);
        }
    }

    private static void doTrackWye(World world, EntityPlayer player, BlockPos p1, BlockPos p2) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        int width = HandlerCapabilityToolTrack.getWidth(vector);
        if (width > 0 && width < 16) {
            new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, EnumTrackShape.SWITCH_WYE, width, 0, HandlerCapabilityToolTrack.getCircularMirrored(direction, vector), EnumTrackState.WORKING, direction).place(world);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString("Piece span: " + width + " out of 1-15 range!"), true);
        }
    }

    private static boolean getCircularMirrored(EnumDirectionSWNE direction, BlockPos vector) {
        switch (direction) {
            case WEST: {
                return vector.func_177952_p() > 0;
            }
            case NORTH: {
                return vector.func_177958_n() < 0;
            }
            case EAST: {
                return vector.func_177952_p() < 0;
            }
        }
        return vector.func_177958_n() > 0;
    }

    private static void doTrackDiagonal(World world, EntityPlayer player, BlockPos p1, BlockPos p2) {
        float a;
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        float yaw = (float)Math.toDegrees(Math.atan2(-vector.func_177958_n(), vector.func_177952_p()));
        EnumDirectionSWNE dir = EnumDirectionSWNE.fromAngle(yaw - 45.0f);
        float h = (float)Math.sqrt(vector.func_177958_n() * vector.func_177958_n() + vector.func_177952_p() * vector.func_177952_p());
        int length = (int)Math.round((double)h * Math.cos(Math.toRadians(a = yaw - dir.getAzimuth() - 45.0f)) * (double)0.707106f + 1.0);
        if (length == 1) {
            dir = EnumDirectionSWNE.fromAngle(player.field_70177_z - 45.0f);
        }
        int cutLength = 16;
        int pieces = Math.floorDiv(length, cutLength);
        int filler = Math.floorMod(length, cutLength);
        for (int n = 0; n < pieces; ++n) {
            new TrackDescriptor(p1.func_177971_a(dir.ort(n * cutLength)).func_177971_a(dir.getCW().ort(n * cutLength)), EnumRailway.RW750STAGGERED, EnumTrackShape.DIAGONAL, cutLength, 0, false, EnumTrackState.WORKING, dir).place(world);
        }
        if (filler > 0) {
            new TrackDescriptor(p1.func_177971_a(dir.ort(pieces * cutLength)).func_177971_a(dir.getCW().ort(pieces * cutLength)), EnumRailway.RW750STAGGERED, EnumTrackShape.DIAGONAL, filler, 0, false, EnumTrackState.WORKING, dir).place(world);
        }
    }

    private static void doTrackSlopeStraight(World world, EntityPlayer player, BlockPos p1, BlockPos p2, int raise) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        int length = HandlerCapabilityToolTrack.getLength(vector) + 1;
        if (length < 8) {
            player.func_146105_b((ITextComponent)new TextComponentString("Piece length: " + length + " is smaller than 8!"), true);
            return;
        }
        if ((float)length * 1.0f / (float)raise < 4.0f) {
            player.func_146105_b((ITextComponent)new TextComponentString("Piece grade: " + raise + "/" + length + " is steeper than 1/4!"), true);
            return;
        }
        new TrackDescriptor(p1, EnumRailway.RW750STAGGERED, EnumTrackShape.SLOPE_STRAIGHT, length, raise, false, EnumTrackState.WORKING, direction).place(world);
    }

    private static void doTrackStraight(World world, EntityPlayer player, BlockPos p1, BlockPos p2) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        int length = HandlerCapabilityToolTrack.getLength(vector) + 1;
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        if (length == 1) {
            direction = EnumDirectionSWNE.fromAngle(player.field_70177_z);
        }
        int cutLength = 16;
        int pieces = Math.floorDiv(length, cutLength);
        int filler = Math.floorMod(length, cutLength);
        for (int n = 0; n < pieces; ++n) {
            new TrackDescriptor(p1.func_177971_a(direction.ort(n * cutLength)), EnumRailway.RW750STAGGERED, EnumTrackShape.STRAIGHT, cutLength, 0, false, EnumTrackState.WORKING, direction).place(world);
        }
        if (filler > 0) {
            new TrackDescriptor(p1.func_177971_a(direction.ort(pieces * cutLength)), EnumRailway.RW750STAGGERED, EnumTrackShape.STRAIGHT, filler, 0, false, EnumTrackState.WORKING, direction).place(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(RenderWorldLastEvent e) {
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74320_O == 0) {
            HandlerCapabilityToolTrack.render((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity(), e.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(RenderPlayerEvent.Pre e) {
        HandlerCapabilityToolTrack.render(e.getEntityPlayer(), e.getPartialRenderTick());
    }

    @SideOnly(value=Side.CLIENT)
    private static void render(EntityPlayer player, float tick) {
        World world = player.field_70170_p;
        Minecraft m = Minecraft.func_71410_x();
        ItemStack stack = player.func_184614_ca();
        if (m.field_71439_g != player) {
            return;
        }
        if (player.func_184187_bx() == null && stack != null && stack.func_77973_b() instanceof ItemTrackTool && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, null)) {
            CapabilityToolTrack.IToolTrackCapability cap = (CapabilityToolTrack.IToolTrackCapability)player.getCapability(ToolTrackProvider.CAP_TOOL_TRACK, null);
            if (!cap.doneFirst()) {
                return;
            }
            BlockPos p1 = cap.getOrigin();
            int scalarB = cap.scalarB();
            if (stack.func_77973_b() == RoWTracks.toolTrack || stack.func_77973_b() == RoWTracks.toolTrackSwitchCircular) {
                scalarB = Math.max(scalarB, 1);
            }
            if (m.field_71476_x != null && m.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && m.field_71476_x.func_178782_a() != null) {
                BlockPos p2 = m.field_71476_x.func_178782_a();
                if (!world.func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)world, p2)) {
                    p2 = p2.func_177984_a();
                }
                if (stack.func_77973_b() == RoWTracks.toolTrack) {
                    if (scalarB == 8) {
                        BlockPos vector = p2.func_177973_b((Vec3i)p1);
                        float yaw = (float)Math.toDegrees(Math.atan2(-vector.func_177958_n(), vector.func_177952_p()));
                        if (HandlerCapabilityToolTrack.getLength(vector) + 1 == 1) {
                            yaw = player.field_70177_z;
                        }
                        if ((yaw = Math.abs(yaw % 90.0f)) < 22.5f || yaw > 67.5f) {
                            if (!FMLClientHandler.instance().getClient().field_71474_y.field_151444_V.func_151470_d()) {
                                HandlerCapabilityToolTrack.renderTrackStraight(player, p1, p2, tick);
                            } else {
                                HandlerCapabilityToolTrack.renderTrackStraight(player, p2, p1, tick);
                            }
                        } else {
                            HandlerCapabilityToolTrack.renderTrackDiagonal(player, p1, p2, scalarB, tick);
                        }
                    } else if (scalarB > 8) {
                        HandlerCapabilityToolTrack.renderTrackSlopeStraight(player, p1, p2, scalarB - 8, tick);
                    } else {
                        BlockPos vector = p2.func_177973_b((Vec3i)p1);
                        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                        float i1 = p2.func_177958_n();
                        float j1 = p2.func_177956_o();
                        float k1 = p2.func_177952_p();
                        int w = HandlerCapabilityToolTrack.getWidth(vector);
                        float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
                        int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, radian) - 1;
                        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                            i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                        } else {
                            k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                        }
                        BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                        if (!FMLClientHandler.instance().getClient().field_71474_y.field_151444_V.func_151470_d()) {
                            HandlerCapabilityToolTrack.renderTrackCircular(player, p1, p3, p2, scalarB, tick, false);
                        } else {
                            HandlerCapabilityToolTrack.renderTrackCircular(player, p3, p1, p2, scalarB, tick, false);
                        }
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackSwitchCircular) {
                    scalarB = 4;
                    BlockPos vector = p2.func_177973_b((Vec3i)p1);
                    EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                    float i1 = p2.func_177958_n();
                    float j1 = p2.func_177956_o();
                    float k1 = p2.func_177952_p();
                    int w = HandlerCapabilityToolTrack.getWidth(vector);
                    float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
                    int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, radian) - 1;
                    if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                        i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                    } else {
                        k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                    }
                    BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                    if (!FMLClientHandler.instance().getClient().field_71474_y.field_151444_V.func_151470_d()) {
                        HandlerCapabilityToolTrack.renderTrackCircular(player, p1, p3, p2, scalarB, tick, true);
                    } else {
                        HandlerCapabilityToolTrack.renderTrackCircular(player, p3, p1, p2, scalarB, tick, true);
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackSwitchWye) {
                    BlockPos vector = p2.func_177973_b((Vec3i)p1);
                    EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
                    float i1 = p2.func_177958_n();
                    float j1 = p2.func_177956_o();
                    float k1 = p2.func_177952_p();
                    int w = HandlerCapabilityToolTrack.getWidth(vector);
                    float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
                    int l1 = UtilTrackGeometry.getCircularHeight((float)w + 0.5f, radian) - 1;
                    if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                        i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
                    } else {
                        k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
                    }
                    BlockPos p3 = new BlockPos((double)i1, (double)j1, (double)k1);
                    if (!FMLClientHandler.instance().getClient().field_71474_y.field_151444_V.func_151470_d()) {
                        HandlerCapabilityToolTrack.renderTrackWye(player, p1, p3, p2, tick);
                    } else {
                        HandlerCapabilityToolTrack.renderTrackWye(player, p3, p1, p2, tick);
                    }
                } else if (stack.func_77973_b() == RoWTracks.toolTrackDiamond) {
                    HandlerCapabilityToolTrack.renderTrackDiamond(player, p1, p2, tick);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackDiamond(EntityPlayer player, BlockPos p1, BlockPos p2, float tick) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)p2.func_177958_n() + 0.5f, p2.func_177956_o(), (float)p2.func_177952_p() + 0.5f, (float)p2.func_177958_n() + 0.5f, (float)p2.func_177956_o() + 3.0f, (float)p2.func_177952_p() + 0.5f);
        if (HandlerCapabilityToolTrack.getWidth(vector) == 0) {
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 2.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 2.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() - 1.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 2.0f);
            player.func_146105_b((ITextComponent)new TextComponentString("Diamond shape: straight"), true);
        } else if (HandlerCapabilityToolTrack.getWidth(vector) == HandlerCapabilityToolTrack.getLength(vector)) {
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 2.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 2.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, p1.func_177956_o(), (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() - 1.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 2.0f, p1.func_177956_o(), (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() - 1.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 2.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 2.0f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() - 1.0f);
            player.func_146105_b((ITextComponent)new TextComponentString("Diamond shape: diagonal"), true);
        } else if (HandlerCapabilityToolTrack.getLength(vector) > 0 && HandlerCapabilityToolTrack.getWidth(vector) > 0) {
            EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
            float f = 1.5f * Math.signum(vector.func_177958_n()) * Math.signum(vector.func_177952_p());
            if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 3.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 3.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() - 2.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() - 2.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f + f, p1.func_177956_o(), (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() + 0.5f + f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 2.0f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f - f, p1.func_177956_o(), (float)p1.func_177952_p() - 1.0f, (float)p1.func_177958_n() + 0.5f - f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() - 1.0f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() - 2.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 3.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f + f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 2.0f, (float)p1.func_177958_n() + 0.5f - f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() - 1.0f);
            } else {
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() + 3.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 3.0f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() - 2.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, p1.func_177952_p() - 2);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f - f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f - f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 2.0f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f + f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f + f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() - 2.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 3.0f);
                HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() - 1.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f - f, (float)p1.func_177958_n() + 2.0f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f + f);
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Diamond shape: sharp"), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackCircular(EntityPlayer player, BlockPos p1, BlockPos p2, BlockPos pm, int ordinal, float tick, boolean points) {
        int base;
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        float h = 1.5f;
        int w = HandlerCapabilityToolTrack.getWidth(vector);
        float radian = EnumDiagonal.byOrdinal(ordinal).getRadian();
        float gap = UtilTrackGeometry.getCircularGap((float)w + 0.5f, radian);
        boolean mirrored = HandlerCapabilityToolTrack.getCircularMirrored(direction, vector);
        Vector3f mid = new Vector3f((float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f);
        Vector3f start = new Vector3f(mid);
        start.add((Tuple3f)direction.ort(-0.5f));
        Vector3f fill = new Vector3f(start);
        fill.add((Tuple3f)direction.ort(gap));
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, start.x, start.y, start.z, start.x, start.y + 3.0f, start.z);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, start.x, start.y + h, start.z, fill.x, fill.y + h, fill.z);
        HandlerCapabilityToolTrack.renderArc(player, p1, direction, w, ordinal, mirrored, tick);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)pm.func_177958_n() + 0.5f, pm.func_177956_o(), (float)pm.func_177952_p() + 0.5f, (float)pm.func_177958_n() + 0.5f, (float)pm.func_177956_o() + 3.0f, (float)pm.func_177952_p() + 0.5f);
        if (points) {
            int l1 = UtilTrackGeometry.getSwitchCircularHeight(EnumRailway.RW750STAGGERED, (float)w + 0.5f, radian) - 1;
            float i1 = p1.func_177958_n();
            float j1 = p1.func_177956_o();
            float k1 = p1.func_177952_p();
            if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
                i1 = (float)p1.func_177958_n() + Math.signum(vector.func_177958_n()) * (float)l1;
            } else {
                k1 = (float)p1.func_177952_p() + Math.signum(vector.func_177952_p()) * (float)l1;
            }
            HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, i1 + 0.5f, j1, k1 + 0.5f, i1 + 0.5f, j1 + 3.0f, k1 + 0.5f);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, start.x, start.y + h, start.z, i1 + 0.5f, j1 + h, k1 + 0.5f);
        }
        String inc = (base = EnumDiagonal.byOrdinal(ordinal).getBase()) > 0 ? "1/" + base : Math.abs(base) + "/1";
        player.func_146105_b((ITextComponent)new TextComponentString("Piece span: " + w + ", outlet incline: " + inc), true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackWye(EntityPlayer player, BlockPos p1, BlockPos p2, BlockPos pm, float tick) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        float h = 1.5f;
        int w = HandlerCapabilityToolTrack.getWidth(vector);
        float gap = UtilTrackGeometry.getCircularGap((float)w + 0.5f, UtilTrackGeometry.ANGLE45);
        Vector3f mid = new Vector3f((float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f);
        Vector3f start = new Vector3f(mid);
        start.add((Tuple3f)direction.ort(-0.5f));
        Vector3f fill = new Vector3f(start);
        fill.add((Tuple3f)direction.ort(gap));
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, start.x, start.y, start.z, start.x, start.y + 3.0f, start.z);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, start.x, start.y + h, start.z, fill.x, fill.y + h, fill.z);
        HandlerCapabilityToolTrack.renderArc(player, p1, direction, w, 4, false, tick);
        HandlerCapabilityToolTrack.renderArc(player, p1, direction, w, 4, true, tick);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)pm.func_177958_n() + 0.5f, pm.func_177956_o(), (float)pm.func_177952_p() + 0.5f, (float)pm.func_177958_n() + 0.5f, (float)pm.func_177956_o() + 3.0f, (float)pm.func_177952_p() + 0.5f);
        player.func_146105_b((ITextComponent)new TextComponentString("Piece span: " + w), true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderArc(EntityPlayer player, BlockPos p1, EnumDirectionSWNE direction, int w, int base, boolean mirrored, float tick) {
        float h = 1.5f;
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float radius = UtilTrackGeometry.getCircularRadius((float)w + 0.5f, radian);
        float gap = UtilTrackGeometry.getCircularGap((float)w + 0.5f, radian);
        float length = radian * radius;
        float pieceLength = 0.5f;
        int pieces = Math.round(length / pieceLength);
        float angle = radian / (float)pieces;
        Vector3f mid = new Vector3f((float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f);
        Vector3f start = new Vector3f(mid);
        start.add((Tuple3f)direction.ort(-0.5f));
        Vector3f fill = new Vector3f(start);
        fill.add((Tuple3f)direction.ort(gap));
        Vector3f centre = new Vector3f(fill);
        centre.add((Tuple3f)direction.getCW().ort(radius * (mirrored ? -1.0f : 1.0f)));
        Vector3f current = new Vector3f(start);
        for (int i = 0; i <= pieces; ++i) {
            Vector3f prev = current;
            float transverse = (mirrored ? -1.0f : 1.0f) * radius * (float)Math.cos((float)i * angle);
            float axial = radius * (float)Math.sin((float)i * angle);
            current = RotationHelper.rotateByDir(new Vector3f(transverse, 0.0f, axial), direction);
            current.add((Tuple3f)centre);
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, prev.x, prev.y + h, prev.z, current.x, current.y + h, current.z);
            if (i > pieces) continue;
            HandlerCapabilityToolTrack.renderPoint(player, tick, 0.0f, 1.0f, 0.0f, current.x, current.y + h, current.z);
        }
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, current.x, current.y, current.z, current.x, current.y + 3.0f, current.z);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackDiagonal(EntityPlayer player, BlockPos p1, BlockPos p2, int scalarB, float tick) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        float yaw = (float)Math.toDegrees(Math.atan2(-vector.func_177958_n(), vector.func_177952_p()));
        float degree = 45.0f;
        EnumDirectionSWNE dir = EnumDirectionSWNE.fromAngle(yaw - degree);
        float h = (float)Math.sqrt(vector.func_177958_n() * vector.func_177958_n() + vector.func_177952_p() * vector.func_177952_p());
        float a = yaw - dir.getAzimuth() - degree;
        int l = (int)Math.round((double)h * Math.cos(Math.toRadians(a)) * Math.cos(Math.toRadians(45.0)));
        Vector3f dia = new Vector3f((float)p1.func_177958_n(), (float)p1.func_177956_o(), (float)p1.func_177952_p());
        dia.add((Tuple3f)dir.ort((float)l * 1.0f));
        dia.add((Tuple3f)dir.getCW().ort((float)l * 1.0f));
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)p2.func_177958_n() + 0.5f, p2.func_177956_o(), (float)p2.func_177952_p() + 0.5f, (float)p2.func_177958_n() + 0.5f, (float)p2.func_177956_o() + 3.0f, (float)p2.func_177952_p() + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, dia.x + 0.5f, dia.y, dia.z + 0.5f, dia.x + 0.5f, dia.y + 3.0f, dia.z + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 1.5f, (float)p1.func_177952_p() + 0.5f, dia.x + 0.5f, dia.y + 1.5f, dia.z + 0.5f);
        player.func_146105_b((ITextComponent)new TextComponentString("Piece length: " + (l + 1)), true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackSlopeStraight(EntityPlayer player, BlockPos p1, BlockPos p2, int raise, float tick) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        int l = HandlerCapabilityToolTrack.getLength(vector);
        int i = p1.func_177958_n();
        int j = p1.func_177956_o();
        int k = p1.func_177952_p();
        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
            i += (int)Math.signum(vector.func_177958_n()) * l;
        } else {
            k += (int)Math.signum(vector.func_177952_p()) * l;
        }
        float h = 1.5f;
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
        if (i != p2.func_177958_n() || k != p2.func_177952_p()) {
            HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)p2.func_177958_n() + 0.5f, p2.func_177956_o(), (float)p2.func_177952_p() + 0.5f, (float)p2.func_177958_n() + 0.5f, (float)p2.func_177956_o() + 3.0f, (float)p2.func_177952_p() + 0.5f);
        }
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)i + 0.5f, j + raise, (float)k + 0.5f, (float)i + 0.5f, (float)j + 3.0f + (float)raise, (float)k + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + h, (float)p1.func_177952_p() + 0.5f, (float)i + 0.5f, (float)j + h + (float)raise, (float)k + 0.5f);
        player.func_146105_b((ITextComponent)new TextComponentString("Piece length: " + (l + 1) + ", height: " + raise), true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderTrackStraight(EntityPlayer player, BlockPos p1, BlockPos p2, float tick) {
        BlockPos vector = p2.func_177973_b((Vec3i)p1);
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        int l = HandlerCapabilityToolTrack.getLength(vector);
        int i = p1.func_177958_n();
        int j = p1.func_177956_o();
        int k = p1.func_177952_p();
        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
            i += (int)Math.signum(vector.func_177958_n()) * l;
        } else {
            k += (int)Math.signum(vector.func_177952_p()) * l;
        }
        float h = 1.5f;
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, p1.func_177956_o(), (float)p1.func_177952_p() + 0.5f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + 3.0f, (float)p1.func_177952_p() + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 0.0f, 1.0f, (float)p2.func_177958_n() + 0.5f, p2.func_177956_o(), (float)p2.func_177952_p() + 0.5f, (float)p2.func_177958_n() + 0.5f, (float)p2.func_177956_o() + 3.0f, (float)p2.func_177952_p() + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 1.0f, 0.0f, 0.0f, (float)i + 0.5f, j, (float)k + 0.5f, (float)i + 0.5f, (float)j + 3.0f, (float)k + 0.5f);
        HandlerCapabilityToolTrack.renderVector(player, tick, 0.0f, 1.0f, 0.0f, (float)p1.func_177958_n() + 0.5f, (float)p1.func_177956_o() + h, (float)p1.func_177952_p() + 0.5f, (float)i + 0.5f, (float)j + h, (float)k + 0.5f);
        player.func_146105_b((ITextComponent)new TextComponentString("Piece length: " + (l + 1)), true);
    }

    private static int getWidth(BlockPos vector) {
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
            return Math.abs(vector.func_177952_p());
        }
        return Math.abs(vector.func_177958_n());
    }

    private static int getLength(BlockPos vector) {
        EnumDirectionSWNE direction = HandlerCapabilityToolTrack.getDirection(vector);
        if (direction == EnumDirectionSWNE.EAST || direction == EnumDirectionSWNE.WEST) {
            return Math.abs(vector.func_177958_n());
        }
        return Math.abs(vector.func_177952_p());
    }

    private static EnumDirectionSWNE getDirection(BlockPos vector) {
        if (Math.abs(vector.func_177958_n()) > Math.abs(vector.func_177952_p())) {
            return vector.func_177958_n() > 0 ? EnumDirectionSWNE.EAST : EnumDirectionSWNE.WEST;
        }
        return vector.func_177952_p() > 0 ? EnumDirectionSWNE.SOUTH : EnumDirectionSWNE.NORTH;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderPoint(EntityPlayer player, float tick, float r, float g, float b, float x1, float y1, float z1) {
        double px = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)tick;
        double py = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)tick;
        double pz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)tick;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2832);
        GlStateManager.func_179118_c();
        GL11.glPointSize((float)6.0f);
        builder.func_181668_a(0, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b(-px + (double)x1, -py + (double)y1, -pz + (double)z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderVector(EntityPlayer player, float tick, float r, float g, float b, float x1, float y1, float z1, float x2, float y2, float z2) {
        double px = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)tick;
        double py = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)tick;
        double pz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)tick;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GlStateManager.func_179118_c();
        GL11.glLineWidth((float)10.0f);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b(-px + (double)x1, -py + (double)y1, -pz + (double)z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        builder.func_181662_b(-px + (double)x2, -py + (double)y2, -pz + (double)z2).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

