/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.client.bakedmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.block.BlockTrackSWNE;
import net.railsofwar.row.track.client.ModelsTrack;
import net.railsofwar.row.track.client.util.UtilModelTRSR;
import net.railsofwar.row.track.client.util.UtilTrackRender;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.enumeration.EnumTrackState;
import net.railsofwar.row.track.util.PieceProperty;
import net.railsofwar.row.track.util.TrackGeometry;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.apache.commons.lang3.tuple.Pair;

public class ModelTrack
implements IBakedModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("row:blockTrack");

    public List<BakedQuad> func_188616_a(@Nullable IBlockState blockState, @Nullable EnumFacing side, long rand) {
        if (blockState == null) {
            return Collections.emptyList();
        }
        if (side != null) {
            return Collections.emptyList();
        }
        assert (IExtendedBlockState.class.isAssignableFrom(blockState.getClass()));
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)blockState;
        EnumTrackShape shape = (EnumTrackShape)((Object)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.shape));
        int scalarA = (Integer)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.scalarA);
        int scalarB = (Integer)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.scalarB);
        boolean mirrored = (Boolean)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.mirrored);
        EnumRailway railway = (EnumRailway)((Object)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.railway));
        EnumTrackState trackState = (EnumTrackState)((Object)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.trackState));
        int seed = (Integer)extendedBlockState.getValue((IUnlistedProperty)BlockTrackBase.seed);
        EnumDirectionSWNE direction = EnumDirectionSWNE.SOUTH;
        if (extendedBlockState.func_177230_c() instanceof BlockTrackSWNE) {
            direction = (EnumDirectionSWNE)((Object)extendedBlockState.getValue((IUnlistedProperty)BlockTrackSWNE.direction));
        }
        TrackGeometry geometry = new TrackGeometry(railway, shape, scalarA, scalarB, mirrored, seed);
        if (trackState == null) {
            return Collections.emptyList();
        }
        switch (trackState) {
            case MARKUP: {
                return this.processGeometry(geometry, direction, rand, seed, true, false, false, false, false);
            }
            case SLEEPERS: {
                return this.processGeometry(geometry, direction, rand, seed, false, true, false, false, false);
            }
            case RAILS: {
                return this.processGeometry(geometry, direction, rand, seed, false, true, true, true, false);
            }
            case WORKING: {
                return this.processGeometry(geometry, direction, rand, seed, false, true, true, true, true);
            }
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> processGeometry(TrackGeometry geometry, EnumDirectionSWNE direction, long random, int seed, boolean drawMarkup, boolean drawSleepers, boolean drawRailLeft, boolean drawRailRight, boolean drawSpikes) {
        Random generator;
        PieceProperty r;
        HashMap<String, Pair<IModel, IModelState>> map = new HashMap<String, Pair<IModel, IModelState>>();
        if (drawMarkup) {
            // empty if block
        }
        if (drawSleepers) {
            for (Pair<PieceProperty, Integer> p : geometry.getSleepers()) {
                UtilTrackRender.sleeper(map, UtilModelTRSR.stateTSR(UtilModelTRSR.tern(((PieceProperty)p.getLeft()).getPX(), ((PieceProperty)p.getLeft()).getPY(), ((PieceProperty)p.getLeft()).getPZ()), UtilModelTRSR.tern(((PieceProperty)p.getLeft()).getSX(), ((PieceProperty)p.getLeft()).getSY(), ((PieceProperty)p.getLeft()).getSZ()), UtilModelTRSR.rotAPR(((PieceProperty)p.getLeft()).getAzimuth(), ((PieceProperty)p.getLeft()).getPith(), ((PieceProperty)p.getLeft()).getRoll())), (Integer)p.getRight());
            }
        }
        if (drawRailLeft) {
            for (int i = 0; i < ((List)geometry.getRails().getLeft()).size(); ++i) {
                r = (PieceProperty)((List)geometry.getRails().getLeft()).get(i);
                if (i < ((List)geometry.getRails().getLeft()).size() - 1) {
                    UtilTrackRender.rail8vxLeft(map, UtilModelTRSR.stateTRS(UtilModelTRSR.tern(r.getPX(), r.getPY(), r.getPZ()), UtilModelTRSR.rotAPR(r.getAzimuth(), r.getPith(), r.getRoll()), UtilModelTRSR.tern(r.getSX(), r.getSY(), r.getSZ())));
                }
                if (i != 0 && i != ((List)geometry.getRails().getLeft()).size() - 1) continue;
                UtilTrackRender.railButt(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(r.getPX(), r.getPY(), r.getPZ()), UtilModelTRSR.rotAPR(r.getAzimuth(), r.getPith(), r.getRoll())));
            }
            UtilTrackRender.spacerRailLeft(map, geometry.getRailway(), geometry.getSpacer());
        }
        if (drawRailRight) {
            for (int i = 0; i < ((List)geometry.getRails().getRight()).size(); ++i) {
                r = (PieceProperty)((List)geometry.getRails().getRight()).get(i);
                if (i < ((List)geometry.getRails().getRight()).size() - 1) {
                    UtilTrackRender.rail8vxRight(map, UtilModelTRSR.stateTRS(UtilModelTRSR.tern(r.getPX(), r.getPY(), r.getPZ()), UtilModelTRSR.rotAPR(r.getAzimuth(), r.getPith(), r.getRoll()), UtilModelTRSR.tern(r.getSX(), r.getSY(), r.getSZ())));
                }
                if (i != 0 && i != ((List)geometry.getRails().getRight()).size() - 1) continue;
                UtilTrackRender.railButt(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(r.getPX(), r.getPY(), r.getPZ()), UtilModelTRSR.rotAPR(r.getAzimuth(), r.getPith(), r.getRoll())));
            }
            UtilTrackRender.spacerRailRight(map, geometry.getRailway(), geometry.getSpacer());
        }
        if (drawSpikes) {
            for (PieceProperty l : geometry.getSpikes()) {
                UtilTrackRender.spikesPair(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(l.getPX(), l.getPY(), l.getPZ()), UtilModelTRSR.rotAPR(l.getAzimuth(), l.getPith(), l.getRoll())));
            }
        }
        if (geometry.getShape() == EnumTrackShape.SWITCH_CIRCULAR) {
            float radian = EnumDiagonal.byOrdinal(geometry.getScalarB()).getRadian();
            float H = UtilTrackGeometry.getSwitchCircularHeight(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float h = UtilTrackGeometry.getSwitchCrossRailHeight2(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float a = UtilTrackGeometry.getSwitchCrossRailAngle(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float a2 = UtilTrackGeometry.getSwitchCounterAngle(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float h2 = UtilTrackGeometry.getSwitchBladeStraightPivot(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float h3 = UtilTrackGeometry.getSwitchBladeCurvePivot(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float h4 = UtilTrackGeometry.getSwitchCrossRailHeight3(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, radian);
            float g = geometry.getRailway().getGauge().getWidth() / 2.0f;
            float s = UtilTrackGeometry.getCircularGap((float)geometry.getScalarA() + 0.5f, radian);
            float r2 = UtilTrackGeometry.getCircularRadius((float)geometry.getScalarA() + 0.5f, radian);
            float f = (h4 - h) / 0.75f;
            float p = 1.0f - 0.105f * (r2 - 15.363f) / 15.363f;
            if (!geometry.isMirrored()) {
                UtilTrackRender.counterInLeft(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(-g + 0.0625f, 0.0f, -0.5f + s + h3)));
                UtilTrackRender.counterInRight(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(-g, 0.0f, -0.5f + s + h2), UtilModelTRSR.rotY((float)Math.toDegrees(a))));
                UtilTrackRender.counterLeft(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(g - 0.125f, 0.0f, -0.5f + s + h3 + 0.0625f)));
                UtilTrackRender.counterRight(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern((float)((double)(-r2) + (double)(r2 - g + 0.125f) * Math.cos(a2)), 0.0f, (float)((double)(-0.5f + s) + (double)(r2 - g + 0.125f) * Math.sin(a2))), UtilModelTRSR.rotAPR((float)Math.toDegrees(a2), 0.0f, 0.0f)));
                UtilTrackRender.frogRight(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(-g, 1.0E-4f, -0.5f + h + s), UtilModelTRSR.tern(0.75f, 1.0f, f)));
                UtilTrackRender.plateRight(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(-g + 0.21875f, 0.0f, h + s - 0.125f), UtilModelTRSR.tern(p, 1.0f, 1.0f)));
            } else {
                UtilTrackRender.counterInRight(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(g - 0.0625f, 0.0f, -0.5f + s + h3)));
                UtilTrackRender.counterInLeft(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(g, 0.0f, -0.5f + s + h2), UtilModelTRSR.rotY((float)(-Math.toDegrees(a)))));
                UtilTrackRender.counterRight(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(-g + 0.125f, 0.0f, -0.5f + s + h3 + 0.0625f)));
                UtilTrackRender.counterLeft(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern((float)((double)r2 - (double)(r2 - g + 0.125f) * Math.cos(a2)), 0.0f, (float)((double)(-0.5f + s) + (double)(r2 - g + 0.125f) * Math.sin(a2))), UtilModelTRSR.rotAPR((float)(-Math.toDegrees(a2)), 0.0f, 0.0f)));
                UtilTrackRender.frogLeft(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(g, 1.0E-4f, -0.5f + h + s), UtilModelTRSR.tern(0.75f, 1.0f, f)));
                UtilTrackRender.plateLeft(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(g - 0.21875f, 0.0f, h + s - 0.125f), UtilModelTRSR.tern(p, 1.0f, 1.0f)));
            }
            UtilTrackRender.railButt(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(g + 0.0625f, 0.0f, -0.5f + H)));
            UtilTrackRender.railButt(map, UtilModelTRSR.stateT(UtilModelTRSR.tern(-g - 0.0625f, 0.0f, -0.5f + H)));
        } else if (geometry.getShape() == EnumTrackShape.SWITCH_WYE) {
            float radian = EnumDiagonal.byOrdinal(geometry.getScalarB()).getRadian();
            float s = UtilTrackGeometry.getCircularGap((float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float r3 = UtilTrackGeometry.getCircularRadius((float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float g = geometry.getRailway().getGauge().getWidth() / 2.0f;
            float h1 = UtilTrackGeometry.getSwitchWyeCrossRailHeight(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float h2 = UtilTrackGeometry.getSwitchWyeCrossRailHeight2(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float h3 = UtilTrackGeometry.getSwitchWyeBladePivot(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float a = UtilTrackGeometry.getSwitchWyeCounterInAngle(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float a2 = UtilTrackGeometry.getSwitchWyeCounterAngle(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float frogLength = h2 - h1;
            float frogWidth = UtilTrackGeometry.getSwitchWyeFrogWidth(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            float rc = r3 - g + 0.15625f;
            float hp = UtilTrackGeometry.getSwitchWyeBladePivot(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45) + 0.8f * (float)Math.cos(a);
            float pw = UtilTrackGeometry.getSwitchWyePlateWidth(geometry.getRailway(), (float)geometry.getScalarA() + 0.5f, UtilTrackGeometry.ANGLE45);
            UtilTrackRender.frogWye(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(0.0f, 1.0E-4f, -0.5f + s + h1), UtilModelTRSR.tern(frogWidth / 7.235f * 16.0f, 1.0f, frogLength / 8.0f * 16.0f)));
            UtilTrackRender.counterInRight(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(-0.03125f, 0.0f, -0.5f + s + h3), UtilModelTRSR.rotY((float)Math.toDegrees(a) + 2.0f)));
            UtilTrackRender.counterInLeft(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(0.03125f, 0.0f, -0.5f + s + h3), UtilModelTRSR.rotY(-((float)Math.toDegrees(a)) - 2.0f)));
            UtilTrackRender.counterRight(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern((float)((double)(-r3) + (double)rc * Math.cos(a2)), 0.0f, (float)((double)(-0.5f + s) + (double)rc * Math.sin(a2))), UtilModelTRSR.rotAPR((float)Math.toDegrees(a2), 0.0f, 0.0f)));
            UtilTrackRender.counterLeft(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern((float)((double)r3 - (double)rc * Math.cos(a2)), 0.0f, (float)((double)(-0.5f + s) + (double)rc * Math.sin(a2))), UtilModelTRSR.rotAPR(-((float)Math.toDegrees(a2)), 0.0f, 0.0f)));
            UtilTrackRender.plateWye(map, UtilModelTRSR.stateTS(UtilModelTRSR.tern(0.0f, 0.0f, -0.5f + s + hp - 0.0f), UtilModelTRSR.tern(pw, 1.0f, 1.0f)));
        } else if (geometry.getShape() == EnumTrackShape.DIAMOND_STRAIGHT) {
            float sx;
            float sz;
            float sa;
            int i;
            generator = UtilTrackGeometry.getGenerator(seed);
            UtilTrackRender.put(map, ModelsTrack.diamondStraight, UtilModelTRSR.st());
            int sleepers = Math.round(3.0f * (float)geometry.getRailway().getDensity() / 1000.0f);
            float gap = 3.0f / (float)sleepers;
            for (i = 0; i < sleepers; ++i) {
                float sx2 = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                float sz2 = -1.5f + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = 90.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(sx2, 0.0f, sz2), UtilModelTRSR.rotY(sa)));
            }
            sleepers = Math.round(0.75f * (float)geometry.getRailway().getDensity() / 1000.0f);
            gap = 0.75f / (float)sleepers;
            for (i = 0; i < sleepers; ++i) {
                sz = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                sx = -1.5f + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(sx, 0.0f, sz), UtilModelTRSR.rotY(sa)));
            }
            for (i = 0; i < sleepers; ++i) {
                sz = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                sx = -1.5f + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(-sx, 0.0f, sz), UtilModelTRSR.rotY(sa)));
            }
        } else if (geometry.getShape() == EnumTrackShape.DIAMOND_DIAGONAL) {
            float sa;
            float axial;
            float trans;
            int i;
            generator = UtilTrackGeometry.getGenerator(seed);
            UtilTrackRender.put(map, ModelsTrack.diamondDiagonal, UtilModelTRSR.st());
            float length = 4.2426405f;
            int sleepers = Math.round(length * (float)geometry.getRailway().getDensity() / 1000.0f);
            float gap = length / (float)sleepers;
            float cosg = (float)Math.cos(Math.toRadians(45.0));
            float sing = (float)Math.sin(Math.toRadians(45.0));
            for (i = 0; i < sleepers; ++i) {
                trans = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                axial = -2.1213202f + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = -45.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(trans * cosg - axial * sing, 0.0f, trans * sing + axial * cosg), UtilModelTRSR.rotY(sa)));
            }
            length = 1.0606601f;
            sleepers = Math.round(length * (float)geometry.getRailway().getDensity() / 1000.0f);
            gap = length / (float)sleepers;
            cosg = (float)Math.cos(Math.toRadians(135.0));
            sing = (float)Math.sin(Math.toRadians(135.0));
            for (i = 0; i < sleepers; ++i) {
                trans = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                axial = -2.1213202f + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = 45.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(trans * cosg - axial * sing, 0.0f, trans * sing + axial * cosg), UtilModelTRSR.rotY(sa)));
            }
            for (i = 0; i < sleepers; ++i) {
                trans = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                axial = 2.1213202f - gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                sa = 45.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(trans * cosg - axial * sing, 0.0f, trans * sing + axial * cosg), UtilModelTRSR.rotY(sa)));
            }
        } else if (geometry.getShape() == EnumTrackShape.DIAMOND_SHARP) {
            generator = UtilTrackGeometry.getGenerator(seed);
            boolean m = geometry.isMirrored();
            float length = 3.5f;
            int sleepers = Math.round(length * (float)geometry.getRailway().getDensity() / 1000.0f);
            float gap = length / (float)sleepers;
            float cosg = (float)Math.cos(Math.toRadians(22.5f * (m ? -1.0f : 1.0f)));
            float sing = (float)Math.sin(Math.toRadians(22.5f * (m ? -1.0f : 1.0f)));
            if (m) {
                UtilTrackRender.put(map, ModelsTrack.diamondSharpLeft, UtilModelTRSR.st());
            } else {
                UtilTrackRender.put(map, ModelsTrack.diamondSharpRight, UtilModelTRSR.st());
            }
            for (int i = 0; i < sleepers; ++i) {
                float trans = geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
                float axial = -0.5f * length + gap * ((float)i + 0.5f) + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
                float sa = (m ? -1.0f : 1.0f) * -67.5f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
                int w = 26 + 4 * Math.round(12.0f * Math.abs(axial) / length);
                UtilTrackRender.sleeper(map, UtilModelTRSR.stateTR(UtilModelTRSR.tern(trans * cosg - axial * sing, 0.0f, trans * sing + axial * cosg), UtilModelTRSR.rotY(sa)), w);
            }
            UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f), 0.0f, 2.3125f + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f)), UtilModelTRSR.rotY(90.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f))));
            UtilTrackRender.put(map, ModelsTrack.sleeper24vx, UtilModelTRSR.stateTR(UtilModelTRSR.tern(geometry.getRailway().getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f), 0.0f, -2.3125f + geometry.getRailway().getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f)), UtilModelTRSR.rotY(90.0f + geometry.getRailway().getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f))));
        } else if (geometry.getShape() == EnumTrackShape.TURNTABLE) {
            UtilTrackRender.put(map, ModelsTrack.ttBase, UtilModelTRSR.st());
            UtilTrackRender.put(map, ModelsTrack.ttRailsFixed, UtilModelTRSR.st());
        }
        if (!map.isEmpty()) {
            IModelState modelStateBase = UtilModelTRSR.stateTR(UtilModelTRSR.tern(0.5f, 0.001f, 0.5f), UtilModelTRSR.rotY(direction.getAzimuth()));
            IBakedModel modelBaked = new MultiModel(null, null, null, map).bake(modelStateBase, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
            return modelBaked.func_188616_a(null, null, random);
        }
        return Collections.EMPTY_LIST;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("row:block/blocktrackdamagesprite");
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return null;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

