/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.client.tesr;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.block.BlockTrackSWNE;
import net.railsofwar.row.track.client.ModelsTrack;
import net.railsofwar.row.track.tileentity.TilePointer;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import org.lwjgl.opengl.GL11;

public class RenderPointer
extends TileEntitySpecialRenderer<TilePointer> {
    public void render(TilePointer tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileTrackSWNE track;
        BlockPos pos = tile.func_174877_v();
        int[] d = RotationHelper.rotateByDir((int)tile.offset, 2, tile.direction);
        pos = pos.func_177982_a(d[0], 0, d[1]);
        float progress = 0.5f;
        boolean activated = false;
        float offset = tile.offset - (float)((int)tile.offset);
        boolean inverse = false;
        offset = (float)((double)offset - 0.5 * (double)Math.signum(tile.offset));
        if (tile.attached && tile.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockTrackSWNE && (track = (TileTrackSWNE)tile.func_145831_w().func_175625_s(pos)) != null) {
            progress = (float)track.progress / 20.0f;
            activated = track.activated;
            inverse = track.mirrored;
        }
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.03125), (double)(z + 0.5));
        GL11.glRotatef((float)(-tile.direction.getAzimuth() + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-offset));
        this.doRender(tile.mirrored, tile.attached, activated, progress, tile.right ? -1.0f : 1.0f, inverse);
        GlStateManager.func_179121_F();
    }

    private void doRender(boolean mirrored, boolean attached, boolean activated, float progress, float mult, boolean flag) {
        float lever = -65.0f + 130.0f * progress;
        float fork = activated ? (lever < 25.0f ? -20.0f : -20.0f + (lever - 25.0f)) : (lever > -25.0f ? 20.0f : lever + 45.0f);
        float lamp = -90.0f * progress + (flag ? 90.0f : 0.0f);
        lever *= mult;
        float h = 4.5f * (float)(Math.cos(Math.toRadians(fork *= mult)) - (double)0.9397f);
        float link = (float)Math.toDegrees(Math.atan2(h, 32.0));
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(mirrored ? -0.25f : 0.25f));
        if (attached) {
            UtilModels.renderModel(ModelsTrack.pointerSleeperLong);
        } else {
            UtilModels.renderModel(ModelsTrack.pointerSleeperShort);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)(mirrored ? -0.25f : 0.25f));
        if (mirrored) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        UtilModels.renderModel(ModelsTrack.pointerBase);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)(mirrored ? -0.4375f : 0.4375f));
        GL11.glRotatef((float)lamp, (float)0.0f, (float)1.0f, (float)0.0f);
        UtilModels.renderModel(ModelsTrack.pointerLamp);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)-0.125f, (float)0.3125f, (float)(mirrored ? -0.0f : 0.0f));
        GlStateManager.func_179094_E();
        GL11.glRotatef((float)lever, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsTrack.pointerLever);
        GlStateManager.func_179121_F();
        GL11.glRotatef((float)fork, (float)0.0f, (float)0.0f, (float)1.0f);
        UtilModels.renderModel(ModelsTrack.pointerFork);
        GL11.glTranslatef((float)0.0f, (float)-0.28125f, (float)-0.0f);
        GL11.glRotatef((float)(-fork), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)link, (float)0.0f, (float)0.0f, (float)1.0f);
        if (attached) {
            UtilModels.renderModel(ModelsTrack.pointerLink);
        }
        GlStateManager.func_179121_F();
    }
}

