/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.client.tesr;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.common.client.util.UtilModels;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.client.ModelsTrack;
import net.railsofwar.row.track.client.util.UtilModelTRSR;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.tileentity.TileTrackBase;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.tileentity.TileTurntable;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.lwjgl.opengl.GL11;

public class RenderTrack
extends TileEntitySpecialRenderer<TileTrackBase> {
    public void render(TileTrackBase t, double dx, double dy, double dz, float partial, int destroyStage, float alpha) {
        IExtendedBlockState exState;
        IBlockState tryState;
        IBlockState blockState;
        TileTrackSWNE tile;
        if (Config.renderTrackBoxes) {
            RenderTrack.renderTrackBox(dx, dy, dz, -16776961);
        }
        if (t instanceof TileTurntable) {
            tile = (TileTurntable)t;
            blockState = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            tryState = RoWTracks.blockTurntable.getExtendedState(blockState, (IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
            if (!(tryState instanceof IExtendedBlockState)) {
                return;
            }
            exState = (IExtendedBlockState)tryState;
            this.func_147499_a(TextureMap.field_110575_b);
            this.renderTurntable((TileTurntable)tile, exState, dx, dy, dz, partial);
        }
        if (t instanceof TileTrackSWNE) {
            tile = (TileTrackSWNE)t;
            blockState = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            tryState = RoWTracks.blockTrackSWNE.getExtendedState(blockState, (IBlockAccess)tile.func_145831_w(), tile.func_174877_v());
            if (!(tryState instanceof IExtendedBlockState)) {
                return;
            }
            exState = (IExtendedBlockState)tryState;
            EnumTrackShape shape = (EnumTrackShape)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.shape));
            this.func_147499_a(TextureMap.field_110575_b);
            if (shape == EnumTrackShape.SWITCH_CIRCULAR) {
                this.renderSwitchCircular(tile, exState, dx, dy, dz);
            } else if (shape == EnumTrackShape.SWITCH_WYE) {
                this.renderSwitchWye(tile, exState, dx, dy, dz);
            }
        }
    }

    public static void renderTrackBox(double dx, double dy, double dz, int colour) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)(dx + 0.5), (double)dy, (double)(dz + 0.5));
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : ModelsTrack.trackGag.bake(UtilModelTRSR.st(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()).func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)tessellator.func_178180_c(), (BakedQuad)bakedquad, (int)colour);
        }
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    public void renderTurntable(TileTurntable tile, IExtendedBlockState exState, double dx, double dy, double dz, float partial) {
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(dx + 0.5), (double)dy, (double)(dz + 0.5));
        GlStateManager.func_179094_E();
        GL11.glRotatef((float)(-UtilMath.inpDeg(tile.azimuth, tile.azimuthPrev, partial)), (float)0.0f, (float)1.0f, (float)0.0f);
        UtilModels.renderModel(ModelsTrack.ttPlate);
        UtilModels.renderModel(ModelsTrack.ttRails);
        GlStateManager.func_179121_F();
        GL11.glTranslated((double)0.0, (double)0.28125, (double)-1.4375);
        GL11.glRotatef((float)(-tile.getLockAngle(partial)), (float)1.0f, (float)0.0f, (float)0.0f);
        UtilModels.renderModel(ModelsTrack.ttLock);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public void renderSwitchWye(TileTrackSWNE tile, IExtendedBlockState exState, double dx, double dy, double dz) {
        float azimuth;
        float axial;
        float transverse;
        int i;
        EnumRailway railway = (EnumRailway)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.railway));
        int scalarA = (Integer)exState.getValue((IUnlistedProperty)BlockTrackBase.scalarA);
        int scalarB = (Integer)exState.getValue((IUnlistedProperty)BlockTrackBase.scalarB);
        float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
        float progress = (float)tile.progress / 20.0f;
        float lever = -65.0f + 130.0f * progress;
        float p = tile.activated ? (lever < 25.0f ? 0.0f : (lever - 25.0f) / 40.0f) : (lever > -25.0f ? 1.0f : (lever + 65.0f) / 40.0f);
        float g = railway.getGauge().getWidth();
        float gap = UtilTrackGeometry.getCircularGap((float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float pivot = UtilTrackGeometry.getSwitchWyeBladePivot(railway, (float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float angleCurve = 1.02f * UtilTrackGeometry.getSwitchBladeAngleWye(railway, (float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float axisRadius = UtilTrackGeometry.getCircularRadius((float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float curveRadius = axisRadius + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float lengthCurve = angleCurve * curveRadius;
        float height = UtilTrackGeometry.getSwitchBladeHeight(railway, (float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float bladeRotation = (float)Math.toDegrees(Math.atan(0.0625f / (pivot - height))) * 1.0f;
        float bladeScale = UtilTrackGeometry.getSwitchBladeScaleWye((float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float bladeTwist = UtilTrackGeometry.getSwitchBladeTwistWye((float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        float initialAngle = (float)Math.toDegrees(UtilTrackGeometry.getSwitchBladeInitialAngleWye(railway, (float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45));
        float pointerHeight = UtilTrackGeometry.getSwitchPointerHeight(railway, (float)scalarA + 0.5f, UtilTrackGeometry.ANGLE45);
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(dx + 0.5), (double)dy, (double)(dz + 0.5));
        GL11.glRotatef((float)(-tile.direction.getAzimuth()), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)0.125f, (float)0.001f, (float)(gap + pivot));
        GL11.glRotatef((float)(2.0f * bladeRotation * p), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(g / 2.0f - 0.125f), (float)0.0f, (float)(-pivot + height));
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)0.03125f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-bladeTwist), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)(bladeScale * 1.01f));
        UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_wl);
        GlStateManager.func_179121_F();
        GL11.glTranslatef((float)0.09375f, (float)0.0f, (float)(1.0625f * bladeScale));
        float deg = (float)Math.toDegrees(angleCurve);
        int rails = Math.round(lengthCurve / 0.5f);
        float scale = lengthCurve / ((float)rails * 8.0f / 16.0f);
        GL11.glRotatef((float)(-initialAngle * 0.65f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (i = 0; i < rails; ++i) {
            transverse = -curveRadius + curveRadius * (float)Math.cos((float)i * angleCurve / (float)rails);
            axial = curveRadius * (float)Math.sin((float)i * angleCurve / (float)rails);
            azimuth = ((float)i + 0.5f) * deg / (float)rails;
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)transverse, (float)0.0f, (float)axial);
            GL11.glRotatef((float)(-azimuth), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_r);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)-0.125f, (float)0.001f, (float)(gap + pivot));
        GL11.glRotatef((float)(2.0f * bladeRotation * (p - 1.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-g / 2.0f + 0.125f), (float)0.0f, (float)(-pivot + height));
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)-0.03125f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)bladeTwist, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)(bladeScale * 1.01f));
        UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_wr);
        GlStateManager.func_179121_F();
        GL11.glTranslatef((float)-0.09375f, (float)0.0f, (float)(1.0625f * bladeScale));
        deg = (float)Math.toDegrees(angleCurve);
        rails = Math.round(lengthCurve / 0.5f);
        scale = lengthCurve / ((float)rails * 8.0f / 16.0f);
        GL11.glRotatef((float)(initialAngle * 0.65f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (i = 0; i < rails; ++i) {
            transverse = curveRadius - curveRadius * (float)Math.cos((float)i * angleCurve / (float)rails);
            axial = curveRadius * (float)Math.sin((float)i * angleCurve / (float)rails);
            azimuth = ((float)i + 0.5f) * deg / (float)rails;
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)transverse, (float)0.0f, (float)axial);
            GL11.glRotatef((float)azimuth, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_l);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(0.0625f - 0.125f * p), (double)0.0, (double)pointerHeight);
        UtilModels.renderModel(ModelsTrack.pointerLinkBar);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public void renderSwitchCircular(TileTrackSWNE tile, IExtendedBlockState exState, double dx, double dy, double dz) {
        EnumRailway railway = (EnumRailway)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.railway));
        int scalarA = (Integer)exState.getValue((IUnlistedProperty)BlockTrackBase.scalarA);
        int scalarB = (Integer)exState.getValue((IUnlistedProperty)BlockTrackBase.scalarB);
        float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
        float progress = (float)tile.progress / 20.0f;
        float lever = -65.0f + 130.0f * progress;
        float p = tile.activated ? (lever < 25.0f ? 0.0f : (lever - 25.0f) / 40.0f) : (lever > -25.0f ? 1.0f : (lever + 65.0f) / 40.0f);
        float g = railway.getGauge().getWidth();
        float gap = UtilTrackGeometry.getCircularGap((float)scalarA + 0.5f, radian);
        float height = UtilTrackGeometry.getSwitchBladeHeight(railway, (float)scalarA + 0.5f, radian);
        float straightPivot = UtilTrackGeometry.getSwitchBladeStraightPivot(railway, (float)scalarA + 0.5f, radian);
        float curvePivot = UtilTrackGeometry.getSwitchBladeCurvePivot(railway, (float)scalarA + 0.5f, radian);
        float bladeScale = UtilTrackGeometry.getSwitchBladeScale((float)scalarA + 0.5f, radian);
        float straightLength = UtilTrackGeometry.getSwitchBladeLength(railway, (float)scalarA + 0.5f, radian);
        float axisRadius = UtilTrackGeometry.getCircularRadius((float)scalarA + 0.5f, radian);
        float curveRadius = axisRadius + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float angleCurve = 1.02f * UtilTrackGeometry.getSwitchBladeAngle(railway, (float)scalarA + 0.5f, radian);
        float lengthCurve = angleCurve * curveRadius;
        float initialAngle = (float)Math.toDegrees(UtilTrackGeometry.getSwitchBladeInitialAngle(railway, (float)scalarA + 0.5f, radian));
        float pointerHeight = UtilTrackGeometry.getSwitchPointerHeight(railway, (float)scalarA + 0.5f, radian);
        float bladeRotation = (float)Math.toDegrees(Math.atan(0.0625f / straightLength));
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(dx + 0.5), (double)dy, (double)(dz + 0.5));
        GL11.glRotatef((float)(-tile.direction.getAzimuth()), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.5f);
        if (!((Boolean)exState.getValue((IUnlistedProperty)BlockTrackBase.mirrored)).booleanValue()) {
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)(-g / 2.0f - 0.0625f), (float)0.0f, (float)(gap + straightPivot));
            GL11.glRotatef((float)(bladeRotation * (p - 1.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)-0.0625f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int rails = Math.round(straightLength / 0.5f);
            float scale = straightLength / ((float)rails * 8.0f / 16.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            for (int i = 0; i < rails; ++i) {
                UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_r);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
            }
            GlStateManager.func_179121_F();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-straightPivot + height));
            GL11.glScalef((float)1.0f, (float)1.0f, (float)bladeScale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_sr);
            GlStateManager.func_179121_F();
            RenderTrack.renderBladeCurvedRight(g, gap, curvePivot, bladeRotation, p, height, bladeScale, angleCurve, lengthCurve, initialAngle, curveRadius);
        } else {
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)(g / 2.0f + 0.0625f), (float)0.0f, (float)(gap + straightPivot));
            GL11.glRotatef((float)(bladeRotation * p), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)0.0625f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int rails = Math.round(straightLength / 0.5f);
            float scale = straightLength / ((float)rails * 8.0f / 16.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            for (int i = 0; i < rails; ++i) {
                UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_l);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
            }
            GlStateManager.func_179121_F();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-straightPivot + height));
            GL11.glScalef((float)1.0f, (float)1.0f, (float)bladeScale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_sl);
            GlStateManager.func_179121_F();
            RenderTrack.renderBladeCurvedLeft(g, gap, curvePivot, bladeRotation, p, height, bladeScale, angleCurve, lengthCurve, initialAngle, curveRadius);
        }
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(0.0625f - 0.125f * p), (double)0.0, (double)pointerHeight);
        UtilModels.renderModel(ModelsTrack.pointerLinkBar);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    public static void renderBladeCurvedRight(float g, float gap, float pivot, float bladeRotation, float p, float height, float bladeScale, float angleCurve, float lengthCurve, float initialAngle, float curveRadius) {
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)(-g / 2.0f + 0.1875f), (float)0.0f, (float)(gap + pivot));
        GL11.glRotatef((float)(bladeRotation * p), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(g - 0.1875f), (float)0.0f, (float)(-pivot + height));
        GlStateManager.func_179094_E();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)bladeScale);
        UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_cr);
        GlStateManager.func_179121_F();
        GL11.glTranslatef((float)-0.057f, (float)0.0f, (float)(1.436f * bladeScale));
        float deg = (float)Math.toDegrees(angleCurve);
        int rails = Math.round(lengthCurve / 0.5f);
        float scale = lengthCurve / ((float)rails * 8.0f / 16.0f);
        GL11.glRotatef((float)(-initialAngle * 0.65f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (int i = 0; i < rails; ++i) {
            float transverse = -curveRadius + curveRadius * (float)Math.cos((float)i * angleCurve / (float)rails);
            float axial = curveRadius * (float)Math.sin((float)i * angleCurve / (float)rails);
            float azimuth = ((float)i + 0.5f) * deg / (float)rails;
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)transverse, (float)0.0f, (float)axial);
            GL11.glRotatef((float)(-azimuth), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_r);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public static void renderBladeCurvedLeft(float g, float gap, float pivot, float bladeRotation, float p, float height, float bladeScale, float angleCurve, float lengthCurve, float initialAngle, float curveRadius) {
        GlStateManager.func_179094_E();
        GL11.glTranslatef((float)(g / 2.0f - 0.1875f), (float)0.0f, (float)(gap + pivot));
        GL11.glRotatef((float)(bladeRotation * (p - 1.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-g + 0.1875f), (float)0.0f, (float)(-pivot + height));
        GlStateManager.func_179094_E();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)bladeScale);
        UtilModels.renderModel(ModelsTrack.rail750SwitchBlade_cl);
        GlStateManager.func_179121_F();
        GL11.glTranslatef((float)0.057f, (float)0.0f, (float)(1.436f * bladeScale));
        float deg = (float)Math.toDegrees(angleCurve);
        int rails = Math.round(lengthCurve / 0.5f);
        float scale = lengthCurve / ((float)rails * 8.0f / 16.0f);
        GL11.glRotatef((float)(initialAngle * 0.65f), (float)0.0f, (float)1.0f, (float)0.0f);
        for (int i = 0; i < rails; ++i) {
            float transverse = curveRadius - curveRadius * (float)Math.cos((float)i * angleCurve / (float)rails);
            float axial = curveRadius * (float)Math.sin((float)i * angleCurve / (float)rails);
            float azimuth = ((float)i + 0.5f) * deg / (float)rails;
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)transverse, (float)0.0f, (float)axial);
            GL11.glRotatef((float)azimuth, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)scale);
            UtilModels.renderModel(ModelsTrack.rail750SwitchFiller_l);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }
}

