/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.packets.PacketSendTrackData;

public class TrackManager
extends WorldSavedData {
    public static final String nameBase = "row_tracks";
    private CopyOnWriteArrayList<CopyOnWriteArrayList<BlockPos>> pieces = new CopyOnWriteArrayList();
    public static final String piece_name = "piece_";
    public static final String pieces_count = "pieces_count";

    public TrackManager(String name) {
        this();
    }

    public TrackManager() {
        super(nameBase);
    }

    public void addPart(World world, BlockPos origin, BlockPos posIn) {
        for (List list : this.pieces) {
            for (BlockPos pos : list) {
                if (!pos.equals((Object)posIn)) continue;
                return;
            }
        }
        int id = this.getPieceID(origin);
        if (id == -1) {
            id = this.pieces.size();
            this.pieces.add(id, new CopyOnWriteArrayList());
            this.pieces.get(id).add(origin);
        }
        if (!posIn.equals((Object)origin)) {
            this.pieces.get(id).add(posIn);
        }
        this.sendPartAdded(world, origin, posIn);
    }

    public void removePiece(World world, BlockPos partPos) {
        int pieceID = this.getPieceID(partPos);
        if (pieceID == -1 || pieceID >= this.pieces.size()) {
            return;
        }
        List piece = this.pieces.get(pieceID);
        if (piece != null) {
            for (BlockPos pos : piece) {
                if (pos == null) continue;
                world.func_175698_g(pos);
                world.func_175713_t(pos);
            }
        }
        this.pieces.remove(pieceID);
        this.sendPartDeleted(world, partPos);
    }

    public void sendAllPieces(World world) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            for (List list : this.pieces) {
                for (int j = 0; j < list.size(); ++j) {
                    RoWTracks.network.sendToAll((IMessage)new PacketSendTrackData((BlockPos)list.get(0), (BlockPos)list.get(j)));
                }
            }
        }
    }

    private void sendPartAdded(World world, BlockPos origin, BlockPos part) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            RoWTracks.network.sendToAll((IMessage)new PacketSendTrackData(origin, part));
        }
    }

    private void sendPartDeleted(World world, BlockPos origin) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            RoWTracks.network.sendToAll((IMessage)new PacketSendTrackData(origin));
        }
    }

    public void notifyPiece(World world, BlockPos partPos) {
        int pieceID = this.getPieceID(partPos);
        if (pieceID == -1) {
            return;
        }
        List piece = this.pieces.get(pieceID);
        for (BlockPos pos : piece) {
            world.func_175685_c(pos, world.func_180495_p(pos).func_177230_c(), true);
        }
    }

    public int getPieceID(BlockPos partPos) {
        int i = 0;
        for (CopyOnWriteArrayList<BlockPos> piece : this.pieces) {
            if (piece.indexOf(partPos) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    public BlockPos getPieceOrigin(BlockPos partPos) {
        int pieceID = this.getPieceID(partPos);
        if (pieceID != -1) {
            return this.pieces.get(pieceID).get(0);
        }
        return null;
    }

    public List<BlockPos> getAllParts() {
        CopyOnWriteArrayList<BlockPos> allParts = new CopyOnWriteArrayList<BlockPos>();
        for (List list : this.pieces) {
            allParts.addAll(list);
        }
        return allParts;
    }

    public static String getDimensionalName(int id) {
        return nameBase + id;
    }

    public void func_76184_a(NBTTagCompound tag) {
        int piecesCount = tag.func_74762_e(pieces_count);
        this.pieces = new CopyOnWriteArrayList();
        for (int i = 0; i < piecesCount; ++i) {
            int[] pieceCoords = tag.func_74759_k(piece_name + i);
            CopyOnWriteArrayList<BlockPos> piece = new CopyOnWriteArrayList<BlockPos>();
            for (int j = 0; j < pieceCoords.length / 3; ++j) {
                BlockPos partPos = new BlockPos(pieceCoords[3 * j], pieceCoords[3 * j + 1], pieceCoords[3 * j + 2]);
                piece.add(partPos);
            }
            this.pieces.add(piece);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74768_a(pieces_count, this.pieces.size());
        for (int i = 0; i < this.pieces.size(); ++i) {
            List piece = this.pieces.get(i);
            int[] coordinates = new int[3 * piece.size()];
            for (int j = 0; j < piece.size(); ++j) {
                coordinates[3 * j] = ((BlockPos)piece.get(j)).func_177958_n();
                coordinates[3 * j + 1] = ((BlockPos)piece.get(j)).func_177956_o();
                coordinates[3 * j + 2] = ((BlockPos)piece.get(j)).func_177952_p();
            }
            tag.func_74783_a(piece_name + i, coordinates);
        }
        return tag;
    }
}

