/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.enumeration;

public enum EnumDiagonal {
    DIAGONAL_INF(-5),
    DIAGONAL_14(-4),
    DIAGONAL_13(-3),
    DIAGONAL_12(-2),
    DIAGONAL_1(1),
    DIAGONAL_2(2),
    DIAGONAL_3(3),
    DIAGONAL_4(4),
    DIAGONAL_ZERO(0);

    private final int base;
    private final float radian;
    private final float degree;

    private EnumDiagonal(int base) {
        this.base = base;
        this.radian = base < -4 ? 1.5707964f : (base == 0 ? 0.0f : (float)Math.atan(base > 0 ? (double)(1.0f / (float)base) : (double)(1.0f - (float)base)));
        this.degree = (float)Math.toDegrees(this.radian);
    }

    public static EnumDiagonal byOrdinal(int base) {
        if (base > 0 && base < 8) {
            return EnumDiagonal.values()[base];
        }
        return DIAGONAL_1;
    }

    public int getBase() {
        return this.base;
    }

    public float getRadian() {
        return this.radian;
    }

    public float getDegree() {
        return this.degree;
    }
}

