/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.enumeration;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.railsofwar.row.track.enumeration.EnumGauge;
import net.railsofwar.row.track.enumeration.EnumRailProfile;

public enum EnumRailway {
    RW750IDEAL1000("750-ideal-1000", 0, EnumGauge.G750, EnumRailProfile.RP750REGULAR, 0.0625f, 1000, 24, 0.0f, 0.0f, 0.0f),
    RW750IDEAL2000("750-ideal-2000", 1, EnumGauge.G750, EnumRailProfile.RP750REGULAR, 0.0625f, 2000, 24, 0.0f, 0.0f, 0.0f),
    RW750REGULAR("750-regular", 2, EnumGauge.G750, EnumRailProfile.RP750REGULAR, 0.0625f, 1840, 24, 0.0375f, 0.0375f, 2.0f),
    RW750STAGGERED("750-staggered", 3, EnumGauge.G750, EnumRailProfile.RP750REGULAR, 0.0625f, 1440, 24, 0.0625f, 0.09375f, 5.0f),
    RW750MINING("750-mining", 4, EnumGauge.G750, EnumRailProfile.RP750REGULAR, 0.0625f, 800, 24, 0.09375f, 0.1015625f, 9.0f);

    private final String name;
    private final int index;
    private final EnumGauge gauge;
    private final EnumRailProfile railProfile;
    private final float railFootRaise;
    private final int density;
    private final int sleeperWidth;
    private final float tolAxial;
    private final float tolTransverse;
    private final float tolAngular;
    private static final EnumRailway[] VALUES;
    private static final Map<String, EnumRailway> NAME_LOOKUP;

    private EnumRailway(String name, int index, EnumGauge gauge, EnumRailProfile railProfile, float railFootRaise, int density, int sleeperWidth, float tolAxial, float tolTransverse, float tolAngular) {
        this.name = name;
        this.index = index;
        this.gauge = gauge;
        this.railProfile = railProfile;
        this.railFootRaise = railFootRaise;
        this.density = density;
        this.sleeperWidth = sleeperWidth;
        this.tolAxial = tolAxial;
        this.tolTransverse = tolTransverse;
        this.tolAngular = tolAngular;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public EnumGauge getGauge() {
        return this.gauge;
    }

    public EnumRailProfile getRailProfile() {
        return this.railProfile;
    }

    public int getDensity() {
        return this.density;
    }

    public float getTolAxial() {
        return this.tolAxial;
    }

    public float getTolTransverse() {
        return this.tolTransverse;
    }

    public float getTolAngular() {
        return this.tolAngular;
    }

    public int getSleeperWidth() {
        return this.sleeperWidth;
    }

    public float getTopOfRail() {
        return this.railFootRaise + this.railProfile.getWorkingHeight();
    }

    public static EnumRailway byIndex(int index) {
        return VALUES[index % EnumRailway.values().length];
    }

    @Nullable
    public static EnumRailway byName(@Nullable String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    public static EnumRailway byNameSafely(@Nullable String name) {
        return name == null ? RW750REGULAR : NAME_LOOKUP.get(name.toLowerCase());
    }

    static {
        VALUES = new EnumRailway[5];
        NAME_LOOKUP = Maps.newHashMap();
        EnumRailway[] enumRailwayArray = EnumRailway.values();
        int n = enumRailwayArray.length;
        for (int i = 0; i < n; ++i) {
            EnumRailway railway;
            EnumRailway.VALUES[railway.index] = railway = enumRailwayArray[i];
            NAME_LOOKUP.put(railway.getName().toLowerCase(), railway);
        }
    }
}

