/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.enumeration;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public enum EnumTrackShape {
    STRAIGHT("straight"),
    DIAGONAL("diagonal"),
    CIRCULAR("circular"),
    PARALLEL("parallel"),
    DIAMOND_STRAIGHT("diamondStraight"),
    DIAMOND_DIAGONAL("diamondDiagonal"),
    DIAMOND_SHARP("diamondSharp"),
    SLOPE_STRAIGHT("slopeStraight"),
    SLOPE_DIAGONAL("slopeDiagonal"),
    SWITCH_CIRCULAR("switchCircular"),
    SWITCH_WYE("switchWye"),
    TURNTABLE("turntable");

    private static final EnumTrackShape[] VALUES;
    private static final Map<String, EnumTrackShape> NAME_LOOKUP;
    private final String name;

    private EnumTrackShape(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EnumTrackShape byName(@Nullable String name) {
        return name == null || NAME_LOOKUP.get(name.toLowerCase()) == null ? STRAIGHT : NAME_LOOKUP.get(name.toLowerCase());
    }

    public static EnumTrackShape byIndex(int index) {
        return VALUES[index % EnumTrackShape.values().length];
    }

    static {
        VALUES = new EnumTrackShape[EnumTrackShape.values().length];
        NAME_LOOKUP = Maps.newHashMap();
        EnumTrackShape[] enumTrackShapeArray = EnumTrackShape.values();
        int n = enumTrackShapeArray.length;
        for (int i = 0; i < n; ++i) {
            EnumTrackShape trackShape;
            EnumTrackShape.VALUES[trackShape.ordinal()] = trackShape = enumTrackShapeArray[i];
            NAME_LOOKUP.put(trackShape.getName().toLowerCase(), trackShape);
        }
    }
}

