/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.enumeration;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public enum EnumTrackState {
    MARKUP("markup", 0),
    SLEEPERS("sleepers", 1),
    RAILS("rails", 2),
    WORKING("working", 3),
    DAMAGED("damaged", 4);

    private final String name;
    private final int index;
    private static final EnumTrackState[] VALUES;
    private static final Map<String, EnumTrackState> NAME_LOOKUP;

    private EnumTrackState(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public static EnumTrackState byIndex(int index) {
        return VALUES[index % EnumTrackState.values().length];
    }

    @Nullable
    public static EnumTrackState byName(@Nullable String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    public static EnumTrackState byNameSafely(@Nullable String name) {
        return name == null ? MARKUP : NAME_LOOKUP.get(name.toLowerCase());
    }

    static {
        VALUES = new EnumTrackState[5];
        NAME_LOOKUP = Maps.newHashMap();
        EnumTrackState[] enumTrackStateArray = EnumTrackState.values();
        int n = enumTrackStateArray.length;
        for (int i = 0; i < n; ++i) {
            EnumTrackState trackState;
            EnumTrackState.VALUES[trackState.index] = trackState = enumTrackStateArray[i];
            NAME_LOOKUP.put(trackState.getName().toLowerCase(), trackState);
        }
    }
}

