/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.block.BlockTrackGag;

public class ItemButtonKillTrack
extends Item {
    public ItemButtonKillTrack() {
        this.field_77777_bU = 1;
        this.setRegistryName("buttonKillTrack");
        this.func_77637_a(RoW.TAB_ROW);
        this.func_77655_b("row.buttonKillTrack");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.GRAY + "Removes nearby tracks and leftovers");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_71075_bZ.field_75098_d) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        int count = 0;
        int i = (int)player.field_70165_t;
        int j = (int)player.field_70163_u;
        int k = (int)player.field_70161_v;
        for (int x = i - Config.getTrackRemovalRange(); x < i + Config.getTrackRemovalRange(); ++x) {
            for (int y = j - Config.getTrackRemovalRange(); y < j + Config.getTrackRemovalRange(); ++y) {
                for (int z = k - Config.getTrackRemovalRange(); z < k + Config.getTrackRemovalRange(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof BlockTrackBase) && !(block instanceof BlockTrackGag)) continue;
                    if (RoWTracks.getTrackManager(world).getPieceID(pos) != -1) {
                        RoWTracks.getTrackManager(world).removePiece(world, pos);
                    } else {
                        world.func_175698_g(pos);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString("Trying to remove track at " + x + ", " + y + ", " + z), false);
                    ++count;
                }
            }
        }
        if (count > 0) {
            player.func_146105_b((ITextComponent)new TextComponentString("----------"), false);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

