/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.RoW;
import net.railsofwar.row.common.Structure;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.enumeration.EnumTrackState;
import net.railsofwar.row.track.tileentity.TileTrackBase;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.util.UtilTrackStructure;
import org.apache.commons.lang3.tuple.Triple;

public class ItemTrack
extends Item
implements Structure {
    private final EnumTrackShape shape;
    private final int scalarA;
    private final int scalarB;
    private final boolean canBeMirrored;
    private final BlockTrackBase track;
    private final EnumRailway railway;

    public ItemTrack(BlockTrackBase block, EnumTrackShape shape, int scalarA, int scalarB, boolean canBeMirrored, EnumRailway railway) {
        this.track = block;
        this.shape = shape;
        this.scalarA = scalarA;
        this.scalarB = scalarB;
        this.canBeMirrored = canBeMirrored;
        this.railway = railway;
        this.func_77637_a(RoW.TAB_ROW);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.setRegistryName("itemTrack" + shape.getName().substring(0, 1).toUpperCase() + shape.getName().substring(1) + scalarA);
        this.func_77655_b("row.itemTrack" + shape.getName().substring(0, 1).toUpperCase() + shape.getName().substring(1));
    }

    public ItemTrack(BlockTrackBase block, EnumTrackShape shape, int scalarA, int scalarB, EnumRailway railway) {
        this(block, shape, scalarA, scalarB, false, railway);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.shape == EnumTrackShape.TURNTABLE) {
            list.add(TextFormatting.GRAY.toString() + "Right-click to rotate the turntable once placed");
            list.add(TextFormatting.GRAY.toString() + "Shift + right-click to rotate in opposite direction");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && side == EnumFacing.UP) {
            BlockPos trackPos = pos.func_177984_a();
            EnumDirectionSWNE dir = EnumDirectionSWNE.fromAngle(player.field_70177_z - 45.0f * (this.shape == EnumTrackShape.DIAGONAL ? 1.0f : 0.0f));
            boolean mirrored = false;
            if (this.canBeMirrored) {
                float azimuth = EnumDirectionSWNE.fromAngle(player.field_70177_z).getAzimuth();
                boolean bl = mirrored = MathHelper.func_76142_g((float)(player.field_70177_z - azimuth)) < 0.0f;
            }
            if (!this.checkStructure(world, trackPos, dir, mirrored)) {
                player.func_146105_b((ITextComponent)new TextComponentString("Can't place this track here"), false);
                return EnumActionResult.FAIL;
            }
            this.placeStructure(world, trackPos, dir, mirrored);
            TileTrackBase tile = (TileTrackBase)world.func_175625_s(trackPos);
            if (tile != null) {
                if (tile instanceof TileTrackSWNE) {
                    ((TileTrackSWNE)tile).direction = dir;
                }
                tile.mirrored = mirrored;
                tile.shape = this.shape;
                tile.scalarA = this.scalarA;
                tile.scalarB = this.scalarB;
                tile.railway = this.railway;
                tile.trackState = EnumTrackState.WORKING;
                world.func_184138_a(pos, world.func_180495_p(trackPos), world.func_180495_p(trackPos), 3);
                RoWTracks.getTrackManager(world).func_76185_a();
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void placeStructure(World world, BlockPos anchor, EnumDirectionSWNE dir, boolean mirrored) {
        for (Triple<BlockPos, Block, Boolean> triple : this.getStructure(mirrored)) {
            BlockPos pos = RotationHelper.rotateByDir((BlockPos)triple.getLeft(), anchor, dir);
            IBlockState state = ((Block)triple.getMiddle()).func_176223_P();
            world.func_180501_a(pos, state, 3);
            ((Block)triple.getMiddle()).func_180633_a(world, pos, state, null, null);
            RoWTracks.getTrackManager(world).addPart(world, anchor, pos);
        }
    }

    @Override
    public ArrayList<Triple<BlockPos, Block, Boolean>> getStructure(boolean mirrored) {
        return UtilTrackStructure.getStructure(this.shape, this.railway, this.scalarA, 1, mirrored);
    }

    public String getName() {
        return "itemTrack" + this.shape.getName().substring(0, 1).toUpperCase() + this.shape.getName().substring(1) + this.scalarA;
    }

    public EnumTrackShape getShape() {
        return this.shape;
    }

    public BlockTrackBase getTrack() {
        return this.track;
    }

    public EnumRailway getRailway() {
        return this.railway;
    }
}

