/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.capability.CapabilityToolTrack;
import net.railsofwar.row.track.capability.ToolTrackProvider;

public class PacketCapabilityTrackTool
implements IMessage {
    int id;
    boolean reset;
    boolean invert;
    int scalarB;

    public PacketCapabilityTrackTool() {
    }

    public PacketCapabilityTrackTool(int id) {
        this.id = id;
        this.reset = true;
    }

    public PacketCapabilityTrackTool(int id, boolean invert, int scalarB) {
        this.id = id;
        this.reset = false;
        this.invert = invert;
        this.scalarB = scalarB;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.reset);
        buf.writeBoolean(this.invert);
        buf.writeInt(this.scalarB);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.reset = buf.readBoolean();
        this.invert = buf.readBoolean();
        this.scalarB = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketCapabilityTrackTool, IMessage> {
        public IMessage onMessage(PacketCapabilityTrackTool message, MessageContext ctx) {
            EntityPlayer player = ctx.side.isServer() ? Handler.getPlayerServer(message.id, ctx) : Handler.getPlayerClient(message.id);
            Handler.handle(player, message, ctx);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public static EntityPlayer getPlayerClient(int id) {
            Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(id);
            if (e instanceof EntityPlayer) {
                return (EntityPlayer)e;
            }
            return null;
        }

        public static EntityPlayer getPlayerServer(int id, MessageContext ctx) {
            Entity e = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(id);
            if (e instanceof EntityPlayer) {
                return (EntityPlayer)e;
            }
            return null;
        }

        public static void handle(EntityPlayer player, PacketCapabilityTrackTool message, MessageContext ctx) {
            if (player != null && player.hasCapability(ToolTrackProvider.CAP_TOOL_TRACK, null)) {
                CapabilityToolTrack.IToolTrackCapability cap = (CapabilityToolTrack.IToolTrackCapability)player.getCapability(ToolTrackProvider.CAP_TOOL_TRACK, null);
                if (message.reset) {
                    cap.setDone(false);
                    cap.setInvert(false);
                    cap.setScalarB(0);
                } else {
                    cap.setInvert(message.invert);
                    cap.setScalarB(message.scalarB);
                }
            }
            if (ctx.side.isServer()) {
                RoWTracks.network.sendToAll((IMessage)message);
            }
        }
    }
}

