/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.railsofwar.row.RoW;
import net.railsofwar.row.track.RoWTracks;

public class PacketSendTrackData
implements IMessage {
    private boolean addition;
    private int trackX;
    private int trackY;
    private int trackZ;
    private int partX;
    private int partY;
    private int partZ;

    public PacketSendTrackData() {
    }

    public PacketSendTrackData(BlockPos originPos, BlockPos partPos) {
        this.addition = true;
        this.trackX = originPos.func_177958_n();
        this.trackY = originPos.func_177956_o();
        this.trackZ = originPos.func_177952_p();
        this.partX = partPos.func_177958_n();
        this.partY = partPos.func_177956_o();
        this.partZ = partPos.func_177952_p();
    }

    public PacketSendTrackData(int[] originPos, int[] partPos) {
        this.addition = true;
        this.trackX = originPos[0];
        this.trackY = originPos[1];
        this.trackZ = originPos[2];
        this.partX = partPos[0];
        this.partY = partPos[1];
        this.partZ = partPos[2];
    }

    public PacketSendTrackData(BlockPos originPos) {
        this.addition = false;
        this.trackX = originPos.func_177958_n();
        this.trackY = originPos.func_177956_o();
        this.trackZ = originPos.func_177952_p();
    }

    public PacketSendTrackData(int[] originPos) {
        this.addition = false;
        this.trackX = originPos[0];
        this.trackY = originPos[1];
        this.trackZ = originPos[2];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.addition);
        buf.writeInt(this.trackX);
        buf.writeInt(this.trackY);
        buf.writeInt(this.trackZ);
        if (this.addition) {
            buf.writeInt(this.partX);
            buf.writeInt(this.partY);
            buf.writeInt(this.partZ);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.addition = buf.readBoolean();
        this.trackX = buf.readInt();
        this.trackY = buf.readInt();
        this.trackZ = buf.readInt();
        if (this.addition) {
            this.partX = buf.readInt();
            this.partY = buf.readInt();
            this.partZ = buf.readInt();
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSendTrackData, IMessage> {
        public IMessage onMessage(PacketSendTrackData message, MessageContext ctx) {
            if (ctx.side.isClient() && RoW.proxy.getWorldFromPacketCtx(ctx) != null) {
                if (message.addition) {
                    RoWTracks.getTrackManager(RoW.proxy.getWorldFromPacketCtx(ctx)).addPart(RoW.proxy.getWorldFromPacketCtx(ctx), new BlockPos(message.trackX, message.trackY, message.trackZ), new BlockPos(message.partX, message.partY, message.partZ));
                } else {
                    RoWTracks.getTrackManager(RoW.proxy.getWorldFromPacketCtx(ctx)).removePiece(RoW.proxy.getWorldFromPacketCtx(ctx), new BlockPos(message.trackX, message.trackY, message.trackZ));
                }
            }
            return null;
        }
    }
}

