/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.UtilMath;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;

public class TileTurntable
extends TileTrackSWNE
implements ITickable {
    public float azimuth = 0.0f;
    public float azimuthPrev = 0.0f;
    public EnumDirectionSWNE target = EnumDirectionSWNE.SOUTH;
    public byte cooldown;

    public void step(boolean clockwise) {
        if (this.cooldown == 0) {
            this.target = clockwise ? this.target.getCW() : this.target.getCCW();
            this.cooldown = this.getCooldownMax();
        }
    }

    public byte getCooldownMax() {
        return (byte)(2 * this.getLockSteps() + this.getTurnSteps());
    }

    public byte getLockSteps() {
        return 10;
    }

    public byte getTurnSteps() {
        return 80;
    }

    public float getAzimuthIncrement() {
        return 90.0f / (float)this.getTurnSteps();
    }

    public float getLockAngle(float partial) {
        if (this.cooldown == 0) {
            return 0.0f;
        }
        if (this.cooldown > this.getLockSteps() + this.getTurnSteps()) {
            float i = UtilMath.inp(this.cooldown, this.cooldown + 1, partial);
            return this.getLockAngleMax() * (1.0f - (i - (float)this.getLockSteps() - (float)this.getTurnSteps()) / (float)this.getLockSteps());
        }
        if (this.cooldown > this.getLockSteps()) {
            return this.getLockAngleMax();
        }
        if (this.cooldown > 0) {
            float i = UtilMath.inp(this.cooldown - 1, this.cooldown, partial);
            return this.getLockAngleMax() * i / (float)this.getLockSteps();
        }
        return 0.0f;
    }

    public float getLockAngleMax() {
        return 180.0f;
    }

    @Override
    public void func_73660_a() {
        if (this.cooldown >= 1) {
            this.cooldown = (byte)(this.cooldown - 1);
            this.azimuthPrev = this.azimuth;
            float azTarget = this.target.getAzimuth();
            if (this.cooldown > this.getLockSteps() && this.cooldown <= this.getLockSteps() + this.getTurnSteps()) {
                float d = MathHelper.func_76142_g((float)(azTarget - this.azimuth));
                this.azimuth = d > 0.0f ? (this.azimuth += this.getAzimuthIncrement()) : (this.azimuth += -this.getAzimuthIncrement());
            }
        } else {
            this.cooldown = 0;
            this.azimuthPrev = this.azimuth = this.target.getAzimuth();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74774_a("target", (byte)this.target.ordinal());
        tag.func_74774_a("cooldown", this.cooldown);
        tag.func_74776_a("azimuth", this.azimuth);
        tag.func_74776_a("azimuthPrev", this.azimuthPrev);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.target = EnumDirectionSWNE.getFront(tag.func_74771_c("target"));
        this.cooldown = tag.func_74771_c("cooldown");
        this.azimuth = tag.func_74760_g("azimuth");
        this.azimuthPrev = tag.func_74760_g("azimuthPrev");
        super.func_145839_a(tag);
    }
}

