/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.util;

import com.sun.javafx.geom.Vec3f;

public class PieceProperty {
    private final float pX;
    private final float pY;
    private final float pZ;
    private final float sX;
    private final float sY;
    private final float sZ;
    private final float azimuth;
    private final float pith;
    private final float roll;

    public PieceProperty(float pX, float pY, float pZ, float sX, float sY, float sZ, float azimuth, float pitch, float roll) {
        this.pX = pX;
        this.pY = pY;
        this.pZ = pZ;
        this.sX = sX;
        this.sY = sY;
        this.sZ = sZ;
        this.azimuth = azimuth;
        this.pith = pitch;
        this.roll = roll;
    }

    public static PieceProperty byPos(float pX, float pY, float pZ) {
        return new PieceProperty(pX, pY, pZ, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public static PieceProperty byPosAndScales(float pX, float pY, float pZ, float sX, float sY, float sZ) {
        return new PieceProperty(pX, pY, pZ, sX, sY, sZ, 0.0f, 0.0f, 0.0f);
    }

    public static PieceProperty byPosAndAngles(float pX, float pY, float pZ, float azimuth, float altitude, float roll) {
        return new PieceProperty(pX, pY, pZ, 1.0f, 1.0f, 1.0f, azimuth, altitude, roll);
    }

    public Vec3f getPos() {
        return new Vec3f(this.pX, this.pY, this.pZ);
    }

    public Vec3f getNormal() {
        return new Vec3f((float)(Math.sin(-Math.toRadians(this.azimuth)) * Math.cos(Math.toRadians(this.pith))), (float)Math.sin(Math.toRadians(this.pith)), (float)(Math.cos(-Math.toRadians(this.azimuth)) * Math.cos(Math.toRadians(this.pith))));
    }

    public float getPX() {
        return this.pX;
    }

    public float getPY() {
        return this.pY;
    }

    public float getPZ() {
        return this.pZ;
    }

    public float getSX() {
        return this.sX;
    }

    public float getSY() {
        return this.sY;
    }

    public float getSZ() {
        return this.sZ;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public float getPith() {
        return this.pith;
    }

    public float getRoll() {
        return this.roll;
    }
}

