/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.util;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.enumeration.EnumTrackState;
import net.railsofwar.row.track.tileentity.TileTrackSWNE;
import net.railsofwar.row.track.util.UtilTrackStructure;
import org.apache.commons.lang3.tuple.Triple;

public class TrackDescriptor {
    private final BlockPos position;
    private final EnumRailway railway;
    private final EnumTrackShape shape;
    private final int scalarA;
    private final int scalarB;
    private final boolean mirrored;
    private final EnumTrackState trackState;
    private final EnumDirectionSWNE direction;

    public TrackDescriptor(BlockPos position, EnumRailway railway, EnumTrackShape shape, int scalarA, int scalarB, boolean mirrored, EnumTrackState trackState, EnumDirectionSWNE direction) {
        this.position = position;
        this.railway = railway;
        this.shape = shape;
        this.scalarA = scalarA;
        this.scalarB = scalarB;
        this.mirrored = mirrored;
        this.trackState = trackState;
        this.direction = direction;
    }

    public void place(World world) {
        ArrayList<Triple<BlockPos, Block, Boolean>> structure = UtilTrackStructure.getStructure(this.shape, this.railway, this.scalarA, this.scalarB, this.mirrored);
        if (world.field_72995_K) {
            UtilTrackStructure.checkStructureAndMark(structure, world, this.position, this.direction);
            return;
        }
        if (!UtilTrackStructure.checkStructure(structure, world, this.position, this.direction)) {
            return;
        }
        for (Triple<BlockPos, Block, Boolean> triple : structure) {
            BlockPos pos = RotationHelper.rotateByDir((BlockPos)triple.getLeft(), this.position, this.direction);
            IBlockState state = ((Block)triple.getMiddle()).func_176223_P();
            world.func_180501_a(pos, state, 3);
            ((Block)triple.getMiddle()).func_180633_a(world, pos, state, null, null);
            RoWTracks.getTrackManager(world).addPart(world, this.position, pos);
        }
        TileTrackSWNE tile = (TileTrackSWNE)world.func_175625_s(this.position);
        if (tile != null) {
            tile.direction = this.direction;
            tile.mirrored = this.mirrored;
            tile.shape = this.shape;
            tile.scalarA = this.scalarA;
            tile.scalarB = this.scalarB;
            tile.railway = this.railway;
            tile.trackState = this.trackState;
            world.func_184138_a(this.position, world.func_180495_p(this.position), world.func_180495_p(this.position), 3);
            RoWTracks.getTrackManager(world).func_76185_a();
        }
    }
}

