/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.util.PieceProperty;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.apache.commons.lang3.tuple.Pair;

public class TrackGeometry {
    private final EnumRailway railway;
    private final EnumTrackShape shape;
    private final int scalarA;
    private final int scalarB;
    private final boolean mirrored;
    private final List<Pair<PieceProperty, Integer>> sleepers;
    private final Pair<List<PieceProperty>, List<PieceProperty>> rails;
    private final float spacer;
    private final List<PieceProperty> spikes;

    public TrackGeometry(EnumRailway railway, EnumTrackShape shape, int scalarA, int scalarB, boolean mirrored, BlockPos pos) {
        this(railway, shape, scalarA, scalarB, mirrored, UtilTrackGeometry.getSeed(pos));
    }

    public TrackGeometry(EnumRailway railway, EnumTrackShape shape, int scalarA, int scalarB, boolean mirrored, int seed) {
        this.railway = railway;
        this.shape = shape;
        this.scalarA = scalarA;
        this.scalarB = scalarB;
        this.mirrored = mirrored;
        this.sleepers = UtilTrackGeometry.getSleepers(railway, shape, scalarA, scalarB, mirrored, UtilTrackGeometry.getGenerator(seed));
        this.rails = UtilTrackGeometry.getRails(railway, shape, scalarA, scalarB, mirrored);
        this.spacer = shape == EnumTrackShape.CIRCULAR || shape == EnumTrackShape.SWITCH_CIRCULAR || shape == EnumTrackShape.SWITCH_WYE ? UtilTrackGeometry.getCircularGap((float)scalarA + 0.5f, EnumDiagonal.byOrdinal(scalarB).getRadian()) : 0.0f;
        this.spikes = new ArrayList<PieceProperty>();
    }

    public List<Pair<PieceProperty, Integer>> getSleepers() {
        return this.sleepers;
    }

    public Pair<List<PieceProperty>, List<PieceProperty>> getRails() {
        return this.rails;
    }

    public float getSpacer() {
        return this.spacer;
    }

    public EnumRailway getRailway() {
        return this.railway;
    }

    public EnumTrackShape getShape() {
        return this.shape;
    }

    public int getScalarA() {
        return this.scalarA;
    }

    public int getScalarB() {
        return this.scalarB;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public List<PieceProperty> getSpikes() {
        return this.spikes;
    }
}

