/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.util;

import com.sun.javafx.geom.Vec3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.railsofwar.row.common.Config;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.block.BlockTrackBase;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.util.PieceProperty;
import org.apache.commons.lang3.tuple.Pair;

public class UtilTrackGeometry {
    public static final float ANGLE45 = (float)Math.toRadians(45.0);

    public static List<Pair<PieceProperty, Integer>> getSleepers(EnumRailway railway, EnumTrackShape shape, int scalarA, int scalarB, boolean mirrored, Random generator) {
        switch (shape) {
            case STRAIGHT: {
                return UtilTrackGeometry.getSleepersStraight(railway, scalarA, generator);
            }
            case DIAGONAL: {
                return UtilTrackGeometry.getSleepersDiagonal(railway, scalarA, generator);
            }
            case CIRCULAR: {
                return UtilTrackGeometry.getSleepersCircular(railway, scalarA, scalarB, mirrored, generator);
            }
            case SLOPE_STRAIGHT: {
                return UtilTrackGeometry.getSleepersSlopeStraight(railway, scalarA, scalarB, generator);
            }
            case SWITCH_CIRCULAR: {
                return UtilTrackGeometry.getSleepersSwitchCircular(railway, scalarA, scalarB, mirrored, generator);
            }
            case SWITCH_WYE: {
                return UtilTrackGeometry.getSleepersSwitchWye(railway, scalarA, scalarB, generator);
            }
        }
        return Collections.emptyList();
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRails(EnumRailway railway, EnumTrackShape shape, int scalarA, int scalarB, boolean mirrored) {
        switch (shape) {
            case STRAIGHT: {
                return UtilTrackGeometry.getRailsStraight(railway, scalarA);
            }
            case DIAGONAL: {
                return UtilTrackGeometry.getRailsDiagonal(railway, scalarA);
            }
            case CIRCULAR: {
                return UtilTrackGeometry.getRailsCircular(railway, scalarA, scalarB, mirrored);
            }
            case SLOPE_STRAIGHT: {
                return UtilTrackGeometry.getRailsSlopeStraight(railway, scalarA, scalarB, shape);
            }
            case SWITCH_CIRCULAR: {
                return UtilTrackGeometry.getRailsSwitchCircular(railway, scalarA, scalarB, mirrored);
            }
            case SWITCH_WYE: {
                return UtilTrackGeometry.getRailsSwitchWye(railway, scalarA, scalarB);
            }
        }
        return Pair.of(Collections.emptyList(), Collections.emptyList());
    }

    public static List<PieceProperty> generateSpikes(EnumRailway railway, List<Pair<PieceProperty, Integer>> sleepers, Pair<List<PieceProperty>, List<PieceProperty>> rails) {
        ArrayList<PieceProperty> result = new ArrayList<PieceProperty>();
        if (!Config.generateSpikes) {
            return result;
        }
        ArrayList railsUnited = new ArrayList();
        railsUnited.addAll((Collection)rails.getLeft());
        railsUnited.addAll((Collection)rails.getRight());
        for (Pair<PieceProperty, Integer> pair : sleepers) {
            PieceProperty sleeper = (PieceProperty)pair.getLeft();
            Vec3f u = sleeper.getNormal();
            u.mul(0.1875f);
            u.add(sleeper.getPos());
        }
        for (PieceProperty rail : railsUnited) {
            for (Pair<PieceProperty, Integer> pair : sleepers) {
                PieceProperty sleeper = (PieceProperty)pair.getLeft();
                float length = (float)((Integer)pair.getRight()).intValue() / 16.0f;
                Vec3f base = sleeper.getPos();
                Vec3f h = new Vec3f();
                Vec3f k = new Vec3f();
                Vec3f nom = new Vec3f();
                Vec3f denom = new Vec3f();
                base.sub(rail.getPos());
                Vec3f e = rail.getNormal();
                Vec3f f = sleeper.getNormal();
                h.cross(f, base);
                k.cross(f, e);
                if (!(h.length() > 0.0f) || !(k.length() > 0.0f)) continue;
                Vec3f pos = rail.getPos();
                nom.cross(f, base);
                denom.cross(f, e);
                e.mul(nom.length() / denom.length());
                if (!h.equals((Object)k)) {
                    e.mul(-1.0f);
                }
                pos.add(e);
                float distRSsq = (rail.getPX() - pos.x) * (rail.getPX() - pos.x) + (rail.getPY() - pos.y) * (rail.getPY() - pos.y) + (rail.getPZ() - pos.z) * (rail.getPZ() - pos.z);
                float distSSsq = (sleeper.getPX() - pos.x) * (sleeper.getPX() - pos.x) + (sleeper.getPY() - pos.y) * (sleeper.getPY() - pos.y) + (sleeper.getPZ() - pos.z) * (sleeper.getPZ() - pos.z);
                float limRS = 0.0625f;
                float limSS = length * length / 4.0f;
                if (!(distRSsq < limRS) || !(distSSsq < limSS)) continue;
                result.add(PieceProperty.byPosAndAngles(pos.x, pos.y, pos.z, rail.getAzimuth(), rail.getPith(), 0.0f));
            }
        }
        return result;
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersStraight(EnumRailway railway, int length, Random generator) {
        return UtilTrackGeometry.addSleepersFromTo(new ArrayList<Pair<PieceProperty, Integer>>(), railway, 0.0f, length, generator);
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsStraight(EnumRailway railway, float length) {
        float railLength = 0.5f;
        int rails = Math.round(length / railLength);
        float scale = 1.02f * length / ((float)rails * railLength);
        float g = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
        ArrayList<PieceProperty> left = new ArrayList<PieceProperty>();
        ArrayList<PieceProperty> right = new ArrayList<PieceProperty>();
        for (int i = 0; i <= rails; ++i) {
            float axial = -0.5f + (float)i * railLength;
            left.add(new PieceProperty(g, 0.0f, axial, 1.0f, 1.0f, scale, 0.0f, 0.0f, 0.0f));
            right.add(new PieceProperty(-g, 0.0f, axial, 1.0f, 1.0f, scale, 0.0f, 0.0f, 0.0f));
        }
        return Pair.of(left, right);
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersDiagonal(EnumRailway railway, int scalar, Random generator) {
        float length = (float)scalar * 1.414213f;
        int sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float gap = length / (float)sleepers;
        ArrayList<Pair<PieceProperty, Integer>> result = new ArrayList<Pair<PieceProperty, Integer>>();
        for (int i = 0; i < sleepers; ++i) {
            float transverse = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float axial = -0.707106f + gap * ((float)i + 0.5f) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float angular = -45.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            float m = (float)Math.cos(ANGLE45);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(-(axial + transverse) * m, 0.0f, (axial - transverse) * m, angular, 0.0f, 0.0f), (Object)24));
        }
        return result;
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsDiagonal(EnumRailway railway, int scalar) {
        float length = (float)scalar * 1.414213f;
        float railLength = 0.5f;
        int rails = Math.round(length / railLength);
        float scale = 1.02f * length / ((float)rails * railLength);
        float transverse = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
        float m = (float)Math.cos(ANGLE45);
        ArrayList<PieceProperty> left = new ArrayList<PieceProperty>();
        ArrayList<PieceProperty> right = new ArrayList<PieceProperty>();
        for (int i = 0; i <= rails; ++i) {
            float axial = -0.707106f + (float)i * railLength * scale;
            left.add(new PieceProperty(-(axial - transverse) * m, 0.0f, (axial + transverse) * m, 1.0f, 1.0f, scale, 45.0f, 0.0f, 0.0f));
            right.add(new PieceProperty(-(axial + transverse) * m, 0.0f, (axial - transverse) * m, 1.0f, 1.0f, scale, 45.0f, 0.0f, 0.0f));
        }
        return Pair.of(left, right);
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersCircular(EnumRailway railway, float s, int base, boolean mirrored, Random generator) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        Pair<Float, Float> params = UtilTrackGeometry.getCircularParams(s + 0.5f, radian);
        float length = radian * ((Float)params.getLeft()).floatValue();
        int sleepers = (int)Math.ceil(length * (float)railway.getDensity() / 1000.0f);
        float ang = 0.999999f * radian / (float)sleepers;
        ArrayList<Pair<PieceProperty, Integer>> result = new ArrayList<Pair<PieceProperty, Integer>>();
        for (int i = 0; i < sleepers; ++i) {
            float sx = (float)((double)((Float)params.getLeft()).floatValue() * (Math.cos(((float)i + 0.5f) * ang) - 1.0) * (double)(mirrored ? -1.0f : 1.0f)) + railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + ((Float)params.getRight()).floatValue() + (float)((double)((Float)params.getLeft()).floatValue() * Math.sin(((float)i + 0.5f) * ang)) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float sa = (float)Math.toDegrees(((float)i + 0.5f) * ang) * (mirrored ? -1.0f : 1.0f) + 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)24));
        }
        length = ((Float)params.getRight()).floatValue();
        sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float gap = length / (float)sleepers;
        for (int i = 0; i < sleepers; ++i) {
            float sx = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + gap * ((float)i + 0.5f) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float sa = 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)24));
        }
        return result;
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsCircular(EnumRailway railway, float s, int base, boolean mirrored) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        return Pair.of(UtilTrackGeometry.addArcRailLeft(new ArrayList<PieceProperty>(), railway, s, radian, mirrored), UtilTrackGeometry.addArcRailRight(new ArrayList<PieceProperty>(), railway, s, radian, mirrored));
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersSlopeStraight(EnumRailway railway, int length, float raise, Random generator) {
        ArrayList<Pair<PieceProperty, Integer>> result = new ArrayList<Pair<PieceProperty, Integer>>();
        float span = 0.5f * (float)length;
        float radius = (span * span + (raise *= 0.5f) * raise) / (2.0f * raise);
        float chord = (float)Math.hypot(span, raise);
        float angle = (float)(2.0 * Math.asin(chord / 2.0f / radius));
        float arc = angle * radius;
        int sleepers = Math.round(arc * (float)railway.getDensity() / 1000.0f);
        float ang = angle / (float)sleepers;
        float radiusUp = radius + 0.3125f;
        float radiusDown = radius - 0.3125f;
        for (int i = 1; i <= sleepers; ++i) {
            float a = (float)((double)(ang * (float)i) + Math.toRadians(0.5f * railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f)));
            float sx = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sy = (float)((double)radiusUp * (1.0 - Math.cos(a)));
            float sz = (float)(-0.5 + (double)radiusUp * Math.sin(a));
            float sa = 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, sy, sz, sa, 0.0f, (float)Math.toDegrees(a)), (Object)24));
            if (i >= sleepers) continue;
            sx = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            sy = (float)((double)radiusDown * (1.0 - Math.cos(a)));
            sz = (float)(-0.5 + (double)radiusDown * Math.sin(a));
            sa = 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 2.0f * raise - sy, (float)length - sz - 1.0f, sa, 0.0f, (float)Math.toDegrees(a)), (Object)24));
        }
        return result;
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsSlopeStraight(EnumRailway railway, int length, int raise, EnumTrackShape shape) {
        if (shape == EnumTrackShape.SLOPE_STRAIGHT) {
            Pair<List<PieceProperty>, List<PieceProperty>> before = UtilTrackGeometry.getRailsSlopeStraightUpward(railway, (float)length / 2.0f, 0.5f * (float)raise, 0.0f);
            Pair<List<PieceProperty>, List<PieceProperty>> after = UtilTrackGeometry.getRailsSlopeStraightDownward(railway, (float)length / 2.0f, 0.5f * (float)raise, (float)length / 2.0f);
            ((List)before.getLeft()).remove(((List)before.getLeft()).size() - 1);
            ((List)before.getRight()).remove(((List)before.getRight()).size() - 1);
            ((List)before.getLeft()).addAll((Collection)after.getLeft());
            ((List)before.getRight()).addAll((Collection)after.getRight());
            return before;
        }
        return Pair.of(Collections.emptyList(), Collections.emptyList());
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsSlopeStraightUpward(EnumRailway railway, float length, float raise, float pre) {
        float r = UtilTrackGeometry.getSlopeRadius(length, raise);
        float angle = (float)(2.0 * Math.atan2(raise, length));
        int rails = Math.round(angle * r / 0.5f);
        float g = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
        float a = angle / (float)rails;
        float scale = 1.09f * angle * r / ((float)rails * 0.5f);
        ArrayList<PieceProperty> left = new ArrayList<PieceProperty>();
        ArrayList<PieceProperty> right = new ArrayList<PieceProperty>();
        r += 0.3125f;
        for (int i = 0; i <= rails; ++i) {
            left.add(new PieceProperty(g, (float)((double)r * (1.0 - Math.cos(a * (float)i))), (float)((double)(pre - 0.5f) + (double)r * Math.sin(a * (float)i)), 1.0f, 1.0f, scale, 0.0f, -((float)Math.toDegrees(a * ((float)i + 0.5f))), 0.0f));
            right.add(new PieceProperty(-g, (float)((double)r * (1.0 - Math.cos(a * (float)i))), (float)((double)(pre - 0.5f) + (double)r * Math.sin(a * (float)i)), 1.0f, 1.0f, scale, 0.0f, -((float)Math.toDegrees(a * ((float)i + 0.5f))), 0.0f));
        }
        return Pair.of(left, right);
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsSlopeStraightDownward(EnumRailway railway, float length, float raise, float pre) {
        float r = UtilTrackGeometry.getSlopeRadius(length, raise);
        float angle = (float)(2.0 * Math.asin(Math.hypot(length, raise) / 2.0 / (double)r));
        int rails = Math.round(angle * r / 0.5f);
        float g = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
        float a = angle / (float)rails;
        float scale = 1.09f * angle * r / ((float)rails * 0.5f);
        ArrayList<PieceProperty> left = new ArrayList<PieceProperty>();
        ArrayList<PieceProperty> right = new ArrayList<PieceProperty>();
        r -= 0.3125f;
        for (int i = rails; i >= 0; --i) {
            left.add(new PieceProperty(g, (float)((double)(2.0f * raise) + (double)r * (Math.cos(a * (float)i) - 1.0)), (float)((double)(pre + length - 0.5f) - (double)r * Math.sin(a * (float)i)), 1.0f, 1.0f, scale, 0.0f, -((float)Math.toDegrees(a * ((float)i - 0.5f))), 0.0f));
            right.add(new PieceProperty(-g, (float)((double)(2.0f * raise) + (double)r * (Math.cos(a * (float)i) - 1.0)), (float)((double)(pre + length - 0.5f) - (double)r * Math.sin(a * (float)i)), 1.0f, 1.0f, scale, 0.0f, -((float)Math.toDegrees(a * ((float)i - 0.5f))), 0.0f));
        }
        return Pair.of(left, right);
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersSwitchCircular(EnumRailway railway, float s, int base, boolean mirrored, Random generator) {
        ArrayList<Pair<PieceProperty, Integer>> result = new ArrayList<Pair<PieceProperty, Integer>>();
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float pointer = UtilTrackGeometry.getSwitchPointerSleeper(railway, s + 0.5f, radian);
        result.add(Pair.of((Object)PieceProperty.byPosAndAngles(0.0f, 0.0f, -0.5f + pointer, 90.0f, 0.0f, 0.0f), (Object)24));
        UtilTrackGeometry.addSleepersFromTo(result, railway, 0.0f, pointer - 0.25f, generator);
        float x = UtilTrackGeometry.getSwitchCrossSleeperHeight(railway, s + 0.5f, radian);
        float H = UtilTrackGeometry.getSwitchCircularHeight(railway, s + 0.5f, radian);
        UtilTrackGeometry.addSleepersFromTo(result, railway, x, H, generator);
        float r = UtilTrackGeometry.getCircularRadius(s + 0.5f, radian);
        float circularGap = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        float angx = UtilTrackGeometry.getSwitchCrossSleeperAngle(railway, s + 0.5f, radian);
        UtilTrackGeometry.addSleepersFromAngle(result, railway, s, base, angx, mirrored, generator);
        float angy = UtilTrackGeometry.getSwitchCrossSleeperAngle2(railway, s + 0.5f, radian);
        float length = (angx - angy) * r;
        int sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float ang = 0.99f * (angx - angy) / (float)sleepers;
        for (int i = 0; i < sleepers; ++i) {
            float beta = ((float)i + 0.5f) * ang + angy;
            float c = (float)((double)r * (1.0 - Math.cos(beta)));
            int l = Math.round(c * 8.0f) * 2 + 24;
            float sx = (float)(((double)r * (Math.cos(beta) - 1.0) + (double)(c / 2.0f)) * (double)(mirrored ? -1.0f : 1.0f)) + railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + circularGap + (float)((double)r * Math.sin(beta)) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float sa = (float)Math.toDegrees(((float)i + 0.5f) * ang / 2.0f + angy) * (mirrored ? -1.0f : 1.0f) + 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)l));
        }
        return result;
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsSwitchCircular(EnumRailway railway, float s, int base, boolean mirrored) {
        ArrayList<PieceProperty> right = new ArrayList<PieceProperty>();
        ArrayList<PieceProperty> left = new ArrayList<PieceProperty>();
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float railLength = 0.5f;
        float h = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        if (!mirrored) {
            int rails = Math.round((float)UtilTrackGeometry.getSwitchCircularHeight(railway, s + 0.5f, radian) / railLength);
            float transverse = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
            for (int i = 0; i < rails; ++i) {
                left.add(PieceProperty.byPosAndAngles(transverse, 0.0f, -0.5f + (float)i * railLength, 0.0f, 0.0f, 0.0f));
            }
            float H = UtilTrackGeometry.getSwitchCircularHeight(railway, s + 0.5f, radian);
            float x = UtilTrackGeometry.getSwitchCrossRailHeight(railway, s + 0.5f, radian) + h;
            rails = Math.round((H - x) / railLength);
            float sc = (H - x) / ((float)rails * railLength);
            for (int i = 0; i < rails; ++i) {
                right.add(new PieceProperty(-transverse, 0.0f, x - 0.5f + (float)i * railLength * sc, 1.0f, 1.0f, sc, 0.0f, 0.0f, 0.0f));
            }
            UtilTrackGeometry.addArcRailRight(right, railway, s, radian, false);
            UtilTrackGeometry.addArcRailLeftFromAngle(left, railway, s, base, UtilTrackGeometry.getSwitchCrossRailAngle(railway, s + 0.5f, radian));
        } else {
            int rails = Math.round((float)UtilTrackGeometry.getSwitchCircularHeight(railway, s + 0.5f, radian) / railLength);
            float transverse = railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth() / 2.0f;
            for (int i = 0; i < rails; ++i) {
                right.add(PieceProperty.byPosAndAngles(-transverse, 0.0f, -0.5f + (float)i * railLength, 0.0f, 0.0f, 0.0f));
            }
            float H = UtilTrackGeometry.getSwitchCircularHeight(railway, s + 0.5f, radian);
            float x = UtilTrackGeometry.getSwitchCrossRailHeight(railway, s + 0.5f, radian) + h;
            rails = Math.round((H - x) / railLength);
            float sc = (H - x) / ((float)rails * railLength);
            for (int i = 0; i < rails; ++i) {
                left.add(new PieceProperty(transverse, 0.0f, x - 0.5f + (float)i * railLength * sc, 1.0f, 1.0f, sc, 0.0f, 0.0f, 0.0f));
            }
            UtilTrackGeometry.addArcRailLeft(left, railway, s, radian, true);
            UtilTrackGeometry.addArcRailRightFromAngle(right, railway, s, base, UtilTrackGeometry.getSwitchCrossRailAngle(railway, s + 0.5f, radian));
        }
        return Pair.of(left, right);
    }

    public static List<Pair<PieceProperty, Integer>> getSleepersSwitchWye(EnumRailway railway, float s, int base, Random generator) {
        ArrayList<Pair<PieceProperty, Integer>> result = new ArrayList<Pair<PieceProperty, Integer>>();
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float pointer = UtilTrackGeometry.getSwitchPointerSleeper(railway, s + 0.5f, radian);
        result.add(Pair.of((Object)PieceProperty.byPosAndAngles(0.0f, 0.0f, -0.5f + pointer, 90.0f, 0.0f, 0.0f), (Object)24));
        UtilTrackGeometry.addSleepersFromTo(result, railway, 0.0f, pointer - 0.25f, generator);
        float angleSiding = UtilTrackGeometry.getSwitchWyeCrossSleeperAngle(railway, s + 0.5f, radian);
        UtilTrackGeometry.addSleepersFromAngle(result, railway, s, base, angleSiding * 1.05f, false, generator);
        UtilTrackGeometry.addSleepersFromAngle(result, railway, s, base, angleSiding * 1.05f, true, generator);
        float r = UtilTrackGeometry.getCircularRadius(s + 0.5f, radian);
        float rs = r - (float)railway.getSleeperWidth() / 2.0f / 16.0f;
        float circularGap = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        float angleTo = UtilTrackGeometry.getSwitchWyeCrossSleeperAngle2(railway, s + 0.5f, radian);
        float length = (r + 0.0f * (float)railway.getSleeperWidth() / 2.0f / 16.0f) * (float)Math.sin(angleTo) - pointer + circularGap;
        int sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float gap = length / (float)sleepers;
        for (int i = 0; i < sleepers; ++i) {
            float h = gap * ((float)i + 0.5f) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float a = (float)Math.asin((pointer - circularGap + h) / rs);
            float b = rs * (float)Math.cos(a);
            float c = rs - b;
            int l = Math.round(c * 16.0f) * 2 + 24;
            float sx = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + pointer + 0.25f + h;
            float sa = 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            result.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)l));
        }
        return result;
    }

    public static Pair<List<PieceProperty>, List<PieceProperty>> getRailsSwitchWye(EnumRailway railway, float s, int base) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        ArrayList<PieceProperty> left = UtilTrackGeometry.addArcRailLeft(new ArrayList<PieceProperty>(), railway, s, radian, true);
        ArrayList<PieceProperty> right = UtilTrackGeometry.addArcRailRight(new ArrayList<PieceProperty>(), railway, s, radian, false);
        left.remove(left.size() - 1);
        right.remove(right.size() - 1);
        float angle = UtilTrackGeometry.getSwitchWyeCrossRailAngle(railway, s + 0.5f, radian);
        UtilTrackGeometry.addArcRailLeftFromAngle(left, railway, s, base, angle);
        UtilTrackGeometry.addArcRailRightFromAngle(right, railway, s, base, angle);
        return Pair.of(left, right);
    }

    public static ArrayList<Pair<PieceProperty, Integer>> addSleepersFromTo(ArrayList<Pair<PieceProperty, Integer>> list, EnumRailway railway, float from, float to, Random generator) {
        if (from >= to) {
            return list;
        }
        float length = to - from;
        int sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float gap = length / (float)sleepers;
        for (int i = 0; i < sleepers; ++i) {
            float sx = railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + from + gap * ((float)i + 0.5f) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float sa = 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            list.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)railway.getSleeperWidth()));
        }
        return list;
    }

    public static ArrayList<Pair<PieceProperty, Integer>> addSleepersFromAngle(ArrayList<Pair<PieceProperty, Integer>> list, EnumRailway railway, float s, int base, float angx, boolean mirrored, Random generator) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float r = UtilTrackGeometry.getCircularRadius(s + 0.5f, radian);
        float circularGap = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        float length = (radian - angx) * r;
        int sleepers = Math.round(length * (float)railway.getDensity() / 1000.0f);
        float ang = 0.99f * (radian - angx) / (float)sleepers;
        for (int i = 0; i < sleepers; ++i) {
            float sx = (float)((double)r * (Math.cos(((float)i + 0.5f) * ang + angx) - 1.0) * (double)(mirrored ? -1.0f : 1.0f)) + railway.getTolTransverse() * (generator.nextFloat() * 2.0f - 1.0f);
            float sz = -0.5f + circularGap + (float)((double)r * Math.sin(((float)i + 0.5f) * ang + angx)) + railway.getTolAxial() * (generator.nextFloat() * 2.0f - 1.0f);
            float sa = (float)Math.toDegrees(((float)i + 0.5f) * ang + angx) * (mirrored ? -1.0f : 1.0f) + 90.0f + railway.getTolAngular() * (generator.nextFloat() * 2.0f - 1.0f);
            list.add((Pair<PieceProperty, Integer>)Pair.of((Object)PieceProperty.byPosAndAngles(sx, 0.0f, sz, sa, 0.0f, 0.0f), (Object)24));
        }
        return list;
    }

    public static ArrayList<PieceProperty> addArcRailLeftFromAngle(ArrayList<PieceProperty> list, EnumRailway railway, float s, int base, float ang) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float railLength = 0.5f;
        float radiusAxial = UtilTrackGeometry.getCircularRadius(s + 0.5f, radian);
        float h = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        float G = railway.getGauge().getWidth() / 2.0f;
        float r = railway.getRailProfile().getHeadWidth() / 2.0f;
        float radius = radiusAxial + G + r * 2.0f;
        float length = (radian - ang) * radius;
        int rails = Math.round(length / railLength);
        float angle = (radian - ang) / (float)rails;
        float scale = 1.001f * length / ((float)rails * railLength);
        for (int i = 0; i <= rails; ++i) {
            float transverse = -radiusAxial + (radius - r) * (float)Math.cos(ang + (float)i * angle);
            float axial = -0.5f + h + (radius - r) * (float)Math.sin(ang + (float)i * angle);
            float azimuth = (float)Math.toDegrees(ang + ((float)i + 0.5f) * angle);
            list.add(new PieceProperty(transverse, 0.0f, axial, 1.0f, 1.0f, scale, azimuth, 0.0f, 0.0f));
        }
        return list;
    }

    public static ArrayList<PieceProperty> addArcRailRightFromAngle(ArrayList<PieceProperty> list, EnumRailway railway, float s, int base, float ang) {
        float radian = EnumDiagonal.byOrdinal(base).getRadian();
        float railLength = 0.5f;
        float radiusAxial = UtilTrackGeometry.getCircularRadius(s + 0.5f, radian);
        float h = UtilTrackGeometry.getCircularGap(s + 0.5f, radian);
        float G = railway.getGauge().getWidth() / 2.0f;
        float r = railway.getRailProfile().getHeadWidth() / 2.0f;
        float radius = radiusAxial + G + r * 2.0f;
        float length = (radian - ang) * radius;
        int rails = Math.round(length / railLength);
        float angle = (radian - ang) / (float)rails;
        float scale = 1.001f * length / ((float)rails * railLength);
        for (int i = 0; i <= rails; ++i) {
            float transverse = radiusAxial - (radius - r) * (float)Math.cos(ang + (float)i * angle);
            float axial = -0.5f + h + (radius - r) * (float)Math.sin(ang + (float)i * angle);
            float azimuth = (float)(-Math.toDegrees(ang + ((float)i + 0.5f) * angle));
            list.add(new PieceProperty(transverse, 0.0f, axial, 1.0f, 1.0f, scale, azimuth, 0.0f, 0.0f));
        }
        return list;
    }

    public static ArrayList<PieceProperty> addArcRailRight(ArrayList<PieceProperty> list, EnumRailway railway, float s, float arc, boolean mirrored) {
        float railLength = 0.5f;
        float radiusAxial = UtilTrackGeometry.getCircularRadius(s + 0.5f, arc);
        float h = UtilTrackGeometry.getCircularGap(s + 0.5f, arc);
        float G = railway.getGauge().getWidth() / 2.0f;
        float r = railway.getRailProfile().getHeadWidth() / 2.0f;
        float radius = mirrored ? radiusAxial + G + r * 2.0f : radiusAxial - G;
        float length = arc * radius;
        int rails = Math.round(length / railLength);
        float angle = arc / (float)rails;
        float scale = 1.01f * length / ((float)rails * railLength);
        if (!mirrored) {
            for (int i = 0; i <= rails; ++i) {
                float transverse = -radiusAxial + (radius - r) * (float)Math.cos((float)i * angle);
                float axial = -0.5f + h + (radius - r) * (float)Math.sin((float)i * angle);
                float azimuth = (float)Math.toDegrees(((float)i + 0.5f) * angle);
                list.add(new PieceProperty(transverse, 0.0f, axial, 1.0f, 1.0f, scale, azimuth, 0.0f, 0.0f));
            }
        } else {
            for (int i = 0; i <= rails; ++i) {
                float transverse = radiusAxial - (radius - r) * (float)Math.cos((float)i * angle);
                float axial = -0.5f + h + (radius - r) * (float)Math.sin((float)i * angle);
                float azimuth = -((float)Math.toDegrees(((float)i + 0.5f) * angle));
                list.add(new PieceProperty(transverse, 0.0f, axial, 1.0f, 1.0f, scale, azimuth, 0.0f, 0.0f));
            }
        }
        return list;
    }

    public static ArrayList<PieceProperty> addArcRailLeft(ArrayList<PieceProperty> list, EnumRailway railway, float s, float arc, boolean mirrored) {
        float railLength = 0.5f;
        float radiusAxial = UtilTrackGeometry.getCircularRadius(s + 0.5f, arc);
        float h = UtilTrackGeometry.getCircularGap(s + 0.5f, arc);
        float G = railway.getGauge().getWidth() / 2.0f;
        float r = railway.getRailProfile().getHeadWidth() / 2.0f;
        float radius = mirrored ? radiusAxial - G : radiusAxial + G + r * 2.0f;
        float length = arc * radius;
        int rails = Math.round(length / railLength);
        float angle = arc / (float)rails;
        float scale = 1.001f * length / ((float)rails * railLength);
        for (int i = 0; i <= rails; ++i) {
            float transverse = -radiusAxial + (radius - r) * (float)Math.cos((float)i * angle);
            float axial = -0.5f + h + (radius - r) * (float)Math.sin((float)i * angle);
            float azimuth = (mirrored ? -1.0f : 1.0f) * (float)Math.toDegrees(((float)i + 0.5f) * angle);
            list.add(new PieceProperty((mirrored ? -1.0f : 1.0f) * transverse, 0.0f, axial, 1.0f, 1.0f, scale, azimuth, 0.0f, 0.0f));
        }
        return list;
    }

    public static float getSwitchWyeCrossSleeperAngle2(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getSwitchWyeCrossSleeperAngle(railway, s, alpha);
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        float h = (r + (float)railway.getSleeperWidth() / 2.0f / 16.0f) * (float)Math.sin(a) - 0.0625f;
        return (float)Math.atan(h / r);
    }

    public static float getSwitchWyeCrossSleeperAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha);
        float r = a + (float)railway.getSleeperWidth() / 2.0f / 16.0f;
        return (float)Math.acos(a / r);
    }

    public static float getSwitchWyeCrossRailAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha);
        float r = a + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        return (float)Math.acos(a / r);
    }

    public static float getSwitchWyeCrossRailHeight(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha);
        float b = a + railway.getGauge().getWidth() / 2.0f;
        return (float)Math.sqrt(b * b - a * a);
    }

    public static float getSwitchWyeCrossRailHeight2(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha);
        float b = a + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        return (float)Math.sqrt(b * b - a * a);
    }

    public static float getSwitchWyeFrogWidth(EnumRailway railway, float s, float alpha) {
        float h = UtilTrackGeometry.getSwitchWyeCrossRailHeight2(railway, s, alpha);
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        float rs = r + railway.getGauge().getWidth() / 2.0f;
        float a = (float)Math.asin(h / rs);
        float b = rs * (float)Math.cos(a);
        return 2.0f * (r - b);
    }

    public static float getSwitchWyeBladePivot(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) - 0.03125f;
        float b = a + railway.getGauge().getWidth() / 2.0f - 0.0625f;
        return (float)Math.sqrt(b * b - a * a);
    }

    public static float getSwitchWyeCounterInAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getSwitchWyeBladePivot(railway, s, alpha);
        float r = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f - 0.0625f;
        return (float)Math.asin(a / r);
    }

    public static float getSwitchWyeCounterAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f - 0.0625f;
        float h = UtilTrackGeometry.getSwitchWyeBladePivot(railway, s, alpha) + 0.25f;
        return (float)Math.asin(h / a);
    }

    public static float getSwitchWyePlateWidth(EnumRailway railway, float s, float alpha) {
        float ang = UtilTrackGeometry.getSwitchWyeCounterInAngle(railway, s, alpha);
        float h = UtilTrackGeometry.getSwitchWyeBladePivot(railway, s, alpha) + 0.8f * (float)Math.cos(ang);
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        float rs = r + railway.getGauge().getWidth() / 2.0f - 0.271875f;
        float a = (float)Math.asin(h / rs);
        float b = rs * (float)Math.cos(a);
        return 2.0f * (r - b);
    }

    public static float getSwitchBladeAngleWye(EnumRailway railway, float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        float a = r + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float h = UtilTrackGeometry.getSwitchWyeBladePivot(railway, s, alpha) - UtilTrackGeometry.getSwitchBladeHeight(railway, s, alpha) - 1.0625f * UtilTrackGeometry.getSwitchBladeScaleWye(s, ANGLE45);
        float w = railway.getGauge().getWidth() / 2.0f - 0.015625f;
        float b = (float)Math.sqrt(h * h + w * w) / 2.0f;
        return (float)Math.asin(b / a) * 2.0f;
    }

    public static float getSwitchBladeInitialAngleWye(EnumRailway railway, float s, float alpha) {
        float h = UtilTrackGeometry.getSwitchWyeBladePivot(railway, s, alpha) - UtilTrackGeometry.getSwitchBladeHeight(railway, s, alpha) - 1.0625f * UtilTrackGeometry.getSwitchBladeScaleWye(s, ANGLE45);
        float w = railway.getGauge().getWidth() / 2.0f - 0.015625f;
        float b = (float)Math.sqrt(h * h + w * w);
        return (float)Math.asin(w / b);
    }

    public static float getSwitchBladeScaleWye(float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        return 0.7f + 0.25f * (r - 15.363f) / 15.363f;
    }

    public static float getSwitchBladeTwistWye(float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        return 1.8f - 2.4f * (r - 51.213f) / 51.213f;
    }

    public static float getSlopeRadius(float length, float raise) {
        return Math.abs((length * length + raise * raise) / (2.0f * raise));
    }

    public static EnumRailway getRailway(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        IBlockState tryState = RoWTracks.blockTrackSWNE.getExtendedState(blockState, (IBlockAccess)world, pos);
        if (!(tryState instanceof IExtendedBlockState)) {
            return EnumRailway.RW750REGULAR;
        }
        IExtendedBlockState exState = (IExtendedBlockState)tryState;
        return (EnumRailway)((Object)exState.getValue((IUnlistedProperty)BlockTrackBase.railway));
    }

    public static float getSwitchPointerSleeper(EnumRailway railway, float s, float alpha) {
        float height;
        float offset = (height = UtilTrackGeometry.getSwitchPointerHeight(railway, s, alpha)) - ((float)((int)height) + 0.5f);
        return height + 0.25f * (offset > 0.0f ? -1.0f : 1.0f);
    }

    public static int getSwitchPointerBlock(EnumRailway railway, float s, float alpha) {
        return (int)UtilTrackGeometry.getSwitchPointerHeight(railway, s, alpha);
    }

    public static float getSwitchPointerHeight(EnumRailway railway, float s, float alpha) {
        return UtilTrackGeometry.getCircularGap(s, alpha) + UtilTrackGeometry.getSwitchBladeHeight(railway, s, alpha) + 0.0625f;
    }

    public static float getSwitchBladeInitialAngle(EnumRailway railway, float s, float alpha) {
        float h = UtilTrackGeometry.getSwitchBladeCurvePivot(railway, s, alpha) - UtilTrackGeometry.getSwitchBladeHeight(railway, s, alpha) - 1.436f * UtilTrackGeometry.getSwitchBladeScale(s, ANGLE45);
        float w = railway.getGauge().getWidth() - 0.1875f - 0.057f;
        float b = (float)Math.sqrt(h * h + w * w);
        return (float)Math.asin(w / b);
    }

    public static float getSwitchBladeAngle(EnumRailway railway, float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        float a = r + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float h = UtilTrackGeometry.getSwitchBladeCurvePivot(railway, s, alpha) - UtilTrackGeometry.getSwitchBladeHeight(railway, s, alpha) - 1.436f * UtilTrackGeometry.getSwitchBladeScale(s, ANGLE45);
        float w = railway.getGauge().getWidth() - 0.1875f - 0.057f;
        float b = (float)Math.sqrt(h * h + w * w) / 2.0f;
        return (float)Math.asin(b / a) * 2.0f;
    }

    public static float getSwitchBladeLength(EnumRailway railway, float s, float alpha) {
        return UtilTrackGeometry.getSwitchBladeStraightPivot(railway, s, ANGLE45) - UtilTrackGeometry.getSwitchBladeHeight(railway, s, ANGLE45) - UtilTrackGeometry.getSwitchBladeScale(s, ANGLE45) * 17.0f / 16.0f;
    }

    public static float getSwitchBladeScale(float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha);
        return 1.0f + 0.4f * (r - 15.363f) / 15.363f;
    }

    public static float getSwitchBladeCurvePivot(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - (railway.getGauge().getWidth() / 2.0f - 0.1875f);
        return (float)Math.sqrt(a * a - b * b);
    }

    public static float getSwitchBladeStraightPivot(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f - 0.0625f;
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - railway.getGauge().getWidth() / 2.0f;
        return (float)Math.sqrt(a * a - b * b);
    }

    public static float getSwitchBladeHeight(EnumRailway railway, float s, float alpha) {
        float r = UtilTrackGeometry.getCircularRadius(s, alpha) - railway.getGauge().getWidth() / 2.0f;
        float w = r - 0.028125f;
        return (float)Math.sqrt(r * r - w * w);
    }

    public static int getSwitchCircularHeight(EnumRailway railway, float s, float alpha) {
        return (int)Math.ceil(UtilTrackGeometry.getSwitchCrossSleeperHeight(railway, s, alpha) + 0.25f);
    }

    public static float getSwitchCrossSleeperHeight(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + (float)railway.getSleeperWidth() / 16.0f / 2.0f + 0.0625f;
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - (float)railway.getSleeperWidth() / 16.0f / 2.0f - 0.0625f;
        return (float)Math.sqrt(a * a - b * b);
    }

    public static float getSwitchCrossSleeperAngle2(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + (float)railway.getSleeperWidth() / 16.0f / 2.0f;
        float h = UtilTrackGeometry.getSwitchPointerSleeper(railway, s, alpha) - UtilTrackGeometry.getCircularGap(s, alpha) + 0.25f;
        return (float)Math.asin(h / a);
    }

    public static float getSwitchCrossSleeperAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + (float)railway.getSleeperWidth() / 16.0f / 2.0f;
        float h = UtilTrackGeometry.getSwitchCrossSleeperHeight(railway, s, alpha) - UtilTrackGeometry.getCircularGap(s, alpha);
        return (float)Math.asin(h / a);
    }

    public static float getSwitchCounterAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f - 0.0625f;
        float h = UtilTrackGeometry.getSwitchBladeStraightPivot(railway, s, alpha);
        return (float)Math.asin(h / a);
    }

    public static float getSwitchCrossRailAngle(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f;
        float h = UtilTrackGeometry.getSwitchCrossRailHeight(railway, s, alpha);
        return (float)Math.asin(h / a);
    }

    public static float getSwitchCrossRailHeight(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f;
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - railway.getGauge().getWidth() / 2.0f - railway.getRailProfile().getHeadWidth();
        return (float)Math.sqrt(a * a - b * b);
    }

    public static float getSwitchCrossRailHeight2(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f;
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - railway.getGauge().getWidth() / 2.0f;
        return (float)Math.sqrt(a * a - b * b);
    }

    public static float getSwitchCrossRailHeight3(EnumRailway railway, float s, float alpha) {
        float a = UtilTrackGeometry.getCircularRadius(s, alpha) + railway.getGauge().getWidth() / 2.0f + railway.getRailProfile().getHeadWidth();
        float b = UtilTrackGeometry.getCircularRadius(s, alpha) - railway.getGauge().getWidth() / 2.0f - railway.getRailProfile().getHeadWidth();
        return (float)Math.sqrt(a * a - b * b);
    }

    public static int getCircularHeight(float s, float alpha) {
        float b = s / (float)Math.sin(alpha);
        float c = s / (float)Math.tan(alpha);
        return (int)Math.ceil(b + c);
    }

    public static Pair<Float, Float> getCircularParams(float s, float alpha) {
        float b = s / (float)Math.sin(alpha);
        float c = s / (float)Math.tan(alpha);
        float R = b / (float)Math.tan(alpha / 2.0f);
        float h = (float)Math.ceil(b + c) - b - c;
        return Pair.of((Object)Float.valueOf(R), (Object)Float.valueOf(h));
    }

    public static float getCircularArc(float s, float alpha) {
        float b = s / (float)Math.sin(alpha);
        float R = b / (float)Math.tan(alpha / 2.0f);
        return R * alpha;
    }

    public static float getCircularRadius(float s, float alpha) {
        float b = s / (float)Math.sin(alpha);
        float R = b / (float)Math.tan(alpha / 2.0f);
        return R;
    }

    public static float getCircularGap(float s, float alpha) {
        float b = s / (float)Math.sin(alpha);
        float c = s / (float)Math.tan(alpha);
        float h = (float)Math.ceil(b + c) - b - c;
        return h;
    }

    public static Random getGenerator(int seed) {
        return new Random(seed);
    }

    public static Random getGenerator(BlockPos pos) {
        return new Random(UtilTrackGeometry.getSeed(pos));
    }

    public static int getSeed(BlockPos pos) {
        return pos.func_177958_n() % 16 * 10000 + pos.func_177956_o() % 16 * 100 + pos.func_177952_p() % 16;
    }
}

