/*
 * Decompiled with CFR 0.152.
 */
package net.railsofwar.row.track.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.railsofwar.row.common.enumerate.EnumDirectionSWNE;
import net.railsofwar.row.common.math.RotationHelper;
import net.railsofwar.row.track.RoWTracks;
import net.railsofwar.row.track.client.ParticleTrackPlace;
import net.railsofwar.row.track.enumeration.EnumDiagonal;
import net.railsofwar.row.track.enumeration.EnumRailway;
import net.railsofwar.row.track.enumeration.EnumTrackShape;
import net.railsofwar.row.track.util.UtilTrackGeometry;
import org.apache.commons.lang3.tuple.Triple;

public class UtilTrackStructure {
    private static final float R45 = (float)Math.toRadians(45.0);

    public static boolean checkStructure(ArrayList<Triple<BlockPos, Block, Boolean>> structure, World world, BlockPos anchor, EnumDirectionSWNE dir) {
        for (Triple<BlockPos, Block, Boolean> triple : structure) {
            BlockPos pos = RotationHelper.rotateByDir((BlockPos)triple.getLeft(), anchor, dir);
            if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                return false;
            }
            BlockPos posBase = pos.func_177977_b();
            if (!((Boolean)triple.getRight()).booleanValue() || world.func_180495_p(pos.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(posBase), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean checkStructureAndMark(ArrayList<Triple<BlockPos, Block, Boolean>> structure, World world, BlockPos anchor, EnumDirectionSWNE dir) {
        boolean ret = true;
        Random random = new Random();
        for (Triple<BlockPos, Block, Boolean> triple : structure) {
            BlockPos pos = RotationHelper.rotateByDir((BlockPos)triple.getLeft(), anchor, dir);
            if (!world.func_175623_d(pos) && !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                ret = false;
                float radius = 0.5625f;
                for (int i = 0; i < 32; ++i) {
                    ParticleTrackPlace fx = new ParticleTrackPlace(world, (float)pos.func_177958_n() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, (float)pos.func_177956_o() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, (float)pos.func_177952_p() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, 1.0f, 30.0f, ParticleTrackPlace.EnumParticleTrackColour.RED);
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
                }
            }
            BlockPos posBase = pos.func_177977_b();
            if (!((Boolean)triple.getRight()).booleanValue() || world.func_180495_p(pos.func_177977_b()).func_177230_c().isSideSolid(world.func_180495_p(posBase), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) continue;
            ret = false;
            float radius = 0.375f;
            for (int i = 0; i < 32; ++i) {
                ParticleTrackPlace fx = new ParticleTrackPlace(world, (float)posBase.func_177958_n() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, (float)posBase.func_177956_o() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, (float)posBase.func_177952_p() + 0.5f + 2.0f * (random.nextFloat() - 0.5f) * radius, 1.0f, 30.0f, ParticleTrackPlace.EnumParticleTrackColour.ORANGE);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
            }
        }
        return ret;
    }

    public static ArrayList<Triple<BlockPos, Block, Boolean>> getStructure(EnumTrackShape shape, EnumRailway railway, int scalarA, int scalarB, boolean mirrored) {
        ArrayList<Triple<BlockPos, Block, Boolean>> list;
        block13: {
            block18: {
                block19: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block12: {
                                        list = new ArrayList<Triple<BlockPos, Block, Boolean>>();
                                        if (shape != EnumTrackShape.TURNTABLE) {
                                            list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, 0), (Object)((Object)RoWTracks.blockTrackSWNE), (Object)true));
                                        }
                                        if (shape != EnumTrackShape.STRAIGHT) break block12;
                                        for (int i = 1; i < scalarA; ++i) {
                                            list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                                        }
                                        break block13;
                                    }
                                    if (shape != EnumTrackShape.DIAGONAL) break block14;
                                    for (int i = 0; i < scalarA; ++i) {
                                        list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-i + 1, 0, i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                                        if (i != 0) {
                                            list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-i, 0, i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                                        }
                                        list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-i - 1, 0, i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                                    }
                                    break block13;
                                }
                                if (shape != EnumTrackShape.SLOPE_STRAIGHT) break block15;
                                float radius = UtilTrackGeometry.getSlopeRadius((float)scalarA / 2.0f, (float)scalarB / 2.0f);
                                for (int i = 1; i < scalarA; ++i) {
                                    float forward = (float)i + 0.5f;
                                    float raise = radius - (float)Math.sqrt(radius * radius - forward * forward);
                                    if (forward > (float)scalarA / 2.0f) {
                                        forward = (float)scalarA - forward;
                                        raise = (float)Math.abs(scalarB) - radius + (float)Math.sqrt(radius * radius - forward * forward);
                                    }
                                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, (int)((double)Math.signum(scalarB) * Math.floor(raise)), i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                                }
                                break block13;
                            }
                            if (shape != EnumTrackShape.CIRCULAR && shape != EnumTrackShape.SWITCH_CIRCULAR) break block16;
                            UtilTrackStructure.addArc(list, railway, scalarA, scalarB, mirrored);
                            if (shape != EnumTrackShape.SWITCH_CIRCULAR) break block13;
                            for (int i = 1; i < UtilTrackGeometry.getSwitchCircularHeight(railway, (float)scalarA + 0.5f, EnumDiagonal.byOrdinal(scalarB).getRadian()); ++i) {
                                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, i), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                            }
                            break block13;
                        }
                        if (shape != EnumTrackShape.SWITCH_WYE) break block17;
                        UtilTrackStructure.addArc(list, railway, scalarA, scalarB, false);
                        UtilTrackStructure.addArc(list, railway, scalarA, scalarB, true);
                        break block13;
                    }
                    if (shape != EnumTrackShape.DIAMOND_STRAIGHT && shape != EnumTrackShape.DIAMOND_DIAGONAL && shape != EnumTrackShape.DIAMOND_SHARP) break block18;
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(1, 0, 0), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-1, 0, 0), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    if (shape != EnumTrackShape.DIAMOND_DIAGONAL) break block19;
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-1, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(1, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-2, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(2, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(1, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(1, 0, 2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-1, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-1, 0, -2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-1, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(1, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    break block13;
                }
                if (shape != EnumTrackShape.DIAMOND_SHARP) break block13;
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, 2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, -2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                int i = mirrored ? 1 : -1;
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(i, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-i, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                if (!mirrored) {
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(2 * i, 0, 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-2 * i, 0, -1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                } else {
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(i, 0, 2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(-i, 0, -2), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                }
                break block13;
            }
            if (shape == EnumTrackShape.TURNTABLE) {
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(0, 0, 0), (Object)((Object)RoWTracks.blockTurntable), (Object)true));
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) continue;
                        list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(i, 0, j), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                    }
                }
            }
        }
        return list;
    }

    public static void addArc(ArrayList<Triple<BlockPos, Block, Boolean>> list, EnumRailway railway, int scalarA, int scalarB, boolean mirrored) {
        float radian = EnumDiagonal.byOrdinal(scalarB).getRadian();
        float r = UtilTrackGeometry.getCircularRadius((float)scalarA + 0.5f, radian);
        int H = UtilTrackGeometry.getCircularHeight((float)scalarA + 0.5f, radian);
        float h = UtilTrackGeometry.getCircularGap((float)scalarA + 0.5f, radian);
        list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)new BlockPos(scalarA * (mirrored ? 1 : -1), 0, H - 1), (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
        float l = UtilTrackGeometry.getCircularArc((float)scalarA + 0.5f, radian);
        float n = 5 * (int)Math.ceil(l);
        float g = railway.getGauge().getWidth() / 2.0f + 0.125f;
        BlockPos prevPos1 = new BlockPos(0, 0, 0);
        BlockPos prevPos2 = new BlockPos(0, 0, 0);
        BlockPos fitting = new BlockPos((scalarA + (mirrored ? 1 : 0)) * (mirrored ? 1 : -1), 0, H - 1 + (mirrored ? 0 : 1));
        int i = 1;
        while ((float)i < n) {
            float a = radian * (float)i / n;
            int x1 = (int)Math.floor((double)(0.5f + r) - (double)(r + g) * Math.cos(a)) * (mirrored ? 1 : -1);
            int z1 = (int)Math.floor((double)h + (double)(r + g) * Math.sin(a));
            int x2 = (int)Math.floor((double)(0.5f + r) - (double)(r - g) * Math.cos(a)) * (mirrored ? 1 : -1);
            int z2 = (int)Math.floor((double)h + (double)(r - g) * Math.sin(a));
            BlockPos pos1 = new BlockPos(x1, 0, z1);
            BlockPos pos2 = new BlockPos(x2, 0, z2);
            if (!pos1.equals((Object)prevPos1) && !pos1.equals((Object)fitting)) {
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)pos1, (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                prevPos1 = pos1;
            }
            if (!pos2.equals((Object)prevPos2) && !pos2.equals((Object)fitting)) {
                list.add((Triple<BlockPos, Block, Boolean>)Triple.of((Object)pos2, (Object)((Object)RoWTracks.blockTrackGag), (Object)true));
                prevPos2 = pos2;
            }
            ++i;
        }
    }
}

