/*
 * Decompiled with CFR 0.152.
 */
package net.row.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBench
extends Block {
    public static int renderType;
    private IIcon renderIcon;

    public BlockBench() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(2.0f);
        this.func_149663_c("row.blockBench");
        this.func_149658_d("row:bench");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.3f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(this.func_149641_N());
        this.renderIcon = register.func_94245_a("row:bench_map");
    }

    public IIcon getRenderIcon() {
        return this.renderIcon;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int meta = 0;
        float playerRotation = Math.abs(player.field_70177_z % 360.0f);
        meta = playerRotation < 45.0f || playerRotation >= 315.0f ? 1 : (playerRotation < 135.0f ? 2 : (playerRotation < 225.0f ? 3 : 0));
        meta = this.getMetaFromNeighbours(world, x, y, z, meta);
        world.func_72921_c(x, y, z, meta, 2);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int thisBlockMetadata = world.func_72805_g(x, y, z);
        thisBlockMetadata = this.getMetaFromNeighbours(world, x, y, z, thisBlockMetadata);
        world.func_72921_c(x, y, z, thisBlockMetadata, 2);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderType;
    }

    public int getMetaFromNeighbours(World world, int x, int y, int z, int metadata) {
        boolean benchLeft = false;
        boolean benchRight = false;
        byte direction = (byte)(metadata & 3);
        boolean lowered = BlockBench.isLowered((IBlockAccess)world, x, y, z);
        boolean fE = world.func_147439_a(x + 1, y, z) instanceof BlockBench;
        boolean fW = world.func_147439_a(x - 1, y, z) instanceof BlockBench;
        boolean fS = world.func_147439_a(x, y, z + 1) instanceof BlockBench;
        boolean fN = world.func_147439_a(x, y, z - 1) instanceof BlockBench;
        boolean mE = (world.func_72805_g(x + 1, y, z) & 3) == direction;
        boolean mW = (world.func_72805_g(x - 1, y, z) & 3) == direction;
        boolean mS = (world.func_72805_g(x, y, z + 1) & 3) == direction;
        boolean mN = (world.func_72805_g(x, y, z - 1) & 3) == direction;
        boolean lE = BlockBench.isLowered((IBlockAccess)world, x + 1, y, z) == lowered;
        boolean lW = BlockBench.isLowered((IBlockAccess)world, x - 1, y, z) == lowered;
        boolean lS = BlockBench.isLowered((IBlockAccess)world, x, y, z + 1) == lowered;
        boolean lN = BlockBench.isLowered((IBlockAccess)world, x, y, z - 1) == lowered;
        switch (direction) {
            case 1: {
                benchLeft = fE && mE && lE;
                benchRight = fW && mW && lW;
                break;
            }
            case 0: {
                benchLeft = fN && mN && lN;
                benchRight = fS && mS && lS;
                break;
            }
            case 3: {
                benchLeft = fW && mW && lW;
                benchRight = fE && mE && lE;
                break;
            }
            case 2: {
                benchLeft = fS && mS && lS;
                boolean bl = benchRight = fN && mN && lN;
            }
        }
        if (benchLeft && benchRight) {
            return direction | 0xC;
        }
        if (benchRight) {
            return direction | 8;
        }
        if (benchLeft) {
            return direction | 4;
        }
        return direction;
    }

    public static boolean isLowered(IBlockAccess world, int x, int y, int z) {
        return (world.func_147439_a(x, y - 1, z) == Blocks.field_150333_U || world.func_147439_a(x, y - 1, z) == Blocks.field_150376_bx) && (world.func_72805_g(x, y - 1, z) & 8) == 0;
    }
}

