/*
 * Decompiled with CFR 0.152.
 */
package net.row.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.entity.GunHowitzerLight;
import net.row.helpers.RotativePoint;
import net.row.network.PacketMovement;
import net.row.network.PacketRequestServerNBTData;
import net.row.stock.core.RoWRollingStock;

public class EntityCartRider
extends Entity {
    public String parentUUID;
    public RoWRollingStock parent;
    public RotativePoint riderPos;
    public float mountHeight;

    public EntityCartRider(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityCartRider(World world, float f1) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
        this.mountHeight = f1;
    }

    public EntityCartRider(RoWRollingStock parent) {
        this(parent.field_70170_p, 0.0f);
        this.parentUUID = parent.UUID;
        this.parent = parent;
        this.riderPos = new RotativePoint(this, parent.riderPos.getRelX(), parent.riderPos.getRelY(), parent.riderPos.getRelZ());
        this.riderPos.setFollowZenith(true);
        this.func_70080_a(parent.field_70165_t, parent.field_70163_u, parent.field_70161_v, parent.field_70177_z, parent.field_70125_A);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70153_n == null && this.field_70173_aa > 100) {
            this.func_70106_y();
        } else if (this.parent == null) {
            if (this.field_70170_p.field_72995_K && this.parentUUID == null) {
                RoW.network.sendToServer((IMessage)new PacketRequestServerNBTData(this.func_145782_y()));
                return;
            }
            if (this.field_70173_aa > 100) {
                this.func_70106_y();
            } else {
                for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (!(entity instanceof RoWRollingStock) || !((RoWRollingStock)entity).UUID.equals(this.parentUUID)) continue;
                    this.parent = (RoWRollingStock)entity;
                }
            }
        } else if (this.parent.field_70128_L) {
            this.func_70106_y();
        } else {
            this.func_70080_a(this.parent.field_70165_t, this.parent.field_70163_u, this.parent.field_70161_v, this.parent.field_70177_z, -this.parent.field_70125_A);
            if (this.riderPos == null) {
                this.riderPos = new RotativePoint(this, this.parent.riderPos.getRelX(), this.parent.riderPos.getRelY(), this.parent.riderPos.getRelZ());
                this.riderPos.setFollowZenith(true);
            }
            this.riderPos.onUpdate();
            if (this.field_70170_p.field_72995_K) {
                this.processRiderMove();
            }
        }
    }

    public void processRiderMove() {
        if (this.field_70153_n instanceof EntityLivingBase && (((EntityLivingBase)this.field_70153_n).field_70701_bs != 0.0f || ((EntityLivingBase)this.field_70153_n).field_70702_br != 0.0f)) {
            float rmm = 0.13f;
            float riderMoveForward = ((EntityLivingBase)this.field_70153_n).field_70701_bs * rmm;
            float riderMoveStrafing = ((EntityLivingBase)this.field_70153_n).field_70702_br * rmm;
            float riderMoveCos = (float)Math.cos(Math.toRadians(this.field_70153_n.field_70177_z - this.field_70177_z));
            float riderMoveSin = (float)Math.sin(Math.toRadians(this.field_70153_n.field_70177_z - this.field_70177_z));
            float relX = this.riderPos.getRelX() - riderMoveSin * riderMoveForward + riderMoveCos * riderMoveStrafing;
            float relZ = this.riderPos.getRelZ() + riderMoveCos * riderMoveForward + riderMoveSin * riderMoveStrafing;
            if (relX < this.parent.walkableMinX) {
                relX = this.parent.walkableMinX;
            }
            if (relX > this.parent.walkableMaxX) {
                relX = this.parent.walkableMaxX;
            }
            if (relZ < this.parent.walkableMinZ) {
                relZ = this.parent.walkableMinZ;
            }
            if (relZ > this.parent.walkableMaxZ) {
                relZ = this.parent.walkableMaxZ;
            }
            RoW.network.sendToServer((IMessage)new PacketMovement(this.func_145782_y(), relX, relZ));
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null && this.parent != null && this.riderPos != null) {
            this.field_70153_n.func_70107_b((double)this.riderPos.getX(), (double)this.riderPos.getY() + this.parent.func_70042_X() + this.func_70042_X() + this.field_70153_n.func_70033_W(), (double)this.riderPos.getZ());
            this.field_70153_n.field_70177_z += this.parent.field_70177_z - this.parent.field_70126_B;
            if (this.field_70153_n instanceof GunHowitzerLight) {
                this.field_70153_n.field_70177_z = this.parent.field_70177_z;
            }
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double func_70042_X() {
        return this.mountHeight;
    }

    public void func_70020_e(NBTTagCompound nbttagcompound) {
        super.func_70020_e(nbttagcompound);
        this.parentUUID = nbttagcompound.func_74779_i("parentUUID");
        this.mountHeight = nbttagcompound.func_74760_g("mountHeight");
    }

    public void func_70109_d(NBTTagCompound nbttagcompound) {
        super.func_70109_d(nbttagcompound);
        nbttagcompound.func_74778_a("parentUUID", this.parentUUID);
        nbttagcompound.func_74776_a("mountHeight", this.mountHeight);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

