/*
 * Decompiled with CFR 0.152.
 */
package net.row.helpers;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.row.RoW;
import net.row.network.PacketSendTrackData;

public class TrackHelper
extends WorldSavedData {
    private List<List<int[]>> masterTrackChildren = new ArrayList<List<int[]>>();
    public static final String filename = "row_mappings";

    public TrackHelper() {
        super(filename);
    }

    public TrackHelper(String mapName) {
        this();
    }

    public void addTrack(World world, int[] masterCoords, int[] partCoords) {
        for (List<int[]> childList : this.masterTrackChildren) {
            for (int[] coords : childList) {
                if (!Arrays.equals(coords, partCoords)) continue;
                return;
            }
        }
        int masterTrackId = this.getMasterTrackId(masterCoords);
        if (masterTrackId == -1) {
            masterTrackId = this.masterTrackChildren.size();
            ArrayList<int[]> newTrackList = new ArrayList<int[]>();
            newTrackList.add(masterCoords);
            this.masterTrackChildren.add(masterTrackId, newTrackList);
        }
        if (!partCoords.equals(masterCoords)) {
            this.masterTrackChildren.get(masterTrackId).add(partCoords);
        }
        this.markTrackAdded(world, masterCoords, partCoords);
    }

    public void updateTrack(World world, int[] partCoords) {
        int masterTrackId = this.getMasterTrackId(partCoords);
        if (masterTrackId == -1) {
            return;
        }
        List<int[]> trackList = this.masterTrackChildren.get(masterTrackId);
        for (int[] coords : trackList) {
            world.func_147444_c(coords[0], coords[1], coords[2], world.func_147439_a(coords[0], coords[1], coords[2]));
        }
    }

    public void removeTrack(World world, int[] partCoords) {
        int masterTrackId = this.getMasterTrackId(partCoords);
        if (masterTrackId == -1) {
            return;
        }
        List<int[]> trackList = this.masterTrackChildren.get(masterTrackId);
        for (int[] coords : trackList) {
            world.func_147468_f(coords[0], coords[1], coords[2]);
            world.func_147475_p(coords[0], coords[1], coords[2]);
        }
        this.masterTrackChildren.remove(masterTrackId);
        this.markTrackDeleted(world, partCoords);
    }

    public void sendTracksetToClients(World world) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            for (int i = 0; i < this.masterTrackChildren.size(); ++i) {
                for (int j = 1; j < this.masterTrackChildren.get(i).size(); ++j) {
                    RoW.network.sendToAll((IMessage)new PacketSendTrackData(this.masterTrackChildren.get(i).get(0), this.masterTrackChildren.get(i).get(j)));
                }
            }
        }
    }

    private void markTrackAdded(World world, int[] masterCoords, int[] partCoords) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            RoW.network.sendToAll((IMessage)new PacketSendTrackData(masterCoords, partCoords));
        }
    }

    private void markTrackDeleted(World world, int[] masterCoords) {
        this.func_76185_a();
        if (!world.field_72995_K) {
            RoW.network.sendToAll((IMessage)new PacketSendTrackData(masterCoords));
        }
    }

    private int getMasterTrackId(int[] childTrackCoords) {
        for (int i = 0; i < this.masterTrackChildren.size(); ++i) {
            for (int[] coords : this.masterTrackChildren.get(i)) {
                if (!Arrays.equals(childTrackCoords, coords)) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] getMasterTrackPos(int[] partCoords) {
        int trackId = this.getMasterTrackId(partCoords);
        if (trackId != -1) {
            return this.masterTrackChildren.get(trackId).get(0);
        }
        return null;
    }

    public List<int[]> getAllTrackPos() {
        ArrayList<int[]> allTracks = new ArrayList<int[]>();
        for (List<int[]> trackList : this.masterTrackChildren) {
            allTracks.addAll(trackList);
        }
        return allTracks;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        int numberParts = tagCompound.func_74762_e("numberParts");
        this.masterTrackChildren = new ArrayList<List<int[]>>();
        for (int i = 0; i < numberParts; ++i) {
            int[] trackData = tagCompound.func_74759_k(String.valueOf(i));
            ArrayList<int[]> childList = new ArrayList<int[]>();
            for (int j = 0; j < trackData.length / 3; ++j) {
                int[] trackCoords = new int[]{trackData[3 * j], trackData[3 * j + 1], trackData[3 * j + 2]};
                childList.add(trackCoords);
            }
            this.masterTrackChildren.add(childList);
        }
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("numberParts", this.masterTrackChildren.size());
        for (int i = 0; i < this.masterTrackChildren.size(); ++i) {
            List<int[]> trackList = this.masterTrackChildren.get(i);
            int[] coordList = new int[3 * trackList.size()];
            for (int j = 0; j < trackList.size(); ++j) {
                coordList[3 * j] = trackList.get(j)[0];
                coordList[3 * j + 1] = trackList.get(j)[1];
                coordList[3 * j + 2] = trackList.get(j)[2];
            }
            tagCompound.func_74783_a(String.valueOf(i), coordList);
        }
    }
}

