/*
 * Decompiled with CFR 0.152.
 */
package net.row.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.row.stock.core.RoWRollingStock;

public class ItemPrybar
extends Item {
    private boolean wasFirstCouplerFront;
    private RoWRollingStock firstCart;
    private String chatMsg = "";

    public ItemPrybar() {
        this.field_77777_bU = 1;
        this.func_77655_b("row.prybar");
        this.func_111206_d("row:prybar");
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.prybar.1"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.prybar.2"));
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float dx, float dy, float dz) {
        if (!player.field_70170_p.field_72995_K) {
            this.firstCart = null;
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.prybar.clear", new Object[0]));
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        player.field_70170_p.func_72956_a((Entity)player, "random.break", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!player.field_70170_p.field_72995_K && entity instanceof RoWRollingStock) {
            if (this.firstCart == null) {
                float dist_rear;
                this.firstCart = (RoWRollingStock)entity;
                float dist_front = this.dist_p2l(this.firstCart.couplerFrontPos.getX(), this.firstCart.couplerFrontPos.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                boolean bl = this.wasFirstCouplerFront = dist_front < (dist_rear = this.dist_p2l(this.firstCart.couplerRearPos.getX(), this.firstCart.couplerRearPos.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f));
                if (this.wasFirstCouplerFront ? this.firstCart.couplerFrontType.equals((Object)RoWRollingStock.CouplerType.NONE) : this.firstCart.couplerRearType.equals((Object)RoWRollingStock.CouplerType.NONE)) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.prybar.no_coupler", new Object[0]));
                    this.firstCart = null;
                } else {
                    this.chatMsg = StatCollector.func_74838_a((String)"row.msg.prybar.couple_pre") + " " + (this.wasFirstCouplerFront ? StatCollector.func_74838_a((String)"row.msg.prybar.front").toLowerCase() : StatCollector.func_74838_a((String)"row.msg.prybar.rear").toLowerCase()) + " " + StatCollector.func_74838_a((String)"row.msg.prybar.couple_suf");
                    player.func_146105_b((IChatComponent)new ChatComponentText(this.chatMsg));
                }
            } else {
                RoWRollingStock cart = (RoWRollingStock)entity;
                if (cart.equals((Object)this.firstCart)) {
                    this.firstCart = null;
                    this.chatMsg = StatCollector.func_74838_a((String)"row.msg.prybar.release_pre") + " " + (this.wasFirstCouplerFront ? StatCollector.func_74838_a((String)"row.msg.prybar.front").toLowerCase() : StatCollector.func_74838_a((String)"row.msg.prybar.rear")).toLowerCase() + " " + StatCollector.func_74838_a((String)"row.msg.prybar.release_suf");
                    player.func_146105_b((IChatComponent)new ChatComponentText(this.chatMsg));
                    if (this.wasFirstCouplerFront) {
                        cart.frontCartUUID = "";
                        if (cart.couplerFrontCart != null) {
                            if (cart.couplerFrontCart.frontCartUUID.equals(cart.UUID)) {
                                cart.couplerFrontCart.frontCartUUID = "";
                            } else if (cart.couplerFrontCart.rearCartUUID.equals(cart.UUID)) {
                                cart.couplerFrontCart.rearCartUUID = "";
                            }
                            cart.couplerFrontCart.updateCoupledStock(true);
                            cart.couplerFrontCart.updateTrain();
                            cart.couplerFrontCart.sendUpdateToClient();
                            cart.couplerFrontCart = null;
                        }
                    } else {
                        cart.rearCartUUID = "";
                        if (cart.couplerRearCart != null) {
                            if (cart.couplerRearCart.frontCartUUID.equals(cart.UUID)) {
                                cart.couplerRearCart.frontCartUUID = "";
                            } else if (cart.couplerRearCart.rearCartUUID.equals(cart.UUID)) {
                                cart.couplerRearCart.rearCartUUID = "";
                            }
                            cart.couplerRearCart.updateCoupledStock(true);
                            cart.couplerRearCart.updateTrain();
                            cart.couplerRearCart.sendUpdateToClient();
                            cart.couplerRearCart = null;
                        }
                    }
                    cart.updateCoupledStock(true);
                    cart.updateTrain();
                    cart.sendUpdateToClient();
                } else {
                    RoWRollingStock.CouplerType secondCoupler;
                    float dist_front = this.dist_p2l(cart.couplerFrontPos.getX(), cart.couplerFrontPos.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                    float dist_rear = this.dist_p2l(cart.couplerRearPos.getX(), cart.couplerRearPos.getZ(), (float)player.field_70165_t, (float)player.field_70161_v, player.field_70177_z + 90.0f);
                    float dx = this.wasFirstCouplerFront ? this.firstCart.couplerFrontPos.getX() : this.firstCart.couplerRearPos.getX();
                    float dz = this.wasFirstCouplerFront ? this.firstCart.couplerFrontPos.getZ() : this.firstCart.couplerRearPos.getZ();
                    float d = (float)Math.hypot(dx -= dist_front < dist_rear ? cart.couplerFrontPos.getX() : cart.couplerRearPos.getX(), dz -= dist_front < dist_rear ? cart.couplerFrontPos.getZ() : cart.couplerRearPos.getZ());
                    RoWRollingStock.CouplerType firstCoupler = this.wasFirstCouplerFront ? this.firstCart.couplerFrontType : this.firstCart.couplerRearType;
                    RoWRollingStock.CouplerType couplerType = secondCoupler = dist_front > dist_rear ? cart.couplerRearType : cart.couplerFrontType;
                    if (firstCoupler != secondCoupler) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.prybar.mismatch", new Object[0]));
                        this.firstCart = null;
                        return true;
                    }
                    if (d > 3.0f) {
                        this.chatMsg = (dist_front < dist_rear ? StatCollector.func_74838_a((String)"row.msg.prybar.front") : StatCollector.func_74838_a((String)"row.msg.prybar.rear")) + " " + StatCollector.func_74838_a((String)"row.msg.prybar.distance");
                        player.func_146105_b((IChatComponent)new ChatComponentText(this.chatMsg));
                        this.firstCart = null;
                        return true;
                    }
                    boolean canCouple = true;
                    if (this.wasFirstCouplerFront && this.firstCart.couplerFrontCart != null) {
                        canCouple = false;
                    } else if (!this.wasFirstCouplerFront && this.firstCart.couplerRearCart != null) {
                        canCouple = false;
                    } else if (dist_front < dist_rear && cart.couplerFrontCart != null) {
                        canCouple = false;
                    } else if (dist_front >= dist_rear && cart.couplerRearCart != null) {
                        canCouple = false;
                    }
                    if (!canCouple) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.prybar.occupied", new Object[0]));
                        this.firstCart = null;
                        return true;
                    }
                    if (this.wasFirstCouplerFront) {
                        this.firstCart.frontCartUUID = cart.UUID;
                    } else {
                        this.firstCart.rearCartUUID = cart.UUID;
                    }
                    if (dist_front < dist_rear) {
                        cart.frontCartUUID = this.firstCart.UUID;
                    } else {
                        cart.rearCartUUID = this.firstCart.UUID;
                    }
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.prybar.done", new Object[0]));
                    cart.updateCoupledStock(true);
                    cart.updateTrain();
                    cart.sendUpdateToClient();
                    this.firstCart.updateCoupledStock(true);
                    this.firstCart.updateTrain();
                    this.firstCart.sendUpdateToClient();
                    this.firstCart = null;
                }
            }
            return true;
        }
        return false;
    }

    public float dist_p2l(float mx, float mz, float qx, float qz, float angle) {
        float k = (float)Math.tan(Math.toRadians(angle));
        float k1 = (float)Math.tan(Math.toRadians(angle + 90.0f));
        float b = qz - k * qx;
        float b1 = mz - k1 * mx;
        float hx = (b - b1) / (k1 - k);
        float hz = k * hx + b;
        return (float)Math.sqrt((hx - mx) * (hx - mx) + (hz - mz) * (hz - mz));
    }
}

