/*
 * Decompiled with CFR 0.152.
 */
package net.row.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.block.BlockGagTrack;
import net.row.block.BlockTrackNormal;
import net.row.helpers.RotationHelper;
import net.row.item.ItemTrack;
import net.row.registry.RoWBlocks;
import net.row.registry.RoWConfig;
import net.row.tileentity.TileEntityTrackNormal;
import org.apache.logging.log4j.Level;

public class ItemWandTrackFixer
extends Item {
    private String msg;

    public ItemWandTrackFixer() {
        this.func_77655_b("row.trackwand");
        this.field_111218_cA = "row:wand_track";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean flag) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.wand_track.1"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.wand_track.2"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.wand_track.3"));
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        if (player.field_70170_p.func_147439_a(x, y, z) instanceof BlockGagTrack && !player.field_70170_p.field_72995_K && RoW.getTrackManager(player.field_70170_p).getMasterTrackPos(new int[]{x, y, z}) == null) {
            player.field_70170_p.func_147468_f(x, y, z);
        }
        return false;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int i, int j, int k, int side, float xOffset, float yOffset, float zOffSet) {
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!world.field_72995_K) {
            int range = RoWConfig.trackRepairRange;
            int count = 0;
            for (int x = i - range; x < i + range; ++x) {
                for (int y = j - 1; y < j + 1; ++y) {
                    for (int z = k - range; z < k + range; ++z) {
                        Block block = world.func_147439_a(x, y, z);
                        if (!(block instanceof BlockTrackNormal)) continue;
                        TileEntityTrackNormal tileEntity = (TileEntityTrackNormal)world.func_147438_o(x, y, z);
                        if (tileEntity != null) {
                            this.msg = StatCollector.func_74838_a((String)"row.msg.wand_track.try") + " " + x + ", " + y + ", " + z;
                            player.func_146105_b((IChatComponent)new ChatComponentText(this.msg));
                            ++count;
                            int mId = tileEntity.type;
                            int dir = world.func_72805_g(x, y, z);
                            try {
                                if (RoW.class.getResourceAsStream("/assets/row/textures/gag_maps_new/r_" + ItemTrack.names[mId] + ".png") == null) {
                                    return false;
                                }
                                BufferedImage img = ImageIO.read(RoW.class.getResourceAsStream("/assets/row/textures/gag_maps_new/r_" + ItemTrack.names[mId] + ".png"));
                                if (img != null) {
                                    for (int w = 0; w > -img.getWidth(); --w) {
                                        for (int h = 0; h < img.getHeight(); ++h) {
                                            int h2 = img.getHeight() - h - 1;
                                            if (-w == ItemTrack.shifts[mId][0] && -h == ItemTrack.shifts[mId][1] || img.getRGB(-w, h2) != -16777216) continue;
                                            int[] shift = RotationHelper.rotateXZByDir(w + ItemTrack.shifts[mId][0], h + ItemTrack.shifts[mId][1], dir);
                                            world.func_147465_d(x + shift[0], y, z + shift[1], RoWBlocks.trackGag, 0, 3);
                                            RoW.getTrackManager(world).addTrack(world, new int[]{x, y, z}, new int[]{x + shift[0], y, z + shift[1]});
                                        }
                                    }
                                }
                                RoW.getTrackManager(world).func_76185_a();
                            }
                            catch (IOException e) {
                                FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, StatCollector.func_74838_a((String)"row.msg.wand_track.bad_files"));
                            }
                            continue;
                        }
                        this.msg = StatCollector.func_74838_a((String)"row.msg.wand_track.tile_pre") + " " + x + ", " + y + ", " + z + StatCollector.func_74838_a((String)"row.msg.wand_track.tile_suf");
                        player.func_146105_b((IChatComponent)new ChatComponentText(this.msg));
                    }
                }
            }
            if (count > 0) {
                player.func_146105_b((IChatComponent)new ChatComponentText("----------"));
            }
        }
        return false;
    }
}

