/*
 * Decompiled with CFR 0.152.
 */
package net.row.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.row.RoW;

public class PacketSendTrackData
implements IMessage {
    private boolean addition;
    private int trackX;
    private int trackY;
    private int trackZ;
    private int partX;
    private int partY;
    private int partZ;

    public PacketSendTrackData() {
    }

    public PacketSendTrackData(int[] masterCoords, int[] partCoords) {
        this.addition = true;
        this.trackX = masterCoords[0];
        this.trackY = masterCoords[1];
        this.trackZ = masterCoords[2];
        this.partX = partCoords[0];
        this.partY = partCoords[1];
        this.partZ = partCoords[2];
    }

    public PacketSendTrackData(int[] masterCoords) {
        this.addition = false;
        this.trackX = masterCoords[0];
        this.trackY = masterCoords[1];
        this.trackZ = masterCoords[2];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.addition);
        buf.writeInt(this.trackX);
        buf.writeInt(this.trackY);
        buf.writeInt(this.trackZ);
        if (this.addition) {
            buf.writeInt(this.partX);
            buf.writeInt(this.partY);
            buf.writeInt(this.partZ);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.addition = buf.readBoolean();
        this.trackX = buf.readInt();
        this.trackY = buf.readInt();
        this.trackZ = buf.readInt();
        if (this.addition) {
            this.partX = buf.readInt();
            this.partY = buf.readInt();
            this.partZ = buf.readInt();
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSendTrackData, IMessage> {
        public IMessage onMessage(PacketSendTrackData message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                if (message.addition) {
                    RoW.getTrackManager(RoW.proxy.getWorldFromPacketCtx(ctx)).addTrack(RoW.proxy.getWorldFromPacketCtx(ctx), new int[]{message.trackX, message.trackY, message.trackZ}, new int[]{message.partX, message.partY, message.partZ});
                } else {
                    RoW.getTrackManager(RoW.proxy.getWorldFromPacketCtx(ctx)).removeTrack(RoW.proxy.getWorldFromPacketCtx(ctx), new int[]{message.trackX, message.trackY, message.trackZ});
                }
            }
            return null;
        }
    }
}

