/*
 * Decompiled with CFR 0.152.
 */
package net.row.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public class PacketSync
implements IMessage {
    private int id;
    private float x;
    private float y;
    private float z;
    private float mx;
    private float my;
    private float mz;
    private boolean forceSync;

    public PacketSync() {
    }

    public PacketSync(int id, float x, float y, float z, float mx, float my, float mz, boolean force) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mx = mx;
        this.my = my;
        this.mz = mz;
        this.forceSync = force;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.mx);
        buf.writeFloat(this.my);
        buf.writeFloat(this.mz);
        buf.writeBoolean(this.forceSync);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.mx = buf.readFloat();
        this.my = buf.readFloat();
        this.mz = buf.readFloat();
        this.forceSync = buf.readBoolean();
    }

    public static void doSync(Entity entity, float dx, float dy, float dz, float dmx, float dmy, float dmz, float p, float pm) {
        entity.func_70056_a(entity.field_70165_t + (double)(p * dx), entity.field_70163_u + (double)(p * dy), entity.field_70161_v + (double)(p * dz), entity.field_70177_z, entity.field_70125_A, 0);
        entity.func_70016_h(entity.field_70159_w + (double)(pm * dmx), entity.field_70181_x + (double)(pm * dmy), entity.field_70179_y + (double)(pm * dmz));
    }

    public static class Handler
    implements IMessageHandler<PacketSync, IMessage> {
        float dx;
        float dy;
        float dz;
        float dmx;
        float dmy;
        float dmz;
        final float errorSQPos = 4.0f;
        final float errorSQMotion = 3.0f;

        public IMessage onMessage(PacketSync message, MessageContext ctx) {
            Entity entity;
            if (ctx.side.isClient() && Minecraft.func_71410_x().field_71441_e != null && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id)) != null) {
                this.dx = (float)((double)message.x - entity.field_70165_t);
                this.dy = (float)((double)message.y - entity.field_70163_u);
                this.dz = (float)((double)message.z - entity.field_70161_v);
                this.dmx = (float)((double)message.mx - entity.field_70159_w);
                this.dmy = (float)((double)message.my - entity.field_70181_x);
                this.dmz = (float)((double)message.mz - entity.field_70179_y);
                if (message.forceSync) {
                    PacketSync.doSync(entity, this.dx, this.dy, this.dz, this.dmx, this.dmy, this.dmz, 0.25f, 0.8f);
                    return null;
                }
                if (this.dx * this.dx + this.dy * this.dy + this.dz * this.dz > 4.0f || this.dmx * this.dmx + this.dmy * this.dmy + this.dmz * this.dmz > 3.0f) {
                    PacketSync.doSync(entity, this.dx, this.dy, this.dz, this.dmx, this.dmy, this.dmz, 0.25f, 0.8f);
                    return null;
                }
            }
            return null;
        }
    }
}

