/*
 * Decompiled with CFR 0.152.
 */
package net.row.registry;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class RoWConfig {
    public static Configuration c;
    public static String GENERAL;
    public static String VISUAL;
    public static String ENERGY;
    public static String WEAPON;
    public static String MISC;
    public static boolean drawDebug;
    public static boolean drawBoxes;
    public static boolean enableDynamicLighting;
    public static boolean ignoreFrustrum;
    public static boolean useTESR;
    public static boolean enableTransparent;
    public static boolean enableNoDepth;
    public static boolean hideFreight;
    public static double[] trackPreviewColour;
    public static boolean useMHP;
    public static int coalFuelValue;
    public static int batteryFuelValue;
    public static float tractiveEffortMult;
    public static boolean invertCannonYAxis;
    public static boolean allowServiceShooting;
    public static boolean allowBlankShooting;
    public static float howitzerStrength;
    public static boolean enableBeltLantern;
    public static boolean applyInventoryGravity;
    public static boolean invertTrackOrder;
    public static int trackRepairRange;
    public static boolean disableTrackError;
    public static boolean automaticDoorClose;
    public static boolean restrictGravelWand;
    public static int gravelWandRange;
    public static boolean allowBreakingCouplings;
    public static float couplingBreakingStretch;
    public static boolean allowBufferPhysics;

    public static void initConfig(File f) {
        c = new Configuration(f);
        try {
            c.load();
            enableDynamicLighting = c.get(VISUAL, "Enable lights for rolling stock and lanterns", true).getBoolean(true);
            ignoreFrustrum = c.get(VISUAL, "Ignore frustum check for rolling stock", true).getBoolean(true);
            useTESR = c.get(VISUAL, "Use TESR (quality) rather than ISBRH (performance) to render tracks", true).getBoolean(true);
            enableTransparent = c.get(VISUAL, "Use transparent model for track preview", true).getBoolean(true);
            enableNoDepth = c.get(VISUAL, "Render track preview model without depth", false).getBoolean(false);
            hideFreight = c.get(VISUAL, "Hide boxcar freight when doors are closed", false).getBoolean(false);
            trackPreviewColour = c.get(VISUAL, "Track preview colour", new double[]{0.6, 0.6, 0.6, 0.6}, "RGBA 0-1", 0.0, 1.0).getDoubleList();
            useMHP = c.get(VISUAL, "Use miles per hour when displaying overhead info", false).getBoolean(false);
            coalFuelValue = c.get(ENERGY, "Coal fuel value", 30).getInt(30);
            batteryFuelValue = c.get(ENERGY, "Battery charge value", 80).getInt(80);
            tractiveEffortMult = (float)c.get(ENERGY, "Locomotive tractive effort multiplier", 1.0, "1.0-10.0", 1.0, 10.0).getDouble(1.0);
            invertCannonYAxis = c.get(WEAPON, "Invert Y-axis when aiming", false).getBoolean(false);
            allowServiceShooting = c.get(WEAPON, "Allow service shooting", false).getBoolean(false);
            allowBlankShooting = c.get(WEAPON, "Allow blank shooting", false).getBoolean(false);
            howitzerStrength = (float)c.get(WEAPON, "Howitzer shot explosion strength", 2.5, "0.0-8.0", 0.0, 8.0).getDouble(2.5);
            enableBeltLantern = c.get(MISC, "Allow carrying lanterns on belt", false).getBoolean(false);
            applyInventoryGravity = c.get(MISC, "Apply gravity to freight car inventories", true).getBoolean(true);
            invertTrackOrder = c.get(MISC, "Invert track laying order to track-preview", true).getBoolean(true);
            trackRepairRange = c.get(MISC, "Track wand scanning range", 64).getInt(64);
            disableTrackError = c.get(MISC, "Disable 'Can't place this track here' message", false).getBoolean(false);
            automaticDoorClose = c.get(MISC, "Allow closing stock doors on enter", false).getBoolean(false);
            restrictGravelWand = c.get(MISC, "Restrict using gravel wand by creative mode", true).getBoolean(true);
            gravelWandRange = c.get(MISC, "Gravel wand action range", 16, "8-32", 8, 32).getInt(16);
            allowBreakingCouplings = c.get(MISC, "Allow couplings to break", true).getBoolean(true);
            couplingBreakingStretch = (float)c.get(MISC, "Coupling breaking stretch", 3.5, "8-32", 3.0, 8.0).getDouble(3.5);
            allowBufferPhysics = c.get(MISC, "Allow experimental buffer physics", false).getBoolean(false);
            FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[RoW] Done loading the config");
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.ERROR, "[RoW] Error occurred while loading the config");
        }
        finally {
            if (c.hasChanged()) {
                c.save();
            }
        }
    }

    static {
        GENERAL = "general";
        VISUAL = "visual";
        ENERGY = "energetics";
        WEAPON = "weaponry";
        MISC = "miscellaneous";
        drawDebug = false;
        drawBoxes = false;
    }
}

