/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.row.block.BlockPlatform;
import net.row.helpers.RenderHelperRoW;

public class RendererPlatform
implements ISimpleBlockRenderingHandler {
    private int blockMetadata;
    private int attachedBlockMetadata;
    private int xOffset;
    private int yOffset;
    private int zOffset;
    private float rotation;
    private Block attachedBlock;
    private IIcon topIcon;
    private IIcon sidesIcon;
    private static final WavefrontObject topModel = new WavefrontObject(new ResourceLocation("row", "models/blocks/platform/Platform_edge_top.obj"));
    private static final WavefrontObject sidesModel = new WavefrontObject(new ResourceLocation("row", "models/blocks/platform/Platform_edge_sides.obj"));
    private static final WavefrontObject tallSidesModel = new WavefrontObject(new ResourceLocation("row", "models/blocks/platform/Platform_edge_sides_tall.obj"));

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.blockMetadata = world.func_72805_g(x, y, z);
        this.topIcon = world.func_147439_a(x, y, z).func_149691_a(1, 0);
        this.xOffset = (this.blockMetadata & 3) == 2 ? -1 : ((this.blockMetadata & 3) == 0 ? 1 : 0);
        this.zOffset = (this.blockMetadata & 3) == 3 ? -1 : ((this.blockMetadata & 3) == 1 ? 1 : 0);
        this.yOffset = Minecraft.func_71410_x().field_71441_e.func_147439_a(x, y - 1, z).equals(block) ? -1 : 0;
        this.attachedBlock = world.func_147439_a(x + this.xOffset, y + this.yOffset, z + this.zOffset);
        this.attachedBlockMetadata = world.func_72805_g(x + this.xOffset, y + this.yOffset, z + this.zOffset);
        if (this.attachedBlock.equals(Blocks.field_150350_a)) {
            this.attachedBlock = block;
        }
        this.sidesIcon = this.attachedBlock.func_149691_a(2, this.attachedBlockMetadata);
        Tessellator.field_78398_a.func_78372_c((float)x + 0.5f, (float)y - (float)(this.blockMetadata & 4) / 8.0f, (float)z + 0.5f);
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z));
        RenderHelperRoW.renderRT(topModel, (float)(this.blockMetadata & 3) * 90.0f, 0.0f, 0.0f, 0.0f, this.topIcon, Tessellator.field_78398_a);
        if ((this.blockMetadata & 0xC) == 0) {
            RenderHelperRoW.renderRT(tallSidesModel, (float)(this.blockMetadata & 3) * 90.0f, 0.0f, 0.0f, 0.0f, this.sidesIcon, Tessellator.field_78398_a);
        } else {
            RenderHelperRoW.renderRT(sidesModel, (float)(this.blockMetadata & 3) * 90.0f, 0.0f, 0.0f, 0.0f, this.sidesIcon, Tessellator.field_78398_a);
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x) - 0.5f, (float)(-y) + (float)(this.blockMetadata & 4) / 8.0f, (float)(-z) - 0.5f);
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return BlockPlatform.renderType;
    }
}

