/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.stock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.row.helpers.LabelHelper;
import net.row.models.coupler.PrimaryCoupler;
import net.row.models.loco.russian.yer.YerBrake;
import net.row.models.loco.russian.yer.YerCabinLong;
import net.row.models.loco.russian.yer.YerCabinShort;
import net.row.models.loco.russian.yer.YerDoorLeft;
import net.row.models.loco.russian.yer.YerDoorRight;
import net.row.models.loco.russian.yer.YerExporodLeft;
import net.row.models.loco.russian.yer.YerExporodRight;
import net.row.models.loco.russian.yer.YerFireboxShutter;
import net.row.models.loco.russian.yer.YerFlyrod;
import net.row.models.loco.russian.yer.YerFrame;
import net.row.models.loco.russian.yer.YerGlass;
import net.row.models.loco.russian.yer.YerMainrodLeft;
import net.row.models.loco.russian.yer.YerMainrodRight;
import net.row.models.loco.russian.yer.YerPistonLeft;
import net.row.models.loco.russian.yer.YerPistonRight;
import net.row.models.loco.russian.yer.YerRegulator;
import net.row.models.loco.russian.yer.YerReverse;
import net.row.models.loco.russian.yer.YerSiderod;
import net.row.models.loco.russian.yer.YerWheelsetInner;
import net.row.models.loco.russian.yer.YerWheelsetOuter;
import net.row.models.loco.russian.yer.YerWhistleRod;
import net.row.renderer.stock.RoWRenderRollingStock;
import net.row.renderer.util.RenderUtils;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.loco.LocoYer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLocoYer
extends RoWRenderRollingStock {
    protected final ModelBase frame = new YerFrame();
    protected final ModelBase cabinShort = new YerCabinShort();
    protected final ModelBase cabinLong = new YerCabinLong();
    protected final ModelBase wheelsetOut = new YerWheelsetOuter();
    protected final ModelBase wheelsetInner = new YerWheelsetInner();
    protected final ModelBase pistonLeft = new YerPistonLeft();
    protected final ModelBase pistonRight = new YerPistonRight();
    protected final ModelBase siderod = new YerSiderod();
    protected final ModelBase mainrodLeft = new YerMainrodLeft();
    protected final ModelBase mainrodRight = new YerMainrodRight();
    protected final ModelBase exporodLeft = new YerExporodLeft();
    protected final ModelBase exporodRight = new YerExporodRight();
    protected final ModelBase flyrod = new YerFlyrod();
    protected final ModelBase coupler = new PrimaryCoupler();
    protected final ModelBase whistleRod = new YerWhistleRod();
    protected final ModelBase regulator = new YerRegulator();
    protected final ModelBase reverse = new YerReverse();
    protected final ModelBase brake = new YerBrake();
    protected final ModelBase fireboxShutter = new YerFireboxShutter();
    protected final ModelBase glass = new YerGlass();
    protected final ModelBase doorLeft = new YerDoorLeft();
    protected final ModelBase doorRight = new YerDoorRight();
    private final WavefrontObject bufferlight = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightBuffer.obj"));
    private final WavefrontObject headlight = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightHead.obj"));
    private final WavefrontObject lightBufferGlow = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightBufferGlow.obj"));
    private final WavefrontObject lightHeadGlow = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightHeadGlow.obj"));
    private final WavefrontObject flames = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ov/backhead/OvFlames.obj"));
    private final ResourceLocation frameTexture = new ResourceLocation("row:textures/stock/loco/yer/frame.png");
    private final ResourceLocation glassTexture = new ResourceLocation("row:textures/stock/loco/yer/glass.png");
    private final ResourceLocation lightTexture = new ResourceLocation("row:textures/stock/spares/lights.png");
    private final ResourceLocation outerWheelTexture = new ResourceLocation("row:textures/stock/loco/yer/yer_wheelset_outer.png");
    private final ResourceLocation innerWheelTexture = new ResourceLocation("row:textures/stock/loco/yer/yer_wheelset_inner.png");
    private final ResourceLocation siderodTexture = new ResourceLocation("row:textures/stock/loco/yer/yer_siderod.png");
    private final ResourceLocation pistonTexture = new ResourceLocation("row:textures/stock/loco/yer/yer_piston.png");
    private final ResourceLocation texture_flames = new ResourceLocation("row:textures/stock/loco/ov/loco_ov_flames.png");
    private float[] flames_color = new float[]{1.0f, 0.0f, 0.0f};
    private LocoYer loco;
    private Random random = new Random();
    private final ResourceLocation[] tex_cabin = new ResourceLocation[3];
    private final ResourceLocation[] tex_cabin_long = new ResourceLocation[3];

    public RenderLocoYer() {
        this.field_76989_e = 1.5f;
        this.tex_cabin_long[0] = new ResourceLocation("row:textures/stock/loco/yer/cabin_long_b.png");
        this.tex_cabin_long[1] = new ResourceLocation("row:textures/stock/loco/yer/cabin_long_p.png");
        this.tex_cabin_long[2] = new ResourceLocation("row:textures/stock/loco/yer/cabin_long_s.png");
        this.tex_cabin[0] = new ResourceLocation("row:textures/stock/loco/yer/cabin_b.png");
        this.tex_cabin[1] = new ResourceLocation("row:textures/stock/loco/yer/cabin_p.png");
        this.tex_cabin[2] = new ResourceLocation("row:textures/stock/loco/yer/cabin_s.png");
    }

    @Override
    public void render(RoWRollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float tick) {
        this.loco = (LocoYer)stock;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glTranslatef((float)0.0f, (float)0.4375f, (float)0.0f);
        GL11.glRotatef((float)(-yaw + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.40625f, (float)0.0f);
        this.func_110776_a(this.frameTexture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        this.frame.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        this.func_110776_a(this.texture_flames);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.53125f, (float)1.875f, (float)0.0f);
        if (this.loco.field_70170_p.func_82737_E() % 2L == 0L) {
            this.flames_color = new float[]{0.9f + this.random.nextFloat() * 0.1f, 0.3f + this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.1f};
        }
        if (this.loco.fuel == 0) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GL11.glColor4f((float)this.flames_color[0], (float)this.flames_color[1], (float)this.flames_color[2], (float)1.0f);
        }
        this.flames.renderAll();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (this.loco.modified == 0) {
            RenderUtils.renderColourable(this.cabinShort, (Entity)this.loco, this.field_76990_c, this.tex_cabin, this.loco.colourPrimary, stock.colourSecondary, false);
        } else {
            RenderUtils.renderColourable(this.cabinLong, (Entity)this.loco, this.field_76990_c, this.tex_cabin_long, this.loco.colourPrimary, stock.colourSecondary, false);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)2.5625f, (float)0.0f, (float)-0.25f);
        GL11.glRotatef((float)(100.0f * (float)this.loco.stokerStage / (float)this.loco.stokerStageMax), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtils.renderColourable(this.fireboxShutter, (Entity)this.loco, this.field_76990_c, this.tex_cabin, this.loco.colourPrimary, stock.colourSecondary, false);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)3.625f, (float)1.3125f, (float)1.375f);
        GL11.glRotatef((float)(-100.0f * this.loco.RSDoor.getStageRelative(tick)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtils.renderColourable(this.doorLeft, (Entity)this.loco, this.field_76990_c, this.tex_cabin, this.loco.colourPrimary, stock.colourSecondary, false);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)3.625f, (float)1.3125f, (float)-1.375f);
        GL11.glRotatef((float)(100.0f * this.loco.RSDoor.getStageRelative(tick)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtils.renderColourable(this.doorRight, (Entity)this.loco, this.field_76990_c, this.tex_cabin, this.loco.colourPrimary, stock.colourSecondary, false);
        GL11.glPopMatrix();
        GL11.glTranslatef((float)1.5f, (float)0.0f, (float)0.0f);
        LabelHelper.drawStockLabel(this.loco.label, 2.125f, 1.5f);
        GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)0.0f);
        this.func_110776_a(this.glassTexture);
        this.glass.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        this.func_110776_a(this.tex_cabin_long[0]);
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)-2.625f, (float)-2.625f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(80.0f * ((float)this.loco.getRegulator() / (float)this.loco.getRegulatorMax() - 0.5f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.regulator.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glPopMatrix();
        float rev = (float)this.loco.reversePrev + (float)(this.loco.reverse - this.loco.reversePrev) * tick;
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)-2.625f, (float)-2.3125f, (float)-0.6875f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-rev / 300.0f * 360.0f * 8.0f - 45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.reverse.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)-2.5f, (float)-2.75f, (float)-1.25f);
        GL11.glRotatef((float)(-120.0f * (float)this.loco.brakeStage / (float)this.loco.brakeStageMax), (float)0.0f, (float)1.0f, (float)0.0f);
        this.brake.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)-2.0625f, (float)-3.5625f, (float)0.0f);
        GL11.glRotatef((float)(7.5f + 25.0f * (float)Math.sin(Math.PI * (double)this.loco.hornStage / 50.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        this.whistleRod.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glPopMatrix();
        this.func_110776_a(this.lightTexture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-3.1875f, (float)1.125f, (float)0.5625f);
        this.bufferlight.renderAll();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.125f);
        this.bufferlight.renderAll();
        GL11.glTranslatef((float)0.4375f, (float)1.78125f, (float)0.5625f);
        this.headlight.renderAll();
        GL11.glPopMatrix();
        if (this.loco.isLightOn) {
            Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-3.1875f, (float)1.125f, (float)0.5625f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.125f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)0.4375f, (float)1.78125f, (float)0.5625f);
            this.lightHeadGlow.renderAll();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
        }
        GL11.glPopMatrix();
        this.func_110776_a(this.outerWheelTexture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.4375f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.loco.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelsetOut.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.4375f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.loco.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelsetOut.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-this.loco.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.innerWheelTexture);
        this.wheelsetInner.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.9375f);
        GL11.glRotatef((float)this.loco.wheelAngle[0], (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.siderodTexture);
        this.siderod.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)(-Math.toDegrees(Math.asin(Math.sin(Math.toRadians(this.loco.wheelAngle[0])) * 4.0 / 22.0)))), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)1.375f, (float)0.0f, (float)0.0625f);
        this.mainrodLeft.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.125f, (float)1.0625f);
        GL11.glRotatef((float)this.loco.wheelAngle[0], (float)0.0f, (float)0.0f, (float)1.0f);
        float k_a = 73.1962f - 23.696f * (float)Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 93.7891f));
        float f_x = (float)(10.0 + Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 90.0f)) * 2.0 - Math.cos(Math.toRadians(k_a)) * 5.0);
        float f_y = (float)(-Math.sin(Math.toRadians(this.loco.wheelAngle[0] - 90.0f)) * 2.0 - 3.5 + Math.sin(Math.toRadians(k_a)) * 5.0);
        GL11.glRotatef((float)((float)Math.toDegrees(Math.atan2(f_y, f_x))), (float)0.0f, (float)0.0f, (float)1.0f);
        this.flyrod.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)-1.125f);
        GL11.glRotatef((float)this.loco.wheelAngle[0], (float)0.0f, (float)0.0f, (float)1.0f);
        k_a = 73.1962f - 23.696f * (float)Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 183.7891f));
        f_x = (float)(10.0 + Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 180.0f)) * 2.0 - Math.cos(Math.toRadians(k_a)) * 5.0);
        f_y = (float)(-Math.sin(Math.toRadians(this.loco.wheelAngle[0] - 180.0f)) * 2.0 - 3.5 + Math.sin(Math.toRadians(k_a)) * 5.0);
        GL11.glRotatef((float)((float)Math.toDegrees(Math.atan2(f_y, f_x))), (float)0.0f, (float)0.0f, (float)1.0f);
        this.flyrod.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)-0.875f);
        GL11.glRotatef((float)this.loco.wheelAngle[0], (float)0.0f, (float)0.0f, (float)1.0f);
        this.siderod.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((float)(-Math.toDegrees(Math.asin(Math.sin(Math.toRadians(this.loco.wheelAngle[0] + 90.0f)) * 4.0 / 22.0)))), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)1.375f, (float)0.0f, (float)-0.0625f);
        this.mainrodRight.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.625f, (float)0.21875f, (float)1.1875f);
        GL11.glRotatef((float)16.8038f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(23.696f * (float)Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 93.7891f))), (float)0.0f, (float)0.0f, (float)1.0f);
        this.exporodLeft.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.625f, (float)0.21875f, (float)-1.1875f);
        GL11.glRotatef((float)16.8038f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(23.696f * (float)Math.cos(Math.toRadians(this.loco.wheelAngle[0] - 183.7891f))), (float)0.0f, (float)0.0f, (float)1.0f);
        this.exporodRight.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.4375f, (float)-0.21875f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(Math.cos(Math.toRadians(this.loco.wheelAngle[0])) * 4.0 / 16.0)), (float)0.0f, (float)1.0625f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.pistonTexture);
        this.pistonLeft.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(Math.cos(Math.toRadians(this.loco.wheelAngle[0] + 90.0f)) * 4.0 / 16.0)), (float)0.0f, (float)-1.0625f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.pistonRight.func_78088_a((Entity)this.loco, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        RenderUtils.renderCouplings(this, this.loco);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private void renderGarlands() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)5.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glBegin((int)3);
        int b2 = 16;
        for (int i = 0; i <= b2; ++i) {
            float f12 = (float)i / (float)b2;
            GL11.glVertex3f((float)1.56f, (float)(2.6f + 2.3f * (f12 * f12) * 0.5f), (float)(-2.8f + 6.9f * f12));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

