/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.stock;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.row.registry.RoWConfig;
import net.row.renderer.util.RenderUtils;
import net.row.stock.UtilStock;
import net.row.stock.core.RoWLocomotive;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.RoWTender;
import net.row.stock.core.plugin.IRSCompressor;
import net.row.stock.loco.LocoYer;

public abstract class RoWRenderRollingStock
extends Render {
    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    abstract void render(RoWRollingStock var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public void func_76986_a(Entity entity, double dx, double dy, double dz, float vanillaYaw, float partialTick) {
        entity.field_70170_p.field_72984_F.func_76320_a("rollingStockRender");
        float yaw = entity.field_70126_B + MathHelper.func_76142_g((float)(entity.field_70177_z - entity.field_70126_B)) * partialTick;
        float pitch = entity.field_70127_C + MathHelper.func_76142_g((float)(entity.field_70125_A - entity.field_70127_C)) * partialTick;
        this.render((RoWRollingStock)entity, (float)dx, (float)dy, (float)dz, yaw, pitch, partialTick);
        if (RoWConfig.drawDebug) {
            this.renderOverheadDebugInfo((RoWRollingStock)entity, (float)dx, (float)dy, (float)dz);
        }
        entity.field_70170_p.field_72984_F.func_76319_b();
    }

    private void renderOverheadDebugInfo(RoWRollingStock stock, float dx, float dy, float dz) {
        RenderUtils.renderOverhead(stock, String.format("...%s", stock.getLastNameLetters(5)), 2.8125f, dx, dy, dz);
        if (RoWConfig.useMHP) {
            RenderUtils.renderOverhead(stock, String.format("%.1f mi/h", Float.valueOf(UtilStock.mpti2miph((float)stock.projectedSpeed))), 2.5f, dx, dy, dz);
        } else {
            RenderUtils.renderOverhead(stock, String.format("%.1f km/h", Float.valueOf(UtilStock.mpti2kmph((float)stock.projectedSpeed))), 2.5f, dx, dy, dz);
        }
        RenderUtils.renderOverhead(stock, String.format("%.3f, %.3f, %.3f", stock.stockTangentX, stock.stockTangentY, stock.stockTangentZ), 2.1875f, dx, dy, dz);
        RenderUtils.renderOverhead(stock, String.format("%.2f / %.2f t", Float.valueOf(stock.workingMass), Float.valueOf(stock.bareMass)), 1.875f, dx, dy, dz);
        if (stock instanceof RoWLocomotive || stock instanceof RoWTender) {
            RenderUtils.renderOverhead(stock, String.format("%.3f / %.3f teu", Float.valueOf((float)stock.fuel / 1000.0f), Float.valueOf((float)stock.fuelCap / 1000.0f)), 1.5625f, dx, dy, dz);
        }
        if (stock instanceof LocoYer) {
            RenderUtils.renderOverhead(stock, String.format("%.3f / %.3f teu", Float.valueOf((float)((LocoYer)stock).tankFuel / 1000.0f), Float.valueOf((float)((LocoYer)stock).tankFuelCap / 1000.0f)), 1.25f, dx, dy, dz);
        }
        if (stock instanceof IRSCompressor) {
            RenderUtils.renderOverhead(stock, String.format("%.2f / %.2f kPa", Float.valueOf(((IRSCompressor)((Object)stock)).getPressure()), Float.valueOf(((IRSCompressor)((Object)stock)).getPressureCap())), 1.25f, dx, dy, dz);
        }
    }
}

