/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.row.helpers.RotationHelper;
import net.row.models.block.pointer.PointerArrow;
import net.row.models.block.pointer.PointerFrame;
import net.row.models.block.pointer.PointerFrameInverted;
import net.row.models.block.pointer.PointerLeverA;
import net.row.models.block.pointer.PointerLeverB;
import net.row.models.block.pointer.PointerLightBox;
import net.row.registry.RoWBlocks;
import net.row.tileentity.TileEntityPointer;
import net.row.tileentity.TileEntityTrackNormal;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RendererPointer
extends TileEntitySpecialRenderer {
    protected final ModelBase frame = new PointerFrame();
    protected final ModelBase frame_inv = new PointerFrameInverted();
    protected final ModelBase levera = new PointerLeverA();
    protected final ModelBase leverb = new PointerLeverB();
    protected final ModelBase arrow = new PointerArrow();
    protected final ModelBase lamp = new PointerLightBox();
    protected final ResourceLocation pointerTexture = new ResourceLocation("row:textures/blocks_maps/pointer.png");

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        TileEntityPointer tile = (TileEntityPointer)tileentity;
        this.renderBlock(tile, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        GL11.glPopMatrix();
    }

    public void renderBlock(TileEntityPointer tile, World world, int i, int j, int k) {
        if (tile != null) {
            boolean flag = true;
            int dir = tile.dir;
            int mtd = world.func_72805_g(i, j, k);
            int[] s = RotationHelper.rotateXZByDir(tile.inverted ? 2 : -2, -1, dir);
            int[] s2 = RotationHelper.rotateXZByDir(tile.inverted ? 2 : -2, -2, dir);
            float[] sh = RotationHelper.rotateXZByDir(tile.inverted ? -0.25f : 0.25f, 0.0f, dir);
            float signAngle = 0.0f;
            float p = 0.0f;
            TileEntityTrackNormal tiler = null;
            if (world.func_147439_a(i + s[0], j, k + s[1]) == RoWBlocks.trackNormal) {
                tiler = (TileEntityTrackNormal)world.func_147438_o(i + s[0], j, k + s[1]);
            } else if (world.func_147439_a(i + s2[0], j, k + s2[1]) == RoWBlocks.trackNormal) {
                tiler = (TileEntityTrackNormal)world.func_147438_o(i + s2[0], j, k + s2[1]);
                if (tiler.type < 17 || tiler.type > 20 && tiler.type < 27 || tiler.type > 32) {
                    tiler = null;
                }
            }
            if (tiler != null) {
                p = tiler.progress;
                boolean bl = flag = (tiler.type & 1) == 1;
                if (tiler.type >= 15 && tiler.type <= 32) {
                    signAngle = -90.0f * p / 10.0f * (float)(flag ? -1 : 1);
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
            GL11.glTranslatef((float)sh[0], (float)0.0f, (float)sh[1]);
            GL11.glRotatef((float)((float)dir * -90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.func_147499_a(this.pointerTexture);
            if (tile.inverted) {
                this.frame.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.frame_inv.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-signAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (mtd == 0) {
                this.arrow.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.lamp.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.03125f);
            GL11.glRotatef((float)((-22.0f + 44.0f * p / 10.0f) * (float)(flag ? 1 : -1)), (float)1.0f, (float)0.0f, (float)0.0f);
            this.levera.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glTranslatef((float)-0.03125f, (float)0.0f, (float)-0.03125f);
            GL11.glRotatef((float)(-180.0f * (10.0f - p) / 10.0f * (float)(flag ? 1 : 0)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-180.0f * p / 10.0f * (float)(!flag ? 1 : 0)), (float)0.0f, (float)1.0f, (float)0.0f);
            this.leverb.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }
}

