/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.row.helpers.RotativePoint;
import net.row.stock.core.RoWRollingStock;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    protected static final WavefrontObject buffer = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/BnC_buffer.obj"));
    protected static final WavefrontObject screw = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/BnC_screw.obj"));
    protected static final ResourceLocation tex_buffer = new ResourceLocation("row:textures/stock/spares/BnC_buffer.png");
    protected static final ResourceLocation tex_screw = new ResourceLocation("row:textures/stock/spares/BnC_screw.png");

    public static void renderColourable(ModelBase model, Entity par1, RenderManager r, ResourceLocation[] tex, int p, int s, boolean f) {
        float light = 1.0f;
        int color = 0xFFFFFF;
        for (int pass = 0; pass < (f ? 3 : 2); ++pass) {
            r.field_78724_e.func_110577_a(tex[pass]);
            switch (pass) {
                case 1: {
                    color = p;
                    break;
                }
                case 2: {
                    color = s;
                }
            }
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * light), (float)(c2 * light), (float)(c3 * light), (float)1.0f);
            model.func_78088_a(par1, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderColourable(WavefrontObject model, Entity par1, RenderManager r, ResourceLocation[] tex, int p, int s, boolean f) {
        float light = 1.0f;
        int color = 0xFFFFFF;
        for (int pass = 0; pass < (f ? 3 : 2); ++pass) {
            r.field_78724_e.func_110577_a(tex[pass]);
            switch (pass) {
                case 1: {
                    color = p;
                    break;
                }
                case 2: {
                    color = s;
                }
            }
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * light), (float)(c2 * light), (float)(c3 * light), (float)1.0f);
            model.renderAll();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCouplings(Render r, RoWRollingStock cart) {
        RenderUtils.renderCouplingByType(r, cart.couplerFrontPos, cart.couplerFrontType, 1);
        RenderUtils.renderCouplingByType(r, cart.couplerRearPos, cart.couplerRearType, -1);
    }

    public static void renderCouplingByType(Render r, RotativePoint coupler, RoWRollingStock.CouplerType type, int flag) {
        if (type == RoWRollingStock.CouplerType.BnC_RUSS) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(90.0f * (float)flag), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)type.height, (float)(-coupler.getRelZ() * (float)flag + type.plate2beam));
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(tex_screw);
            screw.renderAll();
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(tex_buffer);
            GL11.glTranslatef((float)-0.875f, (float)0.0f, (float)0.0f);
            buffer.renderAll();
            GL11.glTranslatef((float)1.75f, (float)0.0f, (float)0.0f);
            buffer.renderAll();
            GL11.glPopMatrix();
        } else if (type == RoWRollingStock.CouplerType.CHER) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(90.0f * (float)flag), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)type.height, (float)(-coupler.getRelZ() * (float)flag + type.plate2beam));
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(tex_screw);
            screw.renderAll();
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(tex_buffer);
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
            buffer.renderAll();
            GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
            buffer.renderAll();
            GL11.glPopMatrix();
        }
    }

    public static void renderOverhead(Entity entity, String s, float h, float dx, float dy, float dz) {
        float renderRange;
        RenderManager rm = RenderManager.field_78727_a;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        double distanceToPlayerSq = entity.func_70068_e((Entity)rm.field_78734_h);
        if (distanceToPlayerSq < (double)((renderRange = 64.0f) * renderRange)) {
            FontRenderer fontrenderer = rm.func_78716_a();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(dx + 0.0f), (float)(dy + entity.field_70131_O + h), (float)dz);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int w = fontrenderer.func_78256_a(s) / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 1.0f);
            tessellator.func_78377_a((double)(-w - 1), -1.0, 0.0);
            tessellator.func_78377_a((double)(-w - 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(w + 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(w + 1), -1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
            fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, 0, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

